/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.query;

import io.cucumber.messages.types.Pickle;
import io.cucumber.query.Lineage;
import io.cucumber.query.LineageReducer;
import io.cucumber.query.NamingCollector;
import java.util.Objects;

public abstract class NamingStrategy
implements LineageReducer<String> {
    public static Builder strategy(Strategy strategy) {
        return new Builder(strategy);
    }

    private NamingStrategy() {
    }

    private static class Adaptor
    extends NamingStrategy {
        private final LineageReducer<String> delegate;

        Adaptor(LineageReducer<String> delegate) {
            this.delegate = delegate;
        }

        @Override
        public String reduce(Lineage lineage) {
            return this.delegate.reduce(lineage);
        }

        @Override
        public String reduce(Lineage lineage, Pickle pickle) {
            return this.delegate.reduce(lineage, pickle);
        }
    }

    public static class Builder {
        private final Strategy strategy;
        private FeatureName featureName = FeatureName.INCLUDE;
        private ExampleName exampleName = ExampleName.NUMBER_AND_PICKLE_IF_PARAMETERIZED;

        public Builder(Strategy strategy) {
            this.strategy = Objects.requireNonNull(strategy);
        }

        public Builder exampleName(ExampleName exampleName) {
            this.exampleName = Objects.requireNonNull(exampleName);
            return this;
        }

        public Builder featureName(FeatureName featureName) {
            this.featureName = Objects.requireNonNull(featureName);
            return this;
        }

        public NamingStrategy build() {
            return new Adaptor(LineageReducer.descending(NamingCollector.of(this.strategy, this.featureName, this.exampleName)));
        }
    }

    public static enum FeatureName {
        INCLUDE,
        EXCLUDE;

    }

    public static enum ExampleName {
        NUMBER,
        PICKLE,
        NUMBER_AND_PICKLE_IF_PARAMETERIZED;

    }

    public static enum Strategy {
        LONG,
        SHORT;

    }
}

