/*
 * Decompiled with CFR 0.152.
 */
package cucumber.api.testng;

import cucumber.runtime.CucumberException;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;

public class FeatureResultListener
implements Reporter {
    static final String PENDING_STATUS = "pending";
    static final String UNDEFINED_MESSAGE = "There are undefined steps";
    static final String PENDING_MESSAGE = "There are pending steps";
    private Reporter reporter;
    private boolean strict;
    private Throwable error = null;

    public FeatureResultListener(Reporter reporter, boolean strict) {
        this.reporter = reporter;
        this.strict = strict;
    }

    public void after(Match match, Result result) {
        this.collectError(result);
        this.reporter.after(match, result);
    }

    public void before(Match match, Result result) {
        this.collectError(result);
        this.reporter.before(match, result);
    }

    public void embedding(String mimeType, byte[] data) {
        this.reporter.embedding(mimeType, data);
    }

    public void match(Match match) {
        this.reporter.match(match);
    }

    public void result(Result result) {
        this.collectError(result);
        this.reporter.result(result);
    }

    private void collectError(Result result) {
        if (result.getStatus().equals("failed")) {
            if (this.error == null || this.isUndefinedError(this.error) || this.isPendingError(this.error)) {
                this.error = result.getError();
            }
        } else if (result.getStatus().equals(PENDING_STATUS) && this.strict) {
            if (this.error == null || this.isUndefinedError(this.error)) {
                this.error = new CucumberException(PENDING_MESSAGE);
            }
        } else if (result.getStatus().equals(Result.UNDEFINED.getStatus()) && this.strict && this.error == null) {
            this.error = new CucumberException(UNDEFINED_MESSAGE);
        }
    }

    private boolean isPendingError(Throwable error) {
        return error instanceof CucumberException && error.getMessage().equals(PENDING_MESSAGE);
    }

    private boolean isUndefinedError(Throwable error) {
        return error instanceof CucumberException && error.getMessage().equals(UNDEFINED_MESSAGE);
    }

    public void write(String text) {
        this.reporter.write(text);
    }

    public boolean isPassed() {
        return this.error == null;
    }

    public Throwable getFirstError() {
        return this.error;
    }

    public void startFeature() {
        this.error = null;
    }
}

