/*
 * Decompiled with CFR 0.152.
 */
package io.csaf.matching;

import io.csaf.matching.Match;
import io.csaf.matching.MatchPropertiesKt;
import io.csaf.matching.MatchingConfidence;
import io.csaf.matching.ProductWithBranches;
import io.csaf.matching.ProductWithBranchesKt;
import io.csaf.schema.generated.Csaf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import protobom.protobom.Document;
import protobom.protobom.Node;
import protobom.protobom.NodeList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00160\u0003j\u0002`\u00172\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u0019\u001a\u00060\u0016j\u0002`\u001a2\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\b\b\u0002\u0010\u0005\u001a\u00020\u0006J(\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0010\u0010 \u001a\f\u0012\b\u0012\u00060\u001dj\u0002`\u001e0\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lio/csaf/matching/Matcher;", "", "documents", "", "Lio/csaf/schema/generated/Csaf;", "threshold", "", "<init>", "(Ljava/util/List;F)V", "getDocuments", "()Ljava/util/List;", "getThreshold", "()F", "products", "Lio/csaf/matching/ProductWithBranches;", "getProducts", "setProducts", "(Ljava/util/List;)V", "matchDatabase", "", "Lio/csaf/matching/Match;", "database", "Lprotobom/protobom/Document;", "Lio/csaf/matching/SBOMDatabase;", "match", "sbom", "Lio/csaf/matching/SBOM;", "matchComponent", "component", "Lprotobom/protobom/Node;", "Lio/csaf/matching/SBOMComponent;", "internalMatch", "components", "csaf-matching"})
@SourceDebugExtension(value={"SMAP\nMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matcher.kt\nio/csaf/matching/Matcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1#2:128\n1374#3:129\n1460#3,5:130\n*S KotlinDebug\n*F\n+ 1 Matcher.kt\nio/csaf/matching/Matcher\n*L\n48#1:129\n48#1:130,5\n*E\n"})
public final class Matcher {
    @NotNull
    private final List<Csaf> documents;
    private final float threshold;
    @NotNull
    private List<ProductWithBranches> products;

    /*
     * WARNING - void declaration
     */
    public Matcher(@NotNull List<Csaf> documents, float threshold) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(documents, (String)"documents");
        this.documents = documents;
        this.threshold = threshold;
        this.products = CollectionsKt.emptyList();
        double d = this.threshold;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean $i$a$-require-Matcher$22 = false;
            String $i$a$-require-Matcher$22 = "Threshold must be in the interval [0.0; 1.0].";
            throw new IllegalArgumentException($i$a$-require-Matcher$22.toString());
        }
        Iterable iterable = this.documents;
        Matcher matcher = this;
        boolean $i$f$flatMap = false;
        void var5_9 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Csaf it = (Csaf)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ProductWithBranchesKt.gatherProductsWithBranches$default(it, null, 1, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        matcher.products = (List)destination$iv$iv;
    }

    public /* synthetic */ Matcher(List list, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.5f;
        }
        this(list, f);
    }

    @NotNull
    public final List<Csaf> getDocuments() {
        return this.documents;
    }

    public final float getThreshold() {
        return this.threshold;
    }

    @NotNull
    public final List<ProductWithBranches> getProducts() {
        return this.products;
    }

    public final void setProducts(@NotNull List<ProductWithBranches> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.products = list;
    }

    @NotNull
    public final Set<Match> matchDatabase(@NotNull List<Document> database, float threshold) {
        Intrinsics.checkNotNullParameter(database, (String)"database");
        Set matches = new LinkedHashSet();
        for (Document document : database) {
            CollectionsKt.addAll((Collection)matches, (Iterable)this.match(document, threshold));
        }
        return matches;
    }

    public static /* synthetic */ Set matchDatabase$default(Matcher matcher, List list, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = matcher.threshold;
        }
        return matcher.matchDatabase(list, f);
    }

    @NotNull
    public final Set<Match> match(@NotNull Document sbom, float threshold) {
        Intrinsics.checkNotNullParameter((Object)sbom, (String)"sbom");
        NodeList nodeList = sbom.getNodeList();
        if (nodeList == null) {
            nodeList = new NodeList(null, null, null, null, 15, null);
        }
        return this.internalMatch(nodeList.getNodes(), threshold);
    }

    public static /* synthetic */ Set match$default(Matcher matcher, Document document, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = matcher.threshold;
        }
        return matcher.match(document, f);
    }

    @NotNull
    public final Set<Match> matchComponent(@NotNull Node component, float threshold) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this.internalMatch(CollectionsKt.listOf((Object)component), threshold);
    }

    public static /* synthetic */ Set matchComponent$default(Matcher matcher, Node node, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = matcher.threshold;
        }
        return matcher.matchComponent(node, f);
    }

    private final Set<Match> internalMatch(List<Node> components, float threshold) {
        double d = threshold;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean bl = false;
            String string = "Threshold must be in the interval [0.0; 1.0].";
            throw new IllegalArgumentException(string.toString());
        }
        Set matches = new LinkedHashSet();
        for (Node component : components) {
            for (ProductWithBranches vulnerableProduct : this.products) {
                MatchingConfidence confidence = MatchPropertiesKt.matchProperties(vulnerableProduct, component);
                if (!(confidence.getValue() >= threshold)) continue;
                ((Collection)matches).add(new Match(vulnerableProduct.getAdvisory(), vulnerableProduct.getProduct(), component, confidence));
            }
        }
        return matches;
    }
}

