@file:OptIn(pbandk.PublicForGeneratedCode::class)

package protobom.protobom

@pbandk.Export
public sealed class HashAlgorithm(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
    override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.HashAlgorithm && other.value == value
    override fun hashCode(): Int = value.hashCode()
    override fun toString(): String = "HashAlgorithm.${name ?: "UNRECOGNIZED"}(value=$value)"

    public object UNKNOWN : HashAlgorithm(0, "UNKNOWN")
    public object MD5 : HashAlgorithm(1, "MD5")
    public object SHA1 : HashAlgorithm(2, "SHA1")
    public object SHA256 : HashAlgorithm(3, "SHA256")
    public object SHA384 : HashAlgorithm(4, "SHA384")
    public object SHA512 : HashAlgorithm(5, "SHA512")
    public object SHA3_256 : HashAlgorithm(6, "SHA3_256")
    public object SHA3_384 : HashAlgorithm(7, "SHA3_384")
    public object SHA3_512 : HashAlgorithm(8, "SHA3_512")
    public object BLAKE2B_256 : HashAlgorithm(9, "BLAKE2B_256")
    public object BLAKE2B_384 : HashAlgorithm(10, "BLAKE2B_384")
    public object BLAKE2B_512 : HashAlgorithm(11, "BLAKE2B_512")
    public object BLAKE3 : HashAlgorithm(12, "BLAKE3")
    public object MD2 : HashAlgorithm(13, "MD2")
    public object ADLER32 : HashAlgorithm(14, "ADLER32")
    public object MD4 : HashAlgorithm(15, "MD4")
    public object MD6 : HashAlgorithm(16, "MD6")
    public object SHA224 : HashAlgorithm(17, "SHA224")
    public class UNRECOGNIZED(value: Int) : HashAlgorithm(value)

    public companion object : pbandk.Message.Enum.Companion<protobom.protobom.HashAlgorithm> {
        public val values: List<protobom.protobom.HashAlgorithm> by lazy { listOf(UNKNOWN, MD5, SHA1, SHA256, SHA384, SHA512, SHA3_256, SHA3_384, SHA3_512, BLAKE2B_256, BLAKE2B_384, BLAKE2B_512, BLAKE3, MD2, ADLER32, MD4, MD6, SHA224) }
        override fun fromValue(value: Int): protobom.protobom.HashAlgorithm = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
        override fun fromName(name: String): protobom.protobom.HashAlgorithm = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No HashAlgorithm with name: $name")
    }
}

@pbandk.Export
public sealed class Purpose(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
    override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.Purpose && other.value == value
    override fun hashCode(): Int = value.hashCode()
    override fun toString(): String = "Purpose.${name ?: "UNRECOGNIZED"}(value=$value)"

    public object UNKNOWN_PURPOSE : Purpose(0, "UNKNOWN_PURPOSE")
    public object APPLICATION : Purpose(1, "APPLICATION")
    public object ARCHIVE : Purpose(2, "ARCHIVE")
    public object BOM : Purpose(3, "BOM")
    public object CONFIGURATION : Purpose(4, "CONFIGURATION")
    public object CONTAINER : Purpose(5, "CONTAINER")
    public object DATA : Purpose(6, "DATA")
    public object DEVICE : Purpose(7, "DEVICE")
    public object DEVICE_DRIVER : Purpose(8, "DEVICE_DRIVER")
    public object DOCUMENTATION : Purpose(9, "DOCUMENTATION")
    public object EVIDENCE : Purpose(10, "EVIDENCE")
    public object EXECUTABLE : Purpose(11, "EXECUTABLE")
    public object FILE : Purpose(12, "FILE")
    public object FIRMWARE : Purpose(13, "FIRMWARE")
    public object FRAMEWORK : Purpose(14, "FRAMEWORK")
    public object INSTALL : Purpose(15, "INSTALL")
    public object LIBRARY : Purpose(16, "LIBRARY")
    public object MACHINE_LEARNING_MODEL : Purpose(17, "MACHINE_LEARNING_MODEL")
    public object MANIFEST : Purpose(18, "MANIFEST")
    public object MODEL : Purpose(19, "MODEL")
    public object MODULE : Purpose(20, "MODULE")
    public object OPERATING_SYSTEM : Purpose(21, "OPERATING_SYSTEM")
    public object OTHER : Purpose(22, "OTHER")
    public object PATCH : Purpose(23, "PATCH")
    public object PLATFORM : Purpose(24, "PLATFORM")
    public object REQUIREMENT : Purpose(25, "REQUIREMENT")
    public object SOURCE : Purpose(26, "SOURCE")
    public object SPECIFICATION : Purpose(27, "SPECIFICATION")
    public object TEST : Purpose(28, "TEST")
    public class UNRECOGNIZED(value: Int) : Purpose(value)

    public companion object : pbandk.Message.Enum.Companion<protobom.protobom.Purpose> {
        public val values: List<protobom.protobom.Purpose> by lazy { listOf(UNKNOWN_PURPOSE, APPLICATION, ARCHIVE, BOM, CONFIGURATION, CONTAINER, DATA, DEVICE, DEVICE_DRIVER, DOCUMENTATION, EVIDENCE, EXECUTABLE, FILE, FIRMWARE, FRAMEWORK, INSTALL, LIBRARY, MACHINE_LEARNING_MODEL, MANIFEST, MODEL, MODULE, OPERATING_SYSTEM, OTHER, PATCH, PLATFORM, REQUIREMENT, SOURCE, SPECIFICATION, TEST) }
        override fun fromValue(value: Int): protobom.protobom.Purpose = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
        override fun fromName(name: String): protobom.protobom.Purpose = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No Purpose with name: $name")
    }
}

@pbandk.Export
public sealed class SoftwareIdentifierType(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
    override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.SoftwareIdentifierType && other.value == value
    override fun hashCode(): Int = value.hashCode()
    override fun toString(): String = "SoftwareIdentifierType.${name ?: "UNRECOGNIZED"}(value=$value)"

    public object UNKNOWN_IDENTIFIER_TYPE : SoftwareIdentifierType(0, "UNKNOWN_IDENTIFIER_TYPE")
    public object PURL : SoftwareIdentifierType(1, "PURL")
    public object CPE22 : SoftwareIdentifierType(2, "CPE22")
    public object CPE23 : SoftwareIdentifierType(3, "CPE23")
    public object GITOID : SoftwareIdentifierType(4, "GITOID")
    public class UNRECOGNIZED(value: Int) : SoftwareIdentifierType(value)

    public companion object : pbandk.Message.Enum.Companion<protobom.protobom.SoftwareIdentifierType> {
        public val values: List<protobom.protobom.SoftwareIdentifierType> by lazy { listOf(UNKNOWN_IDENTIFIER_TYPE, PURL, CPE22, CPE23, GITOID) }
        override fun fromValue(value: Int): protobom.protobom.SoftwareIdentifierType = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
        override fun fromName(name: String): protobom.protobom.SoftwareIdentifierType = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No SoftwareIdentifierType with name: $name")
    }
}

@pbandk.Export
public data class Document(
    val metadata: protobom.protobom.Metadata? = null,
    val nodeList: protobom.protobom.NodeList? = null,
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Document = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Document> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Document> {
        public val defaultInstance: protobom.protobom.Document by lazy { protobom.protobom.Document() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Document = protobom.protobom.Document.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Document> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Document",
            messageClass = protobom.protobom.Document::class,
            messageCompanion = this,
            fields = buildList(2) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "metadata",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Metadata.Companion),
                        jsonName = "metadata",
                        value = protobom.protobom.Document::metadata
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "node_list",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.NodeList.Companion),
                        jsonName = "nodeList",
                        value = protobom.protobom.Document::nodeList
                    )
                )
            }
        )
    }
}

@pbandk.Export
public data class DocumentType(
    val type: protobom.protobom.DocumentType.SBOMType? = null,
    val name: String? = null,
    val description: String? = null,
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.DocumentType = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.DocumentType> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.DocumentType> {
        public val defaultInstance: protobom.protobom.DocumentType by lazy { protobom.protobom.DocumentType() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.DocumentType = protobom.protobom.DocumentType.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.DocumentType> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.DocumentType",
            messageClass = protobom.protobom.DocumentType::class,
            messageCompanion = this,
            fields = buildList(3) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "type",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Enum(enumCompanion = protobom.protobom.DocumentType.SBOMType.Companion, hasPresence = true),
                        jsonName = "type",
                        value = protobom.protobom.DocumentType::type
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "name",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(hasPresence = true),
                        jsonName = "name",
                        value = protobom.protobom.DocumentType::name
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "description",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(hasPresence = true),
                        jsonName = "description",
                        value = protobom.protobom.DocumentType::description
                    )
                )
            }
        )
    }

    public sealed class SBOMType(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
        override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.DocumentType.SBOMType && other.value == value
        override fun hashCode(): Int = value.hashCode()
        override fun toString(): String = "DocumentType.SBOMType.${name ?: "UNRECOGNIZED"}(value=$value)"

        public object OTHER : SBOMType(0, "OTHER")
        public object DESIGN : SBOMType(1, "DESIGN")
        public object SOURCE : SBOMType(2, "SOURCE")
        public object BUILD : SBOMType(3, "BUILD")
        public object ANALYZED : SBOMType(4, "ANALYZED")
        public object DEPLOYED : SBOMType(5, "DEPLOYED")
        public object RUNTIME : SBOMType(6, "RUNTIME")
        public object DISCOVERY : SBOMType(7, "DISCOVERY")
        public object DECOMISSION : SBOMType(8, "DECOMISSION")
        public class UNRECOGNIZED(value: Int) : SBOMType(value)

        public companion object : pbandk.Message.Enum.Companion<protobom.protobom.DocumentType.SBOMType> {
            public val values: List<protobom.protobom.DocumentType.SBOMType> by lazy { listOf(OTHER, DESIGN, SOURCE, BUILD, ANALYZED, DEPLOYED, RUNTIME, DISCOVERY, DECOMISSION) }
            override fun fromValue(value: Int): protobom.protobom.DocumentType.SBOMType = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
            override fun fromName(name: String): protobom.protobom.DocumentType.SBOMType = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No SBOMType with name: $name")
        }
    }
}

@pbandk.Export
public data class Edge(
    val type: protobom.protobom.Edge.Type = protobom.protobom.Edge.Type.fromValue(0),
    val from: String = "",
    val to: List<String> = emptyList(),
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Edge = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Edge> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Edge> {
        public val defaultInstance: protobom.protobom.Edge by lazy { protobom.protobom.Edge() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Edge = protobom.protobom.Edge.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Edge> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Edge",
            messageClass = protobom.protobom.Edge::class,
            messageCompanion = this,
            fields = buildList(3) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "type",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Enum(enumCompanion = protobom.protobom.Edge.Type.Companion),
                        jsonName = "type",
                        value = protobom.protobom.Edge::type
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "from",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "from",
                        value = protobom.protobom.Edge::from
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "to",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Repeated<String>(valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "to",
                        value = protobom.protobom.Edge::to
                    )
                )
            }
        )
    }

    public sealed class Type(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
        override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.Edge.Type && other.value == value
        override fun hashCode(): Int = value.hashCode()
        override fun toString(): String = "Edge.Type.${name ?: "UNRECOGNIZED"}(value=$value)"

        public object UNKNOWN : Type(0, "UNKNOWN")
        public object AMENDS : Type(1, "amends")
        public object ANCESTOR : Type(2, "ancestor")
        public object BUILD_DEPENDENCY : Type(3, "buildDependency")
        public object BUILD_TOOL : Type(4, "buildTool")
        public object CONTAINS : Type(5, "contains")
        public object CONTAINED_BY : Type(6, "contained_by")
        public object COPY : Type(7, "copy")
        public object DATA_FILE : Type(8, "dataFile")
        public object DEPENDENCY_MANIFEST : Type(9, "dependencyManifest")
        public object DEPENDS_ON : Type(10, "dependsOn")
        public object DEPENDENCY_OF : Type(11, "dependencyOf")
        public object DESCENDANT : Type(12, "descendant")
        public object DESCRIBES : Type(13, "describes")
        public object DESCRIBED_BY : Type(14, "describedBy")
        public object DEV_DEPENDENCY : Type(15, "devDependency")
        public object DEV_TOOL : Type(16, "devTool")
        public object DISTRIBUTION_ARTIFACT : Type(17, "distributionArtifact")
        public object DOCUMENTATION : Type(18, "documentation")
        public object DYNAMIC_LINK : Type(19, "dynamicLink")
        public object EXAMPLE : Type(20, "example")
        public object EXPANDED_FROM_ARCHIVE : Type(21, "expandedFromArchive")
        public object FILE_ADDED : Type(22, "fileAdded")
        public object FILE_DELETED : Type(23, "fileDeleted")
        public object FILE_MODIFIED : Type(24, "fileModified")
        public object GENERATES : Type(25, "generates")
        public object GENERATED_FROM : Type(26, "generatedFrom")
        public object METAFILE : Type(27, "metafile")
        public object OPTIONAL_COMPONENT : Type(28, "optionalComponent")
        public object OPTIONAL_DEPENDENCY : Type(29, "optionalDependency")
        public object OTHER : Type(30, "other")
        public object PACKAGES : Type(31, "packages")
        public object PATCH : Type(32, "patch")
        public object PREREQUISITE : Type(33, "prerequisite")
        public object PREREQUISITE_FOR : Type(34, "prerequisiteFor")
        public object PROVIDED_DEPENDENCY : Type(35, "providedDependency")
        public object REQUIREMENT_FOR : Type(36, "requirementFor")
        public object RUNTIME_DEPENDENCY : Type(37, "runtimeDependency")
        public object SPECIFICATION_FOR : Type(38, "specificationFor")
        public object STATIC_LINK : Type(39, "staticLink")
        public object TEST : Type(40, "test")
        public object TEST_CASE : Type(41, "testCase")
        public object TEST_DEPENDENCY : Type(42, "testDependency")
        public object TEST_TOOL : Type(43, "testTool")
        public object VARIANT : Type(44, "variant")
        public class UNRECOGNIZED(value: Int) : Type(value)

        public companion object : pbandk.Message.Enum.Companion<protobom.protobom.Edge.Type> {
            public val values: List<protobom.protobom.Edge.Type> by lazy { listOf(UNKNOWN, AMENDS, ANCESTOR, BUILD_DEPENDENCY, BUILD_TOOL, CONTAINS, CONTAINED_BY, COPY, DATA_FILE, DEPENDENCY_MANIFEST, DEPENDS_ON, DEPENDENCY_OF, DESCENDANT, DESCRIBES, DESCRIBED_BY, DEV_DEPENDENCY, DEV_TOOL, DISTRIBUTION_ARTIFACT, DOCUMENTATION, DYNAMIC_LINK, EXAMPLE, EXPANDED_FROM_ARCHIVE, FILE_ADDED, FILE_DELETED, FILE_MODIFIED, GENERATES, GENERATED_FROM, METAFILE, OPTIONAL_COMPONENT, OPTIONAL_DEPENDENCY, OTHER, PACKAGES, PATCH, PREREQUISITE, PREREQUISITE_FOR, PROVIDED_DEPENDENCY, REQUIREMENT_FOR, RUNTIME_DEPENDENCY, SPECIFICATION_FOR, STATIC_LINK, TEST, TEST_CASE, TEST_DEPENDENCY, TEST_TOOL, VARIANT) }
            override fun fromValue(value: Int): protobom.protobom.Edge.Type = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
            override fun fromName(name: String): protobom.protobom.Edge.Type = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No Type with name: $name")
        }
    }
}

@pbandk.Export
public data class ExternalReference(
    val url: String = "",
    val comment: String = "",
    val authority: String = "",
    val hashes: Map<Int, String> = emptyMap(),
    val type: protobom.protobom.ExternalReference.ExternalReferenceType = protobom.protobom.ExternalReference.ExternalReferenceType.fromValue(0),
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.ExternalReference = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.ExternalReference> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.ExternalReference> {
        public val defaultInstance: protobom.protobom.ExternalReference by lazy { protobom.protobom.ExternalReference() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.ExternalReference = protobom.protobom.ExternalReference.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.ExternalReference> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.ExternalReference",
            messageClass = protobom.protobom.ExternalReference::class,
            messageCompanion = this,
            fields = buildList(5) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "url",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "url",
                        value = protobom.protobom.ExternalReference::url
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "comment",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "comment",
                        value = protobom.protobom.ExternalReference::comment
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "authority",
                        number = 4,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "authority",
                        value = protobom.protobom.ExternalReference::authority
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "hashes",
                        number = 6,
                        type = pbandk.FieldDescriptor.Type.Map<Int, String>(keyType = pbandk.FieldDescriptor.Type.Primitive.Int32(), valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "hashes",
                        value = protobom.protobom.ExternalReference::hashes
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "type",
                        number = 7,
                        type = pbandk.FieldDescriptor.Type.Enum(enumCompanion = protobom.protobom.ExternalReference.ExternalReferenceType.Companion),
                        jsonName = "type",
                        value = protobom.protobom.ExternalReference::type
                    )
                )
            }
        )
    }

    public sealed class ExternalReferenceType(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
        override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.ExternalReference.ExternalReferenceType && other.value == value
        override fun hashCode(): Int = value.hashCode()
        override fun toString(): String = "ExternalReference.ExternalReferenceType.${name ?: "UNRECOGNIZED"}(value=$value)"

        public object UNKNOWN : ExternalReferenceType(0, "UNKNOWN")
        public object ATTESTATION : ExternalReferenceType(1, "ATTESTATION")
        public object BINARY : ExternalReferenceType(2, "BINARY")
        public object BOM : ExternalReferenceType(3, "BOM")
        public object BOWER : ExternalReferenceType(4, "BOWER")
        public object BUILD_META : ExternalReferenceType(5, "BUILD_META")
        public object BUILD_SYSTEM : ExternalReferenceType(6, "BUILD_SYSTEM")
        public object CERTIFICATION_REPORT : ExternalReferenceType(7, "CERTIFICATION_REPORT")
        public object CHAT : ExternalReferenceType(8, "CHAT")
        public object CODIFIED_INFRASTRUCTURE : ExternalReferenceType(9, "CODIFIED_INFRASTRUCTURE")
        public object COMPONENT_ANALYSIS_REPORT : ExternalReferenceType(10, "COMPONENT_ANALYSIS_REPORT")
        public object CONFIGURATION : ExternalReferenceType(11, "CONFIGURATION")
        public object DISTRIBUTION_INTAKE : ExternalReferenceType(12, "DISTRIBUTION_INTAKE")
        public object DOCUMENTATION : ExternalReferenceType(13, "DOCUMENTATION")
        public object DOWNLOAD : ExternalReferenceType(14, "DOWNLOAD")
        public object DYNAMIC_ANALYSIS_REPORT : ExternalReferenceType(15, "DYNAMIC_ANALYSIS_REPORT")
        public object EOL_NOTICE : ExternalReferenceType(16, "EOL_NOTICE")
        public object EVIDENCE : ExternalReferenceType(17, "EVIDENCE")
        public object EXPORT_CONTROL_ASSESSMENT : ExternalReferenceType(18, "EXPORT_CONTROL_ASSESSMENT")
        public object FORMULATION : ExternalReferenceType(19, "FORMULATION")
        public object FUNDING : ExternalReferenceType(20, "FUNDING")
        public object ISSUE_TRACKER : ExternalReferenceType(21, "ISSUE_TRACKER")
        public object LICENSE : ExternalReferenceType(22, "LICENSE")
        public object LOG : ExternalReferenceType(23, "LOG")
        public object MAILING_LIST : ExternalReferenceType(24, "MAILING_LIST")
        public object MATURITY_REPORT : ExternalReferenceType(25, "MATURITY_REPORT")
        public object MAVEN_CENTRAL : ExternalReferenceType(26, "MAVEN_CENTRAL")
        public object METRICS : ExternalReferenceType(27, "METRICS")
        public object MODEL_CARD : ExternalReferenceType(28, "MODEL_CARD")
        public object NPM : ExternalReferenceType(29, "NPM")
        public object NUGET : ExternalReferenceType(30, "NUGET")
        public object OTHER : ExternalReferenceType(31, "OTHER")
        public object POAM : ExternalReferenceType(32, "POAM")
        public object PRIVACY_ASSESSMENT : ExternalReferenceType(33, "PRIVACY_ASSESSMENT")
        public object PRODUCT_METADATA : ExternalReferenceType(34, "PRODUCT_METADATA")
        public object PURCHASE_ORDER : ExternalReferenceType(35, "PURCHASE_ORDER")
        public object QUALITY_ASSESSMENT_REPORT : ExternalReferenceType(36, "QUALITY_ASSESSMENT_REPORT")
        public object QUALITY_METRICS : ExternalReferenceType(37, "QUALITY_METRICS")
        public object RELEASE_HISTORY : ExternalReferenceType(38, "RELEASE_HISTORY")
        public object RELEASE_NOTES : ExternalReferenceType(39, "RELEASE_NOTES")
        public object RISK_ASSESSMENT : ExternalReferenceType(40, "RISK_ASSESSMENT")
        public object RUNTIME_ANALYSIS_REPORT : ExternalReferenceType(41, "RUNTIME_ANALYSIS_REPORT")
        public object SECURE_SOFTWARE_ATTESTATION : ExternalReferenceType(42, "SECURE_SOFTWARE_ATTESTATION")
        public object SECURITY_ADVERSARY_MODEL : ExternalReferenceType(43, "SECURITY_ADVERSARY_MODEL")
        public object SECURITY_ADVISORY : ExternalReferenceType(44, "SECURITY_ADVISORY")
        public object SECURITY_CONTACT : ExternalReferenceType(45, "SECURITY_CONTACT")
        public object SECURITY_FIX : ExternalReferenceType(46, "SECURITY_FIX")
        public object SECURITY_OTHER : ExternalReferenceType(47, "SECURITY_OTHER")
        public object SECURITY_PENTEST_REPORT : ExternalReferenceType(48, "SECURITY_PENTEST_REPORT")
        public object SECURITY_POLICY : ExternalReferenceType(49, "SECURITY_POLICY")
        public object SECURITY_SWID : ExternalReferenceType(50, "SECURITY_SWID")
        public object SECURITY_THREAT_MODEL : ExternalReferenceType(51, "SECURITY_THREAT_MODEL")
        public object SOCIAL : ExternalReferenceType(52, "SOCIAL")
        public object SOURCE_ARTIFACT : ExternalReferenceType(53, "SOURCE_ARTIFACT")
        public object STATIC_ANALYSIS_REPORT : ExternalReferenceType(54, "STATIC_ANALYSIS_REPORT")
        public object SUPPORT : ExternalReferenceType(55, "SUPPORT")
        public object VCS : ExternalReferenceType(56, "VCS")
        public object VULNERABILITY_ASSERTION : ExternalReferenceType(57, "VULNERABILITY_ASSERTION")
        public object VULNERABILITY_DISCLOSURE_REPORT : ExternalReferenceType(58, "VULNERABILITY_DISCLOSURE_REPORT")
        public object VULNERABILITY_EXPLOITABILITY_ASSESSMENT : ExternalReferenceType(59, "VULNERABILITY_EXPLOITABILITY_ASSESSMENT")
        public object WEBSITE : ExternalReferenceType(60, "WEBSITE")
        public class UNRECOGNIZED(value: Int) : ExternalReferenceType(value)

        public companion object : pbandk.Message.Enum.Companion<protobom.protobom.ExternalReference.ExternalReferenceType> {
            public val values: List<protobom.protobom.ExternalReference.ExternalReferenceType> by lazy { listOf(UNKNOWN, ATTESTATION, BINARY, BOM, BOWER, BUILD_META, BUILD_SYSTEM, CERTIFICATION_REPORT, CHAT, CODIFIED_INFRASTRUCTURE, COMPONENT_ANALYSIS_REPORT, CONFIGURATION, DISTRIBUTION_INTAKE, DOCUMENTATION, DOWNLOAD, DYNAMIC_ANALYSIS_REPORT, EOL_NOTICE, EVIDENCE, EXPORT_CONTROL_ASSESSMENT, FORMULATION, FUNDING, ISSUE_TRACKER, LICENSE, LOG, MAILING_LIST, MATURITY_REPORT, MAVEN_CENTRAL, METRICS, MODEL_CARD, NPM, NUGET, OTHER, POAM, PRIVACY_ASSESSMENT, PRODUCT_METADATA, PURCHASE_ORDER, QUALITY_ASSESSMENT_REPORT, QUALITY_METRICS, RELEASE_HISTORY, RELEASE_NOTES, RISK_ASSESSMENT, RUNTIME_ANALYSIS_REPORT, SECURE_SOFTWARE_ATTESTATION, SECURITY_ADVERSARY_MODEL, SECURITY_ADVISORY, SECURITY_CONTACT, SECURITY_FIX, SECURITY_OTHER, SECURITY_PENTEST_REPORT, SECURITY_POLICY, SECURITY_SWID, SECURITY_THREAT_MODEL, SOCIAL, SOURCE_ARTIFACT, STATIC_ANALYSIS_REPORT, SUPPORT, VCS, VULNERABILITY_ASSERTION, VULNERABILITY_DISCLOSURE_REPORT, VULNERABILITY_EXPLOITABILITY_ASSESSMENT, WEBSITE) }
            override fun fromValue(value: Int): protobom.protobom.ExternalReference.ExternalReferenceType = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
            override fun fromName(name: String): protobom.protobom.ExternalReference.ExternalReferenceType = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No ExternalReferenceType with name: $name")
        }
    }

    public data class HashesEntry(
        override val key: Int = 0,
        override val value: String = "",
        override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
    ) : pbandk.Message, Map.Entry<Int, String> {
        override operator fun plus(other: pbandk.Message?): protobom.protobom.ExternalReference.HashesEntry = protoMergeImpl(other)
        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.ExternalReference.HashesEntry> get() = Companion.descriptor
        override val protoSize: Int by lazy { super.protoSize }
        public companion object : pbandk.Message.Companion<protobom.protobom.ExternalReference.HashesEntry> {
            public val defaultInstance: protobom.protobom.ExternalReference.HashesEntry by lazy { protobom.protobom.ExternalReference.HashesEntry() }
            override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.ExternalReference.HashesEntry = protobom.protobom.ExternalReference.HashesEntry.decodeWithImpl(u)

            override val descriptor: pbandk.MessageDescriptor<protobom.protobom.ExternalReference.HashesEntry> = pbandk.MessageDescriptor(
                fullName = "protobom.protobom.ExternalReference.HashesEntry",
                messageClass = protobom.protobom.ExternalReference.HashesEntry::class,
                messageCompanion = this,
                fields = buildList(2) {
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "key",
                            number = 1,
                            type = pbandk.FieldDescriptor.Type.Primitive.Int32(),
                            jsonName = "key",
                            value = protobom.protobom.ExternalReference.HashesEntry::key
                        )
                    )
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "value",
                            number = 2,
                            type = pbandk.FieldDescriptor.Type.Primitive.String(),
                            jsonName = "value",
                            value = protobom.protobom.ExternalReference.HashesEntry::value
                        )
                    )
                }
            )
        }
    }
}

@pbandk.Export
public data class Metadata(
    val id: String = "",
    val version: String = "",
    val name: String = "",
    val date: com.google.protobuf.Timestamp? = null,
    val tools: List<protobom.protobom.Tool> = emptyList(),
    val authors: List<protobom.protobom.Person> = emptyList(),
    val comment: String = "",
    val documentTypes: List<protobom.protobom.DocumentType> = emptyList(),
    val sourceData: protobom.protobom.SourceData? = null,
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Metadata = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Metadata> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Metadata> {
        public val defaultInstance: protobom.protobom.Metadata by lazy { protobom.protobom.Metadata() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Metadata = protobom.protobom.Metadata.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Metadata> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Metadata",
            messageClass = protobom.protobom.Metadata::class,
            messageCompanion = this,
            fields = buildList(9) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "id",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "id",
                        value = protobom.protobom.Metadata::id
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "version",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "version",
                        value = protobom.protobom.Metadata::version
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "name",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "name",
                        value = protobom.protobom.Metadata::name
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "date",
                        number = 4,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = com.google.protobuf.Timestamp.Companion),
                        jsonName = "date",
                        value = protobom.protobom.Metadata::date
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "tools",
                        number = 5,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Tool>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Tool.Companion)),
                        jsonName = "tools",
                        value = protobom.protobom.Metadata::tools
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "authors",
                        number = 6,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Person>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Person.Companion)),
                        jsonName = "authors",
                        value = protobom.protobom.Metadata::authors
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "comment",
                        number = 7,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "comment",
                        value = protobom.protobom.Metadata::comment
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "documentTypes",
                        number = 8,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.DocumentType>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.DocumentType.Companion)),
                        jsonName = "documentTypes",
                        value = protobom.protobom.Metadata::documentTypes
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "source_data",
                        number = 9,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.SourceData.Companion),
                        jsonName = "sourceData",
                        value = protobom.protobom.Metadata::sourceData
                    )
                )
            }
        )
    }
}

@pbandk.Export
public data class Node(
    val id: String = "",
    val type: protobom.protobom.Node.NodeType = protobom.protobom.Node.NodeType.fromValue(0),
    val name: String = "",
    val version: String = "",
    val fileName: String = "",
    val urlHome: String = "",
    val urlDownload: String = "",
    val licenses: List<String> = emptyList(),
    val licenseConcluded: String = "",
    val licenseComments: String = "",
    val copyright: String = "",
    val sourceInfo: String = "",
    val comment: String = "",
    val summary: String = "",
    val description: String = "",
    val attribution: List<String> = emptyList(),
    val suppliers: List<protobom.protobom.Person> = emptyList(),
    val originators: List<protobom.protobom.Person> = emptyList(),
    val releaseDate: com.google.protobuf.Timestamp? = null,
    val buildDate: com.google.protobuf.Timestamp? = null,
    val validUntilDate: com.google.protobuf.Timestamp? = null,
    val externalReferences: List<protobom.protobom.ExternalReference> = emptyList(),
    val fileTypes: List<String> = emptyList(),
    val identifiers: Map<Int, String> = emptyMap(),
    val hashes: Map<Int, String> = emptyMap(),
    val primaryPurpose: List<protobom.protobom.Purpose> = emptyList(),
    val properties: List<protobom.protobom.Property> = emptyList(),
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Node = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Node> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Node> {
        public val defaultInstance: protobom.protobom.Node by lazy { protobom.protobom.Node() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Node = protobom.protobom.Node.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Node> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Node",
            messageClass = protobom.protobom.Node::class,
            messageCompanion = this,
            fields = buildList(27) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "id",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "id",
                        value = protobom.protobom.Node::id
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "type",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Enum(enumCompanion = protobom.protobom.Node.NodeType.Companion),
                        jsonName = "type",
                        value = protobom.protobom.Node::type
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "name",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "name",
                        value = protobom.protobom.Node::name
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "version",
                        number = 4,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "version",
                        value = protobom.protobom.Node::version
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "file_name",
                        number = 5,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "fileName",
                        value = protobom.protobom.Node::fileName
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "url_home",
                        number = 6,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "urlHome",
                        value = protobom.protobom.Node::urlHome
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "url_download",
                        number = 7,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "urlDownload",
                        value = protobom.protobom.Node::urlDownload
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "licenses",
                        number = 8,
                        type = pbandk.FieldDescriptor.Type.Repeated<String>(valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "licenses",
                        value = protobom.protobom.Node::licenses
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "license_concluded",
                        number = 9,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "licenseConcluded",
                        value = protobom.protobom.Node::licenseConcluded
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "license_comments",
                        number = 10,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "licenseComments",
                        value = protobom.protobom.Node::licenseComments
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "copyright",
                        number = 11,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "copyright",
                        value = protobom.protobom.Node::copyright
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "source_info",
                        number = 13,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "sourceInfo",
                        value = protobom.protobom.Node::sourceInfo
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "comment",
                        number = 15,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "comment",
                        value = protobom.protobom.Node::comment
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "summary",
                        number = 16,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "summary",
                        value = protobom.protobom.Node::summary
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "description",
                        number = 17,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "description",
                        value = protobom.protobom.Node::description
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "attribution",
                        number = 18,
                        type = pbandk.FieldDescriptor.Type.Repeated<String>(valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "attribution",
                        value = protobom.protobom.Node::attribution
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "suppliers",
                        number = 19,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Person>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Person.Companion)),
                        jsonName = "suppliers",
                        value = protobom.protobom.Node::suppliers
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "originators",
                        number = 20,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Person>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Person.Companion)),
                        jsonName = "originators",
                        value = protobom.protobom.Node::originators
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "release_date",
                        number = 21,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = com.google.protobuf.Timestamp.Companion),
                        jsonName = "releaseDate",
                        value = protobom.protobom.Node::releaseDate
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "build_date",
                        number = 22,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = com.google.protobuf.Timestamp.Companion),
                        jsonName = "buildDate",
                        value = protobom.protobom.Node::buildDate
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "valid_until_date",
                        number = 23,
                        type = pbandk.FieldDescriptor.Type.Message(messageCompanion = com.google.protobuf.Timestamp.Companion),
                        jsonName = "validUntilDate",
                        value = protobom.protobom.Node::validUntilDate
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "external_references",
                        number = 24,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.ExternalReference>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.ExternalReference.Companion)),
                        jsonName = "externalReferences",
                        value = protobom.protobom.Node::externalReferences
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "file_types",
                        number = 27,
                        type = pbandk.FieldDescriptor.Type.Repeated<String>(valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "fileTypes",
                        value = protobom.protobom.Node::fileTypes
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "identifiers",
                        number = 28,
                        type = pbandk.FieldDescriptor.Type.Map<Int, String>(keyType = pbandk.FieldDescriptor.Type.Primitive.Int32(), valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "identifiers",
                        value = protobom.protobom.Node::identifiers
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "hashes",
                        number = 29,
                        type = pbandk.FieldDescriptor.Type.Map<Int, String>(keyType = pbandk.FieldDescriptor.Type.Primitive.Int32(), valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "hashes",
                        value = protobom.protobom.Node::hashes
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "primary_purpose",
                        number = 30,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Purpose>(valueType = pbandk.FieldDescriptor.Type.Enum(enumCompanion = protobom.protobom.Purpose.Companion), packed = true),
                        jsonName = "primaryPurpose",
                        value = protobom.protobom.Node::primaryPurpose
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "properties",
                        number = 31,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Property>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Property.Companion)),
                        jsonName = "properties",
                        value = protobom.protobom.Node::properties
                    )
                )
            }
        )
    }

    public sealed class NodeType(override val value: Int, override val name: String? = null) : pbandk.Message.Enum {
        override fun equals(other: kotlin.Any?): Boolean = other is protobom.protobom.Node.NodeType && other.value == value
        override fun hashCode(): Int = value.hashCode()
        override fun toString(): String = "Node.NodeType.${name ?: "UNRECOGNIZED"}(value=$value)"

        public object PACKAGE : NodeType(0, "PACKAGE")
        public object FILE : NodeType(1, "FILE")
        public class UNRECOGNIZED(value: Int) : NodeType(value)

        public companion object : pbandk.Message.Enum.Companion<protobom.protobom.Node.NodeType> {
            public val values: List<protobom.protobom.Node.NodeType> by lazy { listOf(PACKAGE, FILE) }
            override fun fromValue(value: Int): protobom.protobom.Node.NodeType = values.firstOrNull { it.value == value } ?: UNRECOGNIZED(value)
            override fun fromName(name: String): protobom.protobom.Node.NodeType = values.firstOrNull { it.name == name } ?: throw IllegalArgumentException("No NodeType with name: $name")
        }
    }

    public data class IdentifiersEntry(
        override val key: Int = 0,
        override val value: String = "",
        override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
    ) : pbandk.Message, Map.Entry<Int, String> {
        override operator fun plus(other: pbandk.Message?): protobom.protobom.Node.IdentifiersEntry = protoMergeImpl(other)
        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Node.IdentifiersEntry> get() = Companion.descriptor
        override val protoSize: Int by lazy { super.protoSize }
        public companion object : pbandk.Message.Companion<protobom.protobom.Node.IdentifiersEntry> {
            public val defaultInstance: protobom.protobom.Node.IdentifiersEntry by lazy { protobom.protobom.Node.IdentifiersEntry() }
            override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Node.IdentifiersEntry = protobom.protobom.Node.IdentifiersEntry.decodeWithImpl(u)

            override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Node.IdentifiersEntry> = pbandk.MessageDescriptor(
                fullName = "protobom.protobom.Node.IdentifiersEntry",
                messageClass = protobom.protobom.Node.IdentifiersEntry::class,
                messageCompanion = this,
                fields = buildList(2) {
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "key",
                            number = 1,
                            type = pbandk.FieldDescriptor.Type.Primitive.Int32(),
                            jsonName = "key",
                            value = protobom.protobom.Node.IdentifiersEntry::key
                        )
                    )
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "value",
                            number = 2,
                            type = pbandk.FieldDescriptor.Type.Primitive.String(),
                            jsonName = "value",
                            value = protobom.protobom.Node.IdentifiersEntry::value
                        )
                    )
                }
            )
        }
    }

    public data class HashesEntry(
        override val key: Int = 0,
        override val value: String = "",
        override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
    ) : pbandk.Message, Map.Entry<Int, String> {
        override operator fun plus(other: pbandk.Message?): protobom.protobom.Node.HashesEntry = protoMergeImpl(other)
        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Node.HashesEntry> get() = Companion.descriptor
        override val protoSize: Int by lazy { super.protoSize }
        public companion object : pbandk.Message.Companion<protobom.protobom.Node.HashesEntry> {
            public val defaultInstance: protobom.protobom.Node.HashesEntry by lazy { protobom.protobom.Node.HashesEntry() }
            override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Node.HashesEntry = protobom.protobom.Node.HashesEntry.decodeWithImpl(u)

            override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Node.HashesEntry> = pbandk.MessageDescriptor(
                fullName = "protobom.protobom.Node.HashesEntry",
                messageClass = protobom.protobom.Node.HashesEntry::class,
                messageCompanion = this,
                fields = buildList(2) {
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "key",
                            number = 1,
                            type = pbandk.FieldDescriptor.Type.Primitive.Int32(),
                            jsonName = "key",
                            value = protobom.protobom.Node.HashesEntry::key
                        )
                    )
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "value",
                            number = 2,
                            type = pbandk.FieldDescriptor.Type.Primitive.String(),
                            jsonName = "value",
                            value = protobom.protobom.Node.HashesEntry::value
                        )
                    )
                }
            )
        }
    }
}

@pbandk.Export
public data class NodeList(
    val nodes: List<protobom.protobom.Node> = emptyList(),
    val edges: List<protobom.protobom.Edge> = emptyList(),
    val rootElements: List<String> = emptyList(),
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.NodeList = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.NodeList> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.NodeList> {
        public val defaultInstance: protobom.protobom.NodeList by lazy { protobom.protobom.NodeList() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.NodeList = protobom.protobom.NodeList.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.NodeList> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.NodeList",
            messageClass = protobom.protobom.NodeList::class,
            messageCompanion = this,
            fields = buildList(3) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "nodes",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Node>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Node.Companion)),
                        jsonName = "nodes",
                        value = protobom.protobom.NodeList::nodes
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "edges",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Edge>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Edge.Companion)),
                        jsonName = "edges",
                        value = protobom.protobom.NodeList::edges
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "root_elements",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Repeated<String>(valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "rootElements",
                        value = protobom.protobom.NodeList::rootElements
                    )
                )
            }
        )
    }
}

@pbandk.Export
public data class Person(
    val name: String = "",
    val isOrg: Boolean = false,
    val email: String = "",
    val url: String = "",
    val phone: String = "",
    val contacts: List<protobom.protobom.Person> = emptyList(),
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Person = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Person> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Person> {
        public val defaultInstance: protobom.protobom.Person by lazy { protobom.protobom.Person() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Person = protobom.protobom.Person.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Person> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Person",
            messageClass = protobom.protobom.Person::class,
            messageCompanion = this,
            fields = buildList(6) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "name",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "name",
                        value = protobom.protobom.Person::name
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "is_org",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Primitive.Bool(),
                        jsonName = "isOrg",
                        value = protobom.protobom.Person::isOrg
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "email",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "email",
                        value = protobom.protobom.Person::email
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "url",
                        number = 4,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "url",
                        value = protobom.protobom.Person::url
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "phone",
                        number = 5,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "phone",
                        value = protobom.protobom.Person::phone
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "contacts",
                        number = 6,
                        type = pbandk.FieldDescriptor.Type.Repeated<protobom.protobom.Person>(valueType = pbandk.FieldDescriptor.Type.Message(messageCompanion = protobom.protobom.Person.Companion)),
                        jsonName = "contacts",
                        value = protobom.protobom.Person::contacts
                    )
                )
            }
        )
    }
}

@pbandk.Export
public data class Property(
    val name: String = "",
    val data: String = "",
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Property = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Property> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Property> {
        public val defaultInstance: protobom.protobom.Property by lazy { protobom.protobom.Property() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Property = protobom.protobom.Property.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Property> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Property",
            messageClass = protobom.protobom.Property::class,
            messageCompanion = this,
            fields = buildList(2) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "name",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "name",
                        value = protobom.protobom.Property::name
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "data",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "data",
                        value = protobom.protobom.Property::data
                    )
                )
            }
        )
    }
}

@pbandk.Export
public data class SourceData(
    val format: String = "",
    val hashes: Map<Int, String> = emptyMap(),
    val size: Long = 0L,
    val uri: String? = null,
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.SourceData = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.SourceData> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.SourceData> {
        public val defaultInstance: protobom.protobom.SourceData by lazy { protobom.protobom.SourceData() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.SourceData = protobom.protobom.SourceData.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.SourceData> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.SourceData",
            messageClass = protobom.protobom.SourceData::class,
            messageCompanion = this,
            fields = buildList(4) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "format",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "format",
                        value = protobom.protobom.SourceData::format
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "hashes",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Map<Int, String>(keyType = pbandk.FieldDescriptor.Type.Primitive.Int32(), valueType = pbandk.FieldDescriptor.Type.Primitive.String()),
                        jsonName = "hashes",
                        value = protobom.protobom.SourceData::hashes
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "size",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.Int64(),
                        jsonName = "size",
                        value = protobom.protobom.SourceData::size
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "uri",
                        number = 4,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(hasPresence = true),
                        jsonName = "uri",
                        value = protobom.protobom.SourceData::uri
                    )
                )
            }
        )
    }

    public data class HashesEntry(
        override val key: Int = 0,
        override val value: String = "",
        override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
    ) : pbandk.Message, Map.Entry<Int, String> {
        override operator fun plus(other: pbandk.Message?): protobom.protobom.SourceData.HashesEntry = protoMergeImpl(other)
        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.SourceData.HashesEntry> get() = Companion.descriptor
        override val protoSize: Int by lazy { super.protoSize }
        public companion object : pbandk.Message.Companion<protobom.protobom.SourceData.HashesEntry> {
            public val defaultInstance: protobom.protobom.SourceData.HashesEntry by lazy { protobom.protobom.SourceData.HashesEntry() }
            override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.SourceData.HashesEntry = protobom.protobom.SourceData.HashesEntry.decodeWithImpl(u)

            override val descriptor: pbandk.MessageDescriptor<protobom.protobom.SourceData.HashesEntry> = pbandk.MessageDescriptor(
                fullName = "protobom.protobom.SourceData.HashesEntry",
                messageClass = protobom.protobom.SourceData.HashesEntry::class,
                messageCompanion = this,
                fields = buildList(2) {
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "key",
                            number = 1,
                            type = pbandk.FieldDescriptor.Type.Primitive.Int32(),
                            jsonName = "key",
                            value = protobom.protobom.SourceData.HashesEntry::key
                        )
                    )
                    add(
                        pbandk.FieldDescriptor(
                            messageDescriptor = this@Companion::descriptor,
                            name = "value",
                            number = 2,
                            type = pbandk.FieldDescriptor.Type.Primitive.String(),
                            jsonName = "value",
                            value = protobom.protobom.SourceData.HashesEntry::value
                        )
                    )
                }
            )
        }
    }
}

@pbandk.Export
public data class Tool(
    val name: String = "",
    val version: String = "",
    val vendor: String = "",
    override val unknownFields: Map<Int, pbandk.UnknownField> = emptyMap()
) : pbandk.Message {
    override operator fun plus(other: pbandk.Message?): protobom.protobom.Tool = protoMergeImpl(other)
    override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Tool> get() = Companion.descriptor
    override val protoSize: Int by lazy { super.protoSize }
    public companion object : pbandk.Message.Companion<protobom.protobom.Tool> {
        public val defaultInstance: protobom.protobom.Tool by lazy { protobom.protobom.Tool() }
        override fun decodeWith(u: pbandk.MessageDecoder): protobom.protobom.Tool = protobom.protobom.Tool.decodeWithImpl(u)

        override val descriptor: pbandk.MessageDescriptor<protobom.protobom.Tool> = pbandk.MessageDescriptor(
            fullName = "protobom.protobom.Tool",
            messageClass = protobom.protobom.Tool::class,
            messageCompanion = this,
            fields = buildList(3) {
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "name",
                        number = 1,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "name",
                        value = protobom.protobom.Tool::name
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "version",
                        number = 2,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "version",
                        value = protobom.protobom.Tool::version
                    )
                )
                add(
                    pbandk.FieldDescriptor(
                        messageDescriptor = this@Companion::descriptor,
                        name = "vendor",
                        number = 3,
                        type = pbandk.FieldDescriptor.Type.Primitive.String(),
                        jsonName = "vendor",
                        value = protobom.protobom.Tool::vendor
                    )
                )
            }
        )
    }
}

@pbandk.Export
@pbandk.JsName("orDefaultForDocument")
public fun Document?.orDefault(): protobom.protobom.Document = this ?: Document.defaultInstance

private fun Document.protoMergeImpl(plus: pbandk.Message?): Document = (plus as? Document)?.let {
    it.copy(
        metadata = metadata?.plus(plus.metadata) ?: plus.metadata,
        nodeList = nodeList?.plus(plus.nodeList) ?: plus.nodeList,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Document.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Document {
    var metadata: protobom.protobom.Metadata? = null
    var nodeList: protobom.protobom.NodeList? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> metadata = _fieldValue as protobom.protobom.Metadata
            2 -> nodeList = _fieldValue as protobom.protobom.NodeList
        }
    }

    return Document(metadata, nodeList, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForDocumentType")
public fun DocumentType?.orDefault(): protobom.protobom.DocumentType = this ?: DocumentType.defaultInstance

private fun DocumentType.protoMergeImpl(plus: pbandk.Message?): DocumentType = (plus as? DocumentType)?.let {
    it.copy(
        type = plus.type ?: type,
        name = plus.name ?: name,
        description = plus.description ?: description,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun DocumentType.Companion.decodeWithImpl(u: pbandk.MessageDecoder): DocumentType {
    var type: protobom.protobom.DocumentType.SBOMType? = null
    var name: String? = null
    var description: String? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> type = _fieldValue as protobom.protobom.DocumentType.SBOMType
            2 -> name = _fieldValue as String
            3 -> description = _fieldValue as String
        }
    }

    return DocumentType(type, name, description, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForEdge")
public fun Edge?.orDefault(): protobom.protobom.Edge = this ?: Edge.defaultInstance

private fun Edge.protoMergeImpl(plus: pbandk.Message?): Edge = (plus as? Edge)?.let {
    it.copy(
        to = to + plus.to,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Edge.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Edge {
    var type: protobom.protobom.Edge.Type = protobom.protobom.Edge.Type.fromValue(0)
    var from = ""
    var to: pbandk.ListWithSize.Builder<String>? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> type = _fieldValue as protobom.protobom.Edge.Type
            2 -> from = _fieldValue as String
            3 -> to = (to ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<String> }
        }
    }

    return Edge(type, from, pbandk.ListWithSize.Builder.fixed(to), unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForExternalReference")
public fun ExternalReference?.orDefault(): protobom.protobom.ExternalReference = this ?: ExternalReference.defaultInstance

private fun ExternalReference.protoMergeImpl(plus: pbandk.Message?): ExternalReference = (plus as? ExternalReference)?.let {
    it.copy(
        hashes = hashes + plus.hashes,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun ExternalReference.Companion.decodeWithImpl(u: pbandk.MessageDecoder): ExternalReference {
    var url = ""
    var comment = ""
    var authority = ""
    var hashes: pbandk.MessageMap.Builder<Int, String>? = null
    var type: protobom.protobom.ExternalReference.ExternalReferenceType = protobom.protobom.ExternalReference.ExternalReferenceType.fromValue(0)

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> url = _fieldValue as String
            3 -> comment = _fieldValue as String
            4 -> authority = _fieldValue as String
            6 -> hashes = (hashes ?: pbandk.MessageMap.Builder()).apply { this.entries += _fieldValue as kotlin.sequences.Sequence<pbandk.MessageMap.Entry<Int, String>> }
            7 -> type = _fieldValue as protobom.protobom.ExternalReference.ExternalReferenceType
        }
    }

    return ExternalReference(url, comment, authority, pbandk.MessageMap.Builder.fixed(hashes),
        type, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForExternalReferenceHashesEntry")
public fun ExternalReference.HashesEntry?.orDefault(): protobom.protobom.ExternalReference.HashesEntry = this ?: ExternalReference.HashesEntry.defaultInstance

private fun ExternalReference.HashesEntry.protoMergeImpl(plus: pbandk.Message?): ExternalReference.HashesEntry = (plus as? ExternalReference.HashesEntry)?.let {
    it.copy(
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun ExternalReference.HashesEntry.Companion.decodeWithImpl(u: pbandk.MessageDecoder): ExternalReference.HashesEntry {
    var key = 0
    var value = ""

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> key = _fieldValue as Int
            2 -> value = _fieldValue as String
        }
    }

    return ExternalReference.HashesEntry(key, value, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForMetadata")
public fun Metadata?.orDefault(): protobom.protobom.Metadata = this ?: Metadata.defaultInstance

private fun Metadata.protoMergeImpl(plus: pbandk.Message?): Metadata = (plus as? Metadata)?.let {
    it.copy(
        date = date?.plus(plus.date) ?: plus.date,
        tools = tools + plus.tools,
        authors = authors + plus.authors,
        documentTypes = documentTypes + plus.documentTypes,
        sourceData = sourceData?.plus(plus.sourceData) ?: plus.sourceData,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Metadata.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Metadata {
    var id = ""
    var version = ""
    var name = ""
    var date: com.google.protobuf.Timestamp? = null
    var tools: pbandk.ListWithSize.Builder<protobom.protobom.Tool>? = null
    var authors: pbandk.ListWithSize.Builder<protobom.protobom.Person>? = null
    var comment = ""
    var documentTypes: pbandk.ListWithSize.Builder<protobom.protobom.DocumentType>? = null
    var sourceData: protobom.protobom.SourceData? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> id = _fieldValue as String
            2 -> version = _fieldValue as String
            3 -> name = _fieldValue as String
            4 -> date = _fieldValue as com.google.protobuf.Timestamp
            5 -> tools = (tools ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Tool> }
            6 -> authors = (authors ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Person> }
            7 -> comment = _fieldValue as String
            8 -> documentTypes = (documentTypes ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.DocumentType> }
            9 -> sourceData = _fieldValue as protobom.protobom.SourceData
        }
    }

    return Metadata(id, version, name, date,
        pbandk.ListWithSize.Builder.fixed(tools), pbandk.ListWithSize.Builder.fixed(authors), comment, pbandk.ListWithSize.Builder.fixed(documentTypes),
        sourceData, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForNode")
public fun Node?.orDefault(): protobom.protobom.Node = this ?: Node.defaultInstance

private fun Node.protoMergeImpl(plus: pbandk.Message?): Node = (plus as? Node)?.let {
    it.copy(
        licenses = licenses + plus.licenses,
        attribution = attribution + plus.attribution,
        suppliers = suppliers + plus.suppliers,
        originators = originators + plus.originators,
        releaseDate = releaseDate?.plus(plus.releaseDate) ?: plus.releaseDate,
        buildDate = buildDate?.plus(plus.buildDate) ?: plus.buildDate,
        validUntilDate = validUntilDate?.plus(plus.validUntilDate) ?: plus.validUntilDate,
        externalReferences = externalReferences + plus.externalReferences,
        fileTypes = fileTypes + plus.fileTypes,
        identifiers = identifiers + plus.identifiers,
        hashes = hashes + plus.hashes,
        primaryPurpose = primaryPurpose + plus.primaryPurpose,
        properties = properties + plus.properties,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Node.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Node {
    var id = ""
    var type: protobom.protobom.Node.NodeType = protobom.protobom.Node.NodeType.fromValue(0)
    var name = ""
    var version = ""
    var fileName = ""
    var urlHome = ""
    var urlDownload = ""
    var licenses: pbandk.ListWithSize.Builder<String>? = null
    var licenseConcluded = ""
    var licenseComments = ""
    var copyright = ""
    var sourceInfo = ""
    var comment = ""
    var summary = ""
    var description = ""
    var attribution: pbandk.ListWithSize.Builder<String>? = null
    var suppliers: pbandk.ListWithSize.Builder<protobom.protobom.Person>? = null
    var originators: pbandk.ListWithSize.Builder<protobom.protobom.Person>? = null
    var releaseDate: com.google.protobuf.Timestamp? = null
    var buildDate: com.google.protobuf.Timestamp? = null
    var validUntilDate: com.google.protobuf.Timestamp? = null
    var externalReferences: pbandk.ListWithSize.Builder<protobom.protobom.ExternalReference>? = null
    var fileTypes: pbandk.ListWithSize.Builder<String>? = null
    var identifiers: pbandk.MessageMap.Builder<Int, String>? = null
    var hashes: pbandk.MessageMap.Builder<Int, String>? = null
    var primaryPurpose: pbandk.ListWithSize.Builder<protobom.protobom.Purpose>? = null
    var properties: pbandk.ListWithSize.Builder<protobom.protobom.Property>? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> id = _fieldValue as String
            2 -> type = _fieldValue as protobom.protobom.Node.NodeType
            3 -> name = _fieldValue as String
            4 -> version = _fieldValue as String
            5 -> fileName = _fieldValue as String
            6 -> urlHome = _fieldValue as String
            7 -> urlDownload = _fieldValue as String
            8 -> licenses = (licenses ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<String> }
            9 -> licenseConcluded = _fieldValue as String
            10 -> licenseComments = _fieldValue as String
            11 -> copyright = _fieldValue as String
            13 -> sourceInfo = _fieldValue as String
            15 -> comment = _fieldValue as String
            16 -> summary = _fieldValue as String
            17 -> description = _fieldValue as String
            18 -> attribution = (attribution ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<String> }
            19 -> suppliers = (suppliers ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Person> }
            20 -> originators = (originators ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Person> }
            21 -> releaseDate = _fieldValue as com.google.protobuf.Timestamp
            22 -> buildDate = _fieldValue as com.google.protobuf.Timestamp
            23 -> validUntilDate = _fieldValue as com.google.protobuf.Timestamp
            24 -> externalReferences = (externalReferences ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.ExternalReference> }
            27 -> fileTypes = (fileTypes ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<String> }
            28 -> identifiers = (identifiers ?: pbandk.MessageMap.Builder()).apply { this.entries += _fieldValue as kotlin.sequences.Sequence<pbandk.MessageMap.Entry<Int, String>> }
            29 -> hashes = (hashes ?: pbandk.MessageMap.Builder()).apply { this.entries += _fieldValue as kotlin.sequences.Sequence<pbandk.MessageMap.Entry<Int, String>> }
            30 -> primaryPurpose = (primaryPurpose ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Purpose> }
            31 -> properties = (properties ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Property> }
        }
    }

    return Node(id, type, name, version,
        fileName, urlHome, urlDownload, pbandk.ListWithSize.Builder.fixed(licenses),
        licenseConcluded, licenseComments, copyright, sourceInfo,
        comment, summary, description, pbandk.ListWithSize.Builder.fixed(attribution),
        pbandk.ListWithSize.Builder.fixed(suppliers), pbandk.ListWithSize.Builder.fixed(originators), releaseDate, buildDate,
        validUntilDate, pbandk.ListWithSize.Builder.fixed(externalReferences), pbandk.ListWithSize.Builder.fixed(fileTypes), pbandk.MessageMap.Builder.fixed(identifiers),
        pbandk.MessageMap.Builder.fixed(hashes), pbandk.ListWithSize.Builder.fixed(primaryPurpose), pbandk.ListWithSize.Builder.fixed(properties), unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForNodeIdentifiersEntry")
public fun Node.IdentifiersEntry?.orDefault(): protobom.protobom.Node.IdentifiersEntry = this ?: Node.IdentifiersEntry.defaultInstance

private fun Node.IdentifiersEntry.protoMergeImpl(plus: pbandk.Message?): Node.IdentifiersEntry = (plus as? Node.IdentifiersEntry)?.let {
    it.copy(
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Node.IdentifiersEntry.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Node.IdentifiersEntry {
    var key = 0
    var value = ""

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> key = _fieldValue as Int
            2 -> value = _fieldValue as String
        }
    }

    return Node.IdentifiersEntry(key, value, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForNodeHashesEntry")
public fun Node.HashesEntry?.orDefault(): protobom.protobom.Node.HashesEntry = this ?: Node.HashesEntry.defaultInstance

private fun Node.HashesEntry.protoMergeImpl(plus: pbandk.Message?): Node.HashesEntry = (plus as? Node.HashesEntry)?.let {
    it.copy(
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Node.HashesEntry.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Node.HashesEntry {
    var key = 0
    var value = ""

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> key = _fieldValue as Int
            2 -> value = _fieldValue as String
        }
    }

    return Node.HashesEntry(key, value, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForNodeList")
public fun NodeList?.orDefault(): protobom.protobom.NodeList = this ?: NodeList.defaultInstance

private fun NodeList.protoMergeImpl(plus: pbandk.Message?): NodeList = (plus as? NodeList)?.let {
    it.copy(
        nodes = nodes + plus.nodes,
        edges = edges + plus.edges,
        rootElements = rootElements + plus.rootElements,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun NodeList.Companion.decodeWithImpl(u: pbandk.MessageDecoder): NodeList {
    var nodes: pbandk.ListWithSize.Builder<protobom.protobom.Node>? = null
    var edges: pbandk.ListWithSize.Builder<protobom.protobom.Edge>? = null
    var rootElements: pbandk.ListWithSize.Builder<String>? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> nodes = (nodes ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Node> }
            2 -> edges = (edges ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Edge> }
            3 -> rootElements = (rootElements ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<String> }
        }
    }

    return NodeList(pbandk.ListWithSize.Builder.fixed(nodes), pbandk.ListWithSize.Builder.fixed(edges), pbandk.ListWithSize.Builder.fixed(rootElements), unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForPerson")
public fun Person?.orDefault(): protobom.protobom.Person = this ?: Person.defaultInstance

private fun Person.protoMergeImpl(plus: pbandk.Message?): Person = (plus as? Person)?.let {
    it.copy(
        contacts = contacts + plus.contacts,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Person.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Person {
    var name = ""
    var isOrg = false
    var email = ""
    var url = ""
    var phone = ""
    var contacts: pbandk.ListWithSize.Builder<protobom.protobom.Person>? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> name = _fieldValue as String
            2 -> isOrg = _fieldValue as Boolean
            3 -> email = _fieldValue as String
            4 -> url = _fieldValue as String
            5 -> phone = _fieldValue as String
            6 -> contacts = (contacts ?: pbandk.ListWithSize.Builder()).apply { this += _fieldValue as kotlin.sequences.Sequence<protobom.protobom.Person> }
        }
    }

    return Person(name, isOrg, email, url,
        phone, pbandk.ListWithSize.Builder.fixed(contacts), unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForProperty")
public fun Property?.orDefault(): protobom.protobom.Property = this ?: Property.defaultInstance

private fun Property.protoMergeImpl(plus: pbandk.Message?): Property = (plus as? Property)?.let {
    it.copy(
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Property.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Property {
    var name = ""
    var data = ""

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> name = _fieldValue as String
            2 -> data = _fieldValue as String
        }
    }

    return Property(name, data, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForSourceData")
public fun SourceData?.orDefault(): protobom.protobom.SourceData = this ?: SourceData.defaultInstance

private fun SourceData.protoMergeImpl(plus: pbandk.Message?): SourceData = (plus as? SourceData)?.let {
    it.copy(
        hashes = hashes + plus.hashes,
        uri = plus.uri ?: uri,
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun SourceData.Companion.decodeWithImpl(u: pbandk.MessageDecoder): SourceData {
    var format = ""
    var hashes: pbandk.MessageMap.Builder<Int, String>? = null
    var size = 0L
    var uri: String? = null

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> format = _fieldValue as String
            2 -> hashes = (hashes ?: pbandk.MessageMap.Builder()).apply { this.entries += _fieldValue as kotlin.sequences.Sequence<pbandk.MessageMap.Entry<Int, String>> }
            3 -> size = _fieldValue as Long
            4 -> uri = _fieldValue as String
        }
    }

    return SourceData(format, pbandk.MessageMap.Builder.fixed(hashes), size, uri, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForSourceDataHashesEntry")
public fun SourceData.HashesEntry?.orDefault(): protobom.protobom.SourceData.HashesEntry = this ?: SourceData.HashesEntry.defaultInstance

private fun SourceData.HashesEntry.protoMergeImpl(plus: pbandk.Message?): SourceData.HashesEntry = (plus as? SourceData.HashesEntry)?.let {
    it.copy(
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun SourceData.HashesEntry.Companion.decodeWithImpl(u: pbandk.MessageDecoder): SourceData.HashesEntry {
    var key = 0
    var value = ""

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> key = _fieldValue as Int
            2 -> value = _fieldValue as String
        }
    }

    return SourceData.HashesEntry(key, value, unknownFields)
}

@pbandk.Export
@pbandk.JsName("orDefaultForTool")
public fun Tool?.orDefault(): protobom.protobom.Tool = this ?: Tool.defaultInstance

private fun Tool.protoMergeImpl(plus: pbandk.Message?): Tool = (plus as? Tool)?.let {
    it.copy(
        unknownFields = unknownFields + plus.unknownFields
    )
} ?: this

@Suppress("UNCHECKED_CAST")
private fun Tool.Companion.decodeWithImpl(u: pbandk.MessageDecoder): Tool {
    var name = ""
    var version = ""
    var vendor = ""

    val unknownFields = u.readMessage(this) { _fieldNumber, _fieldValue ->
        when (_fieldNumber) {
            1 -> name = _fieldValue as String
            2 -> version = _fieldValue as String
            3 -> vendor = _fieldValue as String
        }
    }

    return Tool(name, version, vendor, unknownFields)
}
