/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.sldg.SldgConstants;
import io.crums.sldg.SourceLedger;
import io.crums.sldg.sql.SqlLedgerException;
import io.crums.sldg.src.BytesValue;
import io.crums.sldg.src.ColumnValue;
import io.crums.sldg.src.DateValue;
import io.crums.sldg.src.DoubleValue;
import io.crums.sldg.src.HashValue;
import io.crums.sldg.src.LongValue;
import io.crums.sldg.src.NullValue;
import io.crums.sldg.src.SourceRow;
import io.crums.sldg.src.StringValue;
import io.crums.sldg.src.TableSalt;
import io.crums.util.Lists;
import io.crums.util.Strings;
import io.crums.util.TaskStack;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class SqlSourceQuery
implements SourceLedger {
    public static final int DEFAULT_MAX_COL_MEM_SIZE = 4096;
    private final PreparedStatement sizeQuery;
    private final PreparedStatement rowByNumberQuery;
    private final TableSalt shaker;
    private int maxColumnBytes;

    public SqlSourceQuery(PreparedStatement sizeQuery, PreparedStatement rowByNumberQuery, TableSalt shaker) throws SqlLedgerException {
        this(sizeQuery, rowByNumberQuery, shaker, 4096);
    }

    public SqlSourceQuery(PreparedStatement sizeQuery, PreparedStatement rowByNumberQuery, TableSalt shaker, int maxColumnBytes) throws SqlLedgerException {
        try {
            this.sizeQuery = Objects.requireNonNull(sizeQuery, "null sizeQuery");
            this.rowByNumberQuery = Objects.requireNonNull(rowByNumberQuery, "null rowByNumberQuery");
            this.shaker = Objects.requireNonNull(shaker, "null shaker");
            this.setMaxColumnBytes(maxColumnBytes);
            if (sizeQuery.isClosed() || rowByNumberQuery.isClosed()) {
                throw new IllegalArgumentException("prepared statement[s] is closed");
            }
        }
        catch (SQLException sqx) {
            throw new SqlLedgerException(sqx);
        }
    }

    public synchronized void setMaxColumnBytes(int maxColumnBytes) {
        if (maxColumnBytes < 0) {
            throw new IllegalArgumentException("negative maxColumnBytes: " + maxColumnBytes);
        }
        this.maxColumnBytes = maxColumnBytes;
    }

    public int getMaxColumnBytes() {
        return this.maxColumnBytes;
    }

    public synchronized void close() {
        try (TaskStack closer = new TaskStack();){
            closer.pushClose((AutoCloseable)this.sizeQuery);
            closer.pushClose((AutoCloseable)this.rowByNumberQuery);
            closer.pushClose((AutoCloseable)this.shaker);
        }
    }

    public synchronized long size() {
        try {
            ResultSet rs = this.sizeQuery.executeQuery();
            if (!rs.next()) {
                throw new SqlLedgerException("no result-set from query " + this.sizeQuery);
            }
            return rs.getLong(1);
        }
        catch (SQLException sqx) {
            throw new SqlLedgerException("on size(): " + sqx, sqx);
        }
    }

    public synchronized SourceRow getSourceRow(long rn) {
        try {
            this.rowByNumberQuery.setLong(1, rn);
            ResultSet rs = this.rowByNumberQuery.executeQuery();
            ResultSetMetaData meta = rs.getMetaData();
            if (!rs.next()) {
                throw new SqlLedgerException("no result-set from query " + this.rowByNumberQuery);
            }
            int columnCount = meta.getColumnCount();
            if (columnCount < 2) {
                throw new SqlLedgerException("no columns in result-set (!)");
            }
            ColumnValue[] columns = new ColumnValue[columnCount - 1];
            for (int col = 2; col <= columnCount; ++col) {
                columns[col - 2] = this.getColumnValue(rs, meta, rn, col);
            }
            return new SourceRow(rn, columns);
        }
        catch (SQLException sqx) {
            throw new SqlLedgerException("on getSourceByRowNumber(" + rn + "): " + sqx, sqx);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ColumnValue getColumnValue(ResultSet rs, ResultSetMetaData meta, long rn, int col) throws SQLException {
        int sqlType = meta.getColumnType(col);
        ByteBuffer salt = this.shaker.salt(rn, (long)col);
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                long longVal = rs.getLong(col);
                return rs.wasNull() ? new NullValue(salt) : new LongValue(longVal, salt);
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                Date date = rs.getDate(col);
                return date == null ? new NullValue(salt) : new DateValue(date.getTime(), salt);
            }
            case 0: {
                return new NullValue(salt);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                double value = rs.getDouble(col);
                return rs.wasNull() ? new NullValue(salt) : new DoubleValue(value, salt);
            }
            case 2004: {
                Blob blob = rs.getBlob(col);
                if (blob == null) {
                    return new NullValue(salt);
                }
                long len = blob.length();
                try (InputStream stream = blob.getBinaryStream();){
                    int bytesRead;
                    if (len > (long)this.maxColumnBytes) {
                        int amtRead;
                        MessageDigest digest = SldgConstants.DIGEST.newDigest();
                        byte[] in = new byte[4096];
                        while ((amtRead = stream.read(in)) != -1) {
                            digest.update(in, 0, amtRead);
                        }
                        byte[] unsaltedHash = digest.digest();
                        byte[] hash = ColumnValue.saltHash((ByteBuffer)salt, (byte[])unsaltedHash, (MessageDigest)digest);
                        HashValue hashValue = new HashValue(ByteBuffer.wrap(hash));
                        return hashValue;
                    }
                    byte[] bytes = new byte[(int)len];
                    for (int off = 0; off < bytes.length; off += bytesRead) {
                        bytesRead = stream.read(bytes, off, bytes.length - off);
                        assert (bytesRead > 0);
                    }
                    BytesValue bytesValue = new BytesValue(ByteBuffer.wrap(bytes), salt);
                    return bytesValue;
                }
                catch (IOException iox) {
                    throw new SqlLedgerException("on retrieving blob @ [" + rn + ", " + col + "]:" + iox, iox);
                }
            }
        }
        String stringVal = rs.getString(col);
        if (stringVal == null) {
            return new NullValue(salt);
        }
        StringValue out = new StringValue(stringVal, salt);
        return out.serialSize() > this.maxColumnBytes + 3 + 1 ? new HashValue(out.getHash()) : out;
    }

    public static class DefaultBuilder
    extends Builder {
        protected final String table;
        protected final String primaryKeyColumn;
        protected final List<String> columnNames;

        public DefaultBuilder(String table, List<String> columnNames) {
            this.table = Objects.requireNonNull(table, "null table name").trim();
            int count = columnNames.size();
            if (count < 2) {
                throw new IllegalArgumentException("too few column names: " + columnNames);
            }
            this.primaryKeyColumn = columnNames.get(0);
            this.columnNames = Lists.readOnlyCopy(columnNames.subList(1, count), (boolean)true);
            this.checkArgs();
        }

        public DefaultBuilder(String table, String primaryKeyColumn, String ... columnNames) {
            this.table = Objects.requireNonNull(table, "null table name").trim();
            this.primaryKeyColumn = Objects.requireNonNull(primaryKeyColumn, "null primary key column name").trim();
            this.columnNames = Lists.readOnlyCopy(Arrays.asList(columnNames), (boolean)true);
            this.checkArgs();
        }

        private void checkArgs() {
            if (this.table.length() < 2) {
                throw new IllegalArgumentException("table name too short: '" + this.table + "'");
            }
            if (this.primaryKeyColumn.length() < 2) {
                throw new IllegalArgumentException("primary key column name too short: '" + this.primaryKeyColumn + "'");
            }
            if (this.columnNames.isEmpty()) {
                throw new IllegalArgumentException("empty column names");
            }
            for (String col : this.columnNames) {
                if (!this.malformedColumnName(col)) continue;
                throw new IllegalArgumentException("column name '" + col + "'");
            }
            if (this.columnNames.contains(this.primaryKeyColumn)) {
                throw new IllegalArgumentException("primary key column name '" + this.primaryKeyColumn + "' duplicated (occurs) in columnNames: " + this.columnNames);
            }
        }

        private boolean malformedColumnName(String colName) {
            if (colName == null || colName.isEmpty()) {
                return true;
            }
            int index = colName.length();
            while (index-- > 1) {
                char c = colName.charAt(index);
                boolean ok = Strings.isAlphabet((char)c) || Strings.isDigit((char)c) || c == '_';
                if (ok) continue;
                return true;
            }
            return !Strings.isAlphabet((char)colName.charAt(0));
        }

        @Override
        public String getPreparedSizeQuery() {
            return "SELECT count(*) FROM " + this.table + " AS rcount";
        }

        @Override
        public String getPreparedRowByNumberQuery() {
            StringBuilder sql = new StringBuilder("SELECT * FROM (  SELECT ROW_NUMBER() OVER (ORDER BY ");
            sql.append(this.primaryKeyColumn).append(" ASC) AS row_index, ").append(this.primaryKeyColumn);
            for (String cName : this.columnNames) {
                sql.append(", ").append(cName);
            }
            sql.append(" FROM ").append(this.table).append(") AS snap WHERE row_index = ?");
            return sql.toString();
        }
    }

    public static class DirectBuilder
    extends Builder {
        protected final String sizeQuery;
        protected final String rowQuery;

        public DirectBuilder(String sizeQuery, String rowQuery) {
            this.sizeQuery = Objects.requireNonNull(sizeQuery, "null sizeQuery");
            this.rowQuery = Objects.requireNonNull(rowQuery, "null rowQuery");
            int q = rowQuery.indexOf(63);
            if (q == -1) {
                throw new IllegalArgumentException("missing '?' in rowQuery: " + rowQuery);
            }
            if (rowQuery.lastIndexOf(63) != q) {
                throw new IllegalArgumentException("multiple '?'s in rowQuery: " + rowQuery);
            }
            if (sizeQuery.indexOf(63) != -1) {
                throw new IllegalArgumentException("sizeQuery should not be parameterized with '?': " + sizeQuery);
            }
        }

        @Override
        public String getPreparedSizeQuery() {
            return this.sizeQuery;
        }

        @Override
        public String getPreparedRowByNumberQuery() {
            return this.rowQuery;
        }
    }

    public static abstract class Builder {
        public abstract String getPreparedSizeQuery();

        public abstract String getPreparedRowByNumberQuery();

        public SqlSourceQuery build(Connection con, TableSalt shaker) throws SqlLedgerException {
            Objects.requireNonNull(con, "null connection");
            Objects.requireNonNull(shaker, "null table salt");
            try {
                PreparedStatement szQuery = con.prepareStatement(this.getPreparedSizeQuery());
                PreparedStatement rowByNumQuery = con.prepareStatement(this.getPreparedRowByNumberQuery());
                return new SqlSourceQuery(szQuery, rowByNumQuery, shaker);
            }
            catch (SQLException sqx) {
                throw new SqlLedgerException("on build(" + con + "): " + sqx, sqx);
            }
        }
    }
}

