/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.sldg.SkipTable;
import io.crums.sldg.sql.HashLedgerSchema;
import io.crums.sldg.sql.SqlLedgerException;
import io.crums.util.Base64_32;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;

public class SqlSkipTable
implements SkipTable {
    private final Connection con;
    private final String tableName;
    private final PreparedStatement szStmt;
    private final PreparedStatement selectRow;

    public static SqlSkipTable declareNewTable(Connection con, String tableName) throws SQLException {
        String sql = HashLedgerSchema.defaultSkipTableSchema(tableName);
        Statement stmt = Objects.requireNonNull(con, "null con").createStatement();
        stmt.execute(sql);
        con.commit();
        return new SqlSkipTable(con, tableName);
    }

    public SqlSkipTable(Connection con, String tableName) throws SQLException {
        this.con = Objects.requireNonNull(con, "null connection");
        if (!con.isReadOnly()) {
            con.setAutoCommit(false);
        }
        this.tableName = Objects.requireNonNull(tableName, "null table name").trim();
        this.szStmt = con.prepareStatement("SELECT COUNT(row_num) FROM " + tableName + " AS count");
        this.selectRow = con.prepareStatement("SELECT src_hash, row_hash FROM " + tableName + " WHERE row_num = ?");
    }

    public synchronized long addRows(ByteBuffer rows, long index) {
        int count = rows.remaining() / ROW_WIDTH;
        if (count == 0 || count * ROW_WIDTH != rows.remaining()) {
            throw new IllegalArgumentException("remaining bytes not a positive multiple of " + ROW_WIDTH + ": " + rows);
        }
        long size = this.size();
        if (index != size) {
            throw new IllegalArgumentException("on addRows(), index=" + index + ", size=" + size);
        }
        long base = size + 1L;
        StringBuilder sql = new StringBuilder().append("INSERT INTO ").append(this.tableName).append('(').append("row_num").append(", ").append("src_hash").append(", ").append("row_hash").append(") VALUES");
        String[] encoded = new String[count * 2];
        for (int i = 0; i < encoded.length; ++i) {
            encoded[i] = Base64_32.encodeNext32((ByteBuffer)rows);
        }
        for (int r = 0; r < count; ++r) {
            long rowNum = base + (long)r;
            int ei = r * 2;
            sql.append("\n( ").append(rowNum).append(", '").append(encoded[ei]).append("', '").append(encoded[ei + 1]).append("'),");
        }
        sql.setLength(sql.length() - 1);
        try {
            Statement stmt = this.con.createStatement();
            stmt.execute(sql.toString());
            int updateCount = stmt.getUpdateCount();
            if (updateCount != count) {
                this.con.rollback();
                throw new SqlLedgerException("on addRow(): updateCount=" + updateCount + ", count=" + count + ", index=" + index + ", encodedRows=" + Arrays.asList(encoded));
            }
            this.con.commit();
        }
        catch (SQLException sx) {
            throw new SqlLedgerException("on addRow(): index=" + index + ", encoded inputs/row-hashes: " + Arrays.asList(encoded), sx);
        }
        return size + (long)count;
    }

    public synchronized ByteBuffer readRow(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("index " + index);
        }
        try {
            this.selectRow.setLong(1, index + 1L);
            ResultSet result = this.selectRow.executeQuery();
            if (!result.next()) {
                throw new IllegalArgumentException("index out-of-bounds: " + index);
            }
            byte[] row = new byte[ROW_WIDTH];
            Base64_32.decode((CharSequence)result.getString(1), (byte[])row, (int)0);
            Base64_32.decode((CharSequence)result.getString(2), (byte[])row, (int)(ROW_WIDTH / 2));
            return ByteBuffer.wrap(row);
        }
        catch (SQLException sx) {
            throw new SqlLedgerException("on readRow(): index=" + index, sx);
        }
    }

    public synchronized long size() {
        try {
            ResultSet result = this.szStmt.executeQuery();
            if (result.next()) {
                return result.getLong(1);
            }
            throw new SqlLedgerException("onSize(): result=" + result);
        }
        catch (SQLException sx) {
            throw new SqlLedgerException("on size()", sx);
        }
    }

    public synchronized void close() {
        try {
            this.con.close();
        }
        catch (SQLException sx) {
            Logger.getLogger("sldg").warning("ignoring con.close() complaint: " + sx);
        }
    }

    public synchronized void trimSize(long newSize) {
        if (newSize < 0L) {
            throw new IllegalArgumentException("newSize: " + newSize);
        }
        long size = this.size();
        if (newSize > size) {
            throw new IllegalArgumentException("newSize " + newSize + " > size " + size);
        }
        String deleteSql = "DELETE FROM " + this.tableName + " WHERE row_num > " + newSize;
        try (Statement stmt = this.con.createStatement();){
            stmt.execute(deleteSql);
            this.con.commit();
        }
        catch (SQLException sx) {
            throw new SqlLedgerException("on trimSize(" + newSize + ")", sx);
        }
    }
}

