/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.sldg.HashLedger;
import io.crums.sldg.Ledger;
import io.crums.sldg.SourceLedger;
import io.crums.sldg.sql.Config;
import io.crums.sldg.sql.SqlHashLedger;
import io.crums.sldg.sql.SqlSourceQuery;
import io.crums.sldg.src.TableSalt;
import io.crums.util.TaskStack;
import io.crums.util.ticker.Ticker;
import java.sql.Connection;

public class SqlLedger
extends Ledger {
    public static SqlLedger declareNewInstance(Config config) {
        try (TaskStack closeOnFail = new TaskStack();){
            Connection con = config.getSourceConnection();
            closeOnFail.pushClose((AutoCloseable)con);
            TableSalt shaker = config.getSourceSalt();
            SqlSourceQuery srcLedger = config.getSourceBuilder().build(con, shaker);
            if (config.dedicatedSourceCon()) {
                con = config.getHashConnection();
                closeOnFail.pushClose((AutoCloseable)con);
            }
            SqlHashLedger hashLedger = SqlHashLedger.declareNewInstance(con, config.getHashLedgerSchema());
            SqlLedger ledger = new SqlLedger(srcLedger, hashLedger, null, true);
            closeOnFail.clear();
            SqlLedger sqlLedger = ledger;
            return sqlLedger;
        }
    }

    public static SqlLedger loadInstance(Config config) {
        return SqlLedger.loadInstance(config, null, true);
    }

    public static SqlLedger loadInstance(Config config, Ticker progress, boolean trustHashLedger) {
        SqlLedger ledger;
        try (TaskStack closeOnFail = new TaskStack();){
            Connection con = config.getSourceConnection();
            closeOnFail.pushClose((AutoCloseable)con);
            SqlSourceQuery.Builder builder = config.getSourceBuilder();
            TableSalt shaker = config.getSourceSalt();
            SqlSourceQuery srcLedger = builder.build(con, shaker);
            if (config.dedicatedSourceCon()) {
                con = config.getHashConnection();
                closeOnFail.pushClose((AutoCloseable)con);
            }
            String prefix = config.getHashTablePrefix();
            SqlHashLedger hashLedger = new SqlHashLedger(prefix, con);
            ledger = new SqlLedger(srcLedger, hashLedger, progress, trustHashLedger);
            closeOnFail.clear();
        }
        return ledger;
    }

    private SqlLedger(SourceLedger srcLedger, HashLedger hashLedger, Ticker progress, boolean trustHashLedger) {
        super(srcLedger, hashLedger, progress, trustHashLedger);
    }
}

