/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.model.Crum;
import io.crums.model.CrumTrail;
import io.crums.sldg.HashLedger;
import io.crums.sldg.SkipLedger;
import io.crums.sldg.sql.HashLedgerSchema;
import io.crums.sldg.sql.SqlLedgerException;
import io.crums.sldg.sql.SqlSkipLedger;
import io.crums.sldg.time.TrailedRow;
import io.crums.sldg.time.WitnessRecord;
import io.crums.util.Base64_32;
import io.crums.util.TaskStack;
import io.crums.util.mrkl.Proof;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class SqlHashLedger
implements HashLedger {
    private final Object lock = new Object();
    private final HashLedgerSchema schema;
    private final Connection con;
    private final SqlSkipLedger skipLedger;
    private final PreparedStatement trailCountStmt;
    private final PreparedStatement selectTrailByIndexStmt;
    private final PreparedStatement selectChainByChainId;
    private final PreparedStatement selectNearestTrailStmt;
    private final PreparedStatement selectLastTrailedRnStmt;
    private final PreparedStatement chainTableCountStmt;
    private PreparedStatement insertTrailStmt;

    public static SqlHashLedger declareNewInstance(Connection con, String protoName) {
        return SqlHashLedger.declareNewInstance(con, new HashLedgerSchema(protoName));
    }

    public static SqlHashLedger declareNewInstance(Connection con, HashLedgerSchema schema) {
        Objects.requireNonNull(schema, "null schema");
        try {
            if (con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            Statement stmt = con.createStatement();
            stmt.execute(schema.getSkipTableSchema());
            stmt.execute(schema.getChainTableSchema());
            stmt.execute(schema.getTrailTableSchema());
            con.commit();
            return new SqlHashLedger(schema, con);
        }
        catch (SQLException sqx) {
            throw new SqlLedgerException("on declareNewInstance(" + schema + "): " + sqx, sqx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getInsertTrailStmt() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.insertTrailStmt == null) {
                String sql = "INSERT INTO " + this.schema.getTrailTable() + " (trl_id, row_num, utc, mrkl_idx, mrkl_cnt, chain_len, chn_id) VALUES ( ?, ?, ?, ?, ?, ?, ?)";
                this.insertTrailStmt = this.con.prepareStatement(sql);
            }
            return this.insertTrailStmt;
        }
    }

    public SqlHashLedger(String protoName, Connection con) {
        this(new HashLedgerSchema(protoName), con);
    }

    public SqlHashLedger(HashLedgerSchema schema, Connection con) {
        this.schema = Objects.requireNonNull(schema, "null schema");
        this.con = Objects.requireNonNull(con, "null con");
        try {
            if (!con.isValid(5)) {
                throw new IllegalArgumentException("connection not valid: " + con);
            }
            if (!con.isReadOnly() && con.getAutoCommit()) {
                con.setAutoCommit(false);
            }
            this.skipLedger = new SqlSkipLedger(con, schema.getSkipTable());
            this.trailCountStmt = con.prepareStatement("SELECT count(*) FROM " + schema.getTrailTable() + " AS rcount");
            this.selectTrailByIndexStmt = con.prepareStatement("SELECT trl_id, row_num, utc, mrkl_idx, mrkl_cnt, chain_len, chn_id FROM " + schema.getTrailTable() + " WHERE trl_id = ?");
            this.selectChainByChainId = con.prepareStatement("SELECT chn_id, n_hash FROM " + schema.getChainTable() + " WHERE chn_id >= ? ORDER BY chn_id LIMIT ?");
            this.selectNearestTrailStmt = con.prepareStatement("SELECT trl_id, row_num, utc, mrkl_idx, mrkl_cnt, chain_len, chn_id FROM " + schema.getTrailTable() + " WHERE row_num >= ? ORDER BY row_num LIMIT 1");
            this.selectLastTrailedRnStmt = con.prepareStatement("SELECT trl_id, row_num FROM " + schema.getTrailTable() + " ORDER BY trl_id DESC LIMIT 1");
            this.chainTableCountStmt = con.prepareStatement("SELECT count(*) FROM " + schema.getChainTable() + " AS rcount");
        }
        catch (SQLException sqx) {
            throw new SqlLedgerException("on <init>: " + sqx, sqx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.con.close();
            }
            catch (SQLException x) {
                throw new SqlLedgerException("on close(): " + x, x);
            }
        }
    }

    public SkipLedger getSkipLedger() {
        return this.skipLedger;
    }

    public boolean addTrail(WitnessRecord trailedRecord) {
        if (!Objects.requireNonNull(trailedRecord, "null trailedRecord").isTrailed()) {
            throw new IllegalArgumentException("not trailed: " + trailedRecord);
        }
        long rowNum = trailedRecord.rowNum();
        CrumTrail trail = trailedRecord.record().trail();
        Object object = this.lock;
        synchronized (object) {
            int size = this.getTrailCount();
            if (size > 0) {
                TrailedRow lastTrailedRow = this.getTrailByIndex(size - 1);
                if (rowNum <= lastTrailedRow.rowNumber()) {
                    return false;
                }
                if (trail.crum().utc() < lastTrailedRow.utc()) {
                    Logger logger = Logger.getLogger(SqlHashLedger.class.getSimpleName());
                    logger.warning("row [" + lastTrailedRow.rowNumber() + "] is already recorded as being witnessed after (!) row [" + rowNum + "]: " + new Date(lastTrailedRow.utc()) + " v. " + new Date(trail.crum().utc()) + ". Not adding crumtrail for row [" + rowNum + "] as this would violate model invariants.");
                    return false;
                }
            }
            try {
                ResultSet rs = this.chainTableCountStmt.executeQuery();
                if (!rs.next()) {
                    throw new SqlLedgerException("failed to execute COUNT query on chain table");
                }
                int nextChainId = rs.getInt(1) + 1;
                if (nextChainId < 1) {
                    throw new SqlLedgerException("nonsensical COUNT query on chain table " + (nextChainId - 1));
                }
                StringBuilder sql = new StringBuilder("INSERT INTO ").append(this.schema.getChainTable()).append(" (").append("chn_id").append(", ").append("n_hash").append(") VALUES");
                List hashChain = trail.hashChain();
                int chainId = nextChainId;
                for (byte[] cHash : hashChain) {
                    sql.append("\n(").append(chainId++).append(", '").append(Base64_32.encode((byte[])cHash)).append("'),");
                }
                sql.setLength(sql.length() - 1);
                Statement stmt = this.con.createStatement();
                stmt.execute(sql.toString());
                int updateCount = stmt.getUpdateCount();
                if (updateCount != hashChain.size()) {
                    this.con.rollback();
                    throw new SqlLedgerException("INSERT did not yield expected updateCount " + trail.hashChain().size() + "; actual was " + updateCount + "; SQL:\n" + sql);
                }
                int trailId = size + 1;
                PreparedStatement trailInsert = this.getInsertTrailStmt();
                trailInsert.setInt(1, trailId);
                trailInsert.setLong(2, rowNum);
                trailInsert.setLong(3, trailedRecord.utc());
                trailInsert.setInt(4, trail.leafIndex());
                trailInsert.setInt(5, trail.leafCount());
                trailInsert.setInt(6, hashChain.size());
                trailInsert.setInt(7, nextChainId);
                trailInsert.executeUpdate();
                this.con.commit();
                return true;
            }
            catch (SQLException sqx) {
                boolean rb;
                try {
                    this.con.rollback();
                    rb = true;
                }
                catch (SQLException sqx2) {
                    rb = false;
                }
                String msg = "on addTrail " + trailedRecord;
                if (!rb) {
                    msg = msg + " (rollback failed!)";
                }
                msg = msg + " -- " + sqx;
                throw new SqlLedgerException(msg, sqx);
            }
        }
    }

    public int getTrailCount() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ResultSet rs = this.trailCountStmt.executeQuery();
                if (rs.next()) {
                    return (int)rs.getLong(1);
                }
                throw new SqlLedgerException("empty result set on getTrailCount(): " + rs);
            }
            catch (SQLException sqx) {
                throw new SqlLedgerException("on getTrailCount(): " + sqx, sqx);
            }
        }
    }

    public TrailedRow getTrailByIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index " + index);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.selectTrailByIndexStmt.setInt(1, index + 1);
                ResultSet rs = this.selectTrailByIndexStmt.executeQuery();
                if (!rs.next()) {
                    if (index >= this.getTrailCount()) {
                        throw new IndexOutOfBoundsException(index);
                    }
                    throw new SqlLedgerException("empty result set on getTrailByIndex(" + index + "): " + rs);
                }
                return this.getTrailedRow(rs);
            }
            catch (SQLException sqx) {
                throw new SqlLedgerException("on getTrailByIndex(" + index + "): " + sqx, sqx);
            }
        }
    }

    private TrailedRow getTrailedRow(ResultSet rs) throws SQLException {
        int tid = rs.getInt(1);
        long rowNumber = rs.getLong(2);
        long utc = rs.getLong(3);
        int leafIndex = rs.getInt(4);
        int leafCount = rs.getInt(5);
        int chainLen = rs.getInt(6);
        int chainId = rs.getInt(7);
        if (chainLen != Proof.chainLength((int)leafCount, (int)leafIndex)) {
            throw new SqlLedgerException("chain-length assertion failed: chainLen=" + chainLen + ", leafCount=" + leafCount + ", leafIndex=" + leafIndex);
        }
        if (rs.next()) {
            throw new SqlLedgerException("multiple rows in result set: tid=" + tid + ", rowNumber=" + rowNumber);
        }
        this.selectChainByChainId.setInt(1, chainId);
        this.selectChainByChainId.setInt(2, chainLen);
        rs = this.selectChainByChainId.executeQuery();
        byte[][] chain = new byte[chainLen][];
        int lastLinkId = -1;
        for (int ci = 0; ci < chainLen; ++ci) {
            if (!rs.next()) {
                throw new SqlLedgerException("expected hash-chain of length " + chainLen + "; actual in db is " + ci);
            }
            int linkId = rs.getInt(1);
            if (linkId <= lastLinkId) {
                throw new SqlLedgerException("assertion failed: lastLinkId=" + lastLinkId + "; linkId=" + linkId + "; tid=" + tid);
            }
            lastLinkId = linkId;
            String encoded = rs.getString(2);
            chain[ci] = Base64_32.decode((CharSequence)encoded);
        }
        if (lastLinkId != chainId + chainLen - 1) {
            throw new SqlLedgerException("assertion failed: lastLinkId=" + lastLinkId + "; chain_id=" + chainId + "; chain_len=" + chainLen + "; tid=" + tid);
        }
        Crum crum = new Crum(this.skipLedger.rowHash(rowNumber), utc);
        CrumTrail trail = new CrumTrail(leafCount, leafIndex, (byte[][])chain, crum);
        return new TrailedRow(rowNumber, trail);
    }

    public TrailedRow nearestTrail(long rowNumber) {
        SkipLedger.checkRealRowNumber((long)rowNumber);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.selectNearestTrailStmt.setLong(1, rowNumber);
                ResultSet rs = this.selectNearestTrailStmt.executeQuery();
                return rs.next() ? this.getTrailedRow(rs) : null;
            }
            catch (SQLException sqx) {
                throw new SqlLedgerException("on nearestTrail(" + rowNumber + "): " + sqx, sqx);
            }
        }
    }

    public long lastWitnessedRowNumber() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ResultSet rs = this.selectLastTrailedRnStmt.executeQuery();
                if (!rs.next()) {
                    return 0L;
                }
                long witnessedRn = rs.getLong(2);
                if (witnessedRn < 1L) {
                    throw new SqlLedgerException("nonsense witnessed row number " + witnessedRn);
                }
                return witnessedRn;
            }
            catch (SQLException sqx) {
                throw new SqlLedgerException("on lastWitnessedRowNumber(): " + sqx, sqx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimSize(long newSize) {
        if (newSize < 0L) {
            throw new IllegalArgumentException("newSize: " + newSize);
        }
        Object object = this.lock;
        synchronized (object) {
            try (TaskStack closer = new TaskStack();){
                this.selectNearestTrailStmt.setLong(1, newSize);
                ResultSet rs = this.selectNearestTrailStmt.executeQuery();
                closer.pushClose((AutoCloseable)rs);
                if (rs.next()) {
                    int tid = rs.getInt(1);
                    long rowNumber = rs.getLong(2);
                    int chainLen = rs.getInt(6);
                    int chainId = rs.getInt(7);
                    assert (rowNumber >= newSize);
                    boolean include = rowNumber > newSize;
                    String trailDelSql = "DELETE FROM " + this.schema.getTrailTable() + " WHERE trl_id" + (include ? " >= " : " > ") + tid;
                    String chainDelSql = "DELETE FROM " + this.schema.getChainTable() + " WHERE chn_id >= " + (include ? chainId : chainId + chainLen);
                    Statement stmt = this.con.createStatement();
                    closer.pushClose((AutoCloseable)stmt);
                    stmt.executeUpdate(trailDelSql);
                    stmt.executeUpdate(chainDelSql);
                }
                this.con.commit();
                this.skipLedger.trimSize(newSize);
            }
            catch (SQLException sqx) {
                throw new SqlLedgerException("on lastWitnessedRowNumber(): " + sqx, sqx);
            }
        }
    }
}

