/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.sldg.sql.Config;
import java.util.Objects;

public class HashLedgerSchema {
    public static final String ROW_NUM = "row_num";
    public static final String SRC_HASH = "src_hash";
    public static final String ROW_HASH = "row_hash";
    public static final String CHN_ID = "chn_id";
    public static final String TRL_ID = "trl_id";
    public static final String N_HASH = "n_hash";
    public static final String MRKL_IDX = "mrkl_idx";
    public static final String MRKL_CNT = "mrkl_cnt";
    public static final String CHAIN_LEN = "chain_len";
    public static final String UTC = "utc";
    public static final String BIGINT_TYPE = "BIGINT";
    public static final String INT_TYPE = "INT";
    public static final String BASE64_TYPE = "CHAR(43)";
    public static final String PROTO_AUTOINCREMENT = "AUTO_INCREMENT";
    private static final String SOFT_TAB = "  ";
    public static final String SKIP_TBL_EXT = "_sldg";
    public static final String TRAIL_TBL_EXT = "_sldg_tr";
    public static final String CHAIN_TBL_EXT = "_sldg_ch";
    private final Config config;
    private final String tablePrefix;
    private final String skipTable;
    private final String chainTable;
    private final String trailTable;

    public static String defaultSkipTableSchema(String skipTable) {
        return "CREATE TABLE " + skipTable + " (   row_num BIGINT NOT NULL,  src_hash CHAR(43) NOT NULL,  row_hash CHAR(43) NOT NULL,  PRIMARY KEY (row_num) )";
    }

    public static String protoSkipTableSchema(String tablePrefix) {
        return HashLedgerSchema.defaultSkipTableSchema(HashLedgerSchema.getSkipTable(tablePrefix));
    }

    public static String protoTrailTableSchema(String tablePrefix) {
        String trailTable = HashLedgerSchema.getTrailTable(tablePrefix);
        String skipTable = HashLedgerSchema.getSkipTable(tablePrefix);
        String chainTable = HashLedgerSchema.getChainTable(tablePrefix);
        return "CREATE TABLE " + trailTable + " (  trl_id INT NOT NULL,  row_num BIGINT NOT NULL,  utc BIGINT NOT NULL,  mrkl_idx INT NOT NULL,  mrkl_cnt INT NOT NULL,  chain_len INT NOT NULL,  chn_id INT NOT NULL,  PRIMARY KEY (trl_id),  FOREIGN KEY (row_num) REFERENCES " + skipTable + "(row_num),  FOREIGN KEY (chn_id) REFERENCES " + chainTable + "(chn_id) )";
    }

    public static String protoChainTableSchema(String tablePrefix) {
        String chainTable = HashLedgerSchema.getChainTable(tablePrefix);
        return "CREATE TABLE " + chainTable + " (  chn_id INT NOT NULL,  n_hash CHAR(43) NOT NULL,  PRIMARY KEY (chn_id)  )";
    }

    public static String getSkipTable(String tablePrefix) {
        HashLedgerSchema.checkPrefix(tablePrefix);
        return tablePrefix + SKIP_TBL_EXT;
    }

    public static String getChainTable(String tablePrefix) {
        HashLedgerSchema.checkPrefix(tablePrefix);
        return tablePrefix + CHAIN_TBL_EXT;
    }

    public static String getTrailTable(String tablePrefix) {
        HashLedgerSchema.checkPrefix(tablePrefix);
        return tablePrefix + TRAIL_TBL_EXT;
    }

    private static void checkPrefix(String tablePrefix) {
        if (tablePrefix == null || tablePrefix.isBlank()) {
            throw new IllegalArgumentException("tablePrefix: " + tablePrefix);
        }
    }

    public HashLedgerSchema(String tablePrefix) {
        this.config = null;
        this.tablePrefix = tablePrefix;
        this.skipTable = HashLedgerSchema.getSkipTable(tablePrefix);
        this.chainTable = HashLedgerSchema.getChainTable(tablePrefix);
        this.trailTable = HashLedgerSchema.getTrailTable(tablePrefix);
    }

    public HashLedgerSchema(Config config) {
        this.config = Objects.requireNonNull(config, "null config");
        this.tablePrefix = config.getHashTablePrefix();
        this.skipTable = HashLedgerSchema.getSkipTable(this.tablePrefix);
        this.chainTable = HashLedgerSchema.getChainTable(this.tablePrefix);
        this.trailTable = HashLedgerSchema.getTrailTable(this.tablePrefix);
    }

    public final String getSkipTable() {
        return this.skipTable;
    }

    public final String getChainTable() {
        return this.chainTable;
    }

    public final String getTrailTable() {
        return this.trailTable;
    }

    public String getSkipTableSchema() {
        String sql;
        String string = sql = this.config == null ? null : this.config.getSkipTableSchema();
        if (sql == null) {
            sql = HashLedgerSchema.defaultSkipTableSchema(this.skipTable);
        }
        return sql;
    }

    public String getTrailTableSchema() {
        String sql;
        String string = sql = this.config == null ? null : this.config.getTrailTableSchema();
        if (sql == null) {
            sql = HashLedgerSchema.protoTrailTableSchema(this.tablePrefix);
        }
        return sql;
    }

    public String getChainTableSchema() {
        String sql;
        String string = sql = this.config == null ? null : this.config.getChainTableSchema();
        if (sql == null) {
            sql = HashLedgerSchema.protoChainTableSchema(this.tablePrefix);
        }
        return sql;
    }
}

