/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.io.FileUtils;
import io.crums.sldg.sql.SqlLedgerException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;

public class ConnectionInfo {
    private final String url;
    private final String driverClassname;
    private final String driverClasspath;
    private final ConnectionInfo parent;

    public ConnectionInfo(String url, String driverClassname, String driverClasspath) {
        this(url, driverClassname, driverClasspath, null);
    }

    public ConnectionInfo(String url, String driverClassname, String driverClasspath, ConnectionInfo parent) {
        this.url = Objects.requireNonNull(url, "null connection url");
        this.driverClassname = driverClassname;
        this.driverClasspath = driverClasspath;
        this.parent = parent;
        if (this.driverClasspath != null && this.driverClassname == null) {
            throw new IllegalArgumentException("driverClass is null while driverClasspath is not: " + driverClasspath);
        }
    }

    public Connection open(File baseDir, Properties info) throws SqlLedgerException {
        try {
            Driver driver;
            URL url;
            Class<?> clazz;
            String driverClassname = this.resolveDriverClassname();
            if (driverClassname == null) {
                return info == null ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, info);
            }
            String driverClasspath = this.resolveDriverClasspath();
            if (driverClasspath == null) {
                try {
                    clazz = Class.forName(driverClassname);
                }
                catch (ClassNotFoundException cnfx) {
                    throw new SqlLedgerException("failed to load driver class " + driverClassname, cnfx);
                }
            }
            File classpath = FileUtils.getRelativeUnlessAbsolute((String)driverClasspath, (File)baseDir);
            if (!classpath.isFile()) {
                throw new SqlLedgerException(driverClasspath + " resolved to " + classpath + " is not an existing jar file");
            }
            try {
                url = new URL("jar", "", classpath.toURI().toURL() + "!/");
            }
            catch (MalformedURLException mux) {
                throw new SqlLedgerException("on constructing jar URL for " + classpath, mux);
            }
            URLClassLoader classLoader = new URLClassLoader(new URL[]{url});
            try {
                clazz = Class.forName(driverClassname, true, classLoader);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException x) {
                throw new SqlLedgerException("on loading " + driverClassname + " from " + classpath, x);
            }
            try {
                driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException x) {
                throw new SqlLedgerException("on instantiating driver class " + clazz, x);
            }
            return driver.connect(this.url, info);
        }
        catch (SQLException sx) {
            throw new SqlLedgerException("on connecting with " + this.url);
        }
    }

    public String resolveDriverClassname() {
        return this.driverClassname == null && this.parent != null ? this.parent.driverClassname : this.driverClassname;
    }

    public String resolveDriverClasspath() {
        return this.driverClasspath == null && this.parent != null ? this.parent.driverClasspath : this.driverClasspath;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getDriverClassname() {
        return this.driverClassname;
    }

    public final String getDriverClasspath() {
        return this.driverClasspath;
    }

    public final ConnectionInfo getParent() {
        return this.parent;
    }
}

