/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.io.FileUtils;
import io.crums.sldg.SldgConstants;
import io.crums.sldg.sql.Config;
import io.crums.sldg.sql.HashLedgerSchema;
import io.crums.util.IntegralStrings;
import io.crums.util.TidyProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class ConfigFileBuilder {
    private static final String PREAMBLE = " Namespace Summary:\n =================\n\n sldg.source.jdbc.url:\n  Connection URL (jdbc:) to source table (required; read-only OK)\n\n sldg.source.info.xyz:\n  Connection property xyz is prefixed with sldg.source.info.\n\n sldg.source.jdbc.driver:\n  JDBC driver class name needed to load above jdbc URL (optional)\n\n sldg.source.jdbc.driver.classpath:\n  Path to .jar bundle containing the named driver class (optional)\n\n sldg.source.query.size:\n  \"SELECT COUNT(*)\" from source table query (required)\n\n sldg.source.query.row:\n  \"SELECT\" by row-number prepared-statement query (required)\n  Note however you design this, your row-nums must range [1, size] (no gaps)\n\n sldg.source.salt.seed:\n  Secret 64-char hex value seed for generating table-cell salts by row/col coordinates\n  Note this value should not be changed or lost. It protects individual table-cell\n  values from rainbow attacks (reverse-engineering a value from its hash).\n\n sldg.hash.jdbc.url:\n  Connection URL to DB the tracking hash-ledger lives in (optional)\n  If not set, then the hash-ledger lives in the same DB as the source-table\n\n sldg.hash.info.xyz:\n  Connection property xyz is prefixed with sldg.hash.info.\n\n sldg.hash.jdbc.driver:\n  JDBC driver class name needed to load above jdbc URL (optional)\n\n sldg.hash.jdbc.driver.classpath:\n  Path to .jar bundle containing the named driver class (optional)\n\n sldg.hash.table.prefix:\n  Hash-ledger tables (3) use this prefix in their table names. Usually set to\n  the source table's name.\n\n The following 3 specify the SQL schemas for the hash tables. They may be\n DB vendor specific.\n\n sldg.hash.schema.skip:\n  SQL schema (CREATE TABLE statement) for the skipledger table (defaulted)\n\n sldg.hash.schema.chain:\n  SQL schema (CREATE TABLE statement) for the chain table (defaulted)\n\n sldg.hash.schema.trail:\n  SQL schema (CREATE TABLE statement) for the trail table (defaulted)\n\n sldg.meta.path:\n  Relative (to this file) or absolute path to JSON meta file (optional)\n  If present (and in the correct format), then emitted morsels with sources also\n  include this JSON.\n\n";
    private final Properties aux = new Properties();
    private final File configFile;
    private final File baseDir;
    private String srcUrl;
    private String srcDriverClass;
    private String srcDriverCp;
    private String hashUrl;
    private String hashDriverClass;
    private String hashDriverCp;
    private String hashTablePrefix;
    private String hashSkipSchema;
    private String hashChainSchema;
    private String hashTrailSchema;
    private String srcSalt;
    private String srcSizeQuery;
    private String srcRowQuery;
    private String metaPath;

    public ConfigFileBuilder(File configFile) {
        this.configFile = Objects.requireNonNull(configFile, "null configFile").getAbsoluteFile();
        if (this.configFile.exists()) {
            throw new IllegalArgumentException("config file path already exists: " + this.configFile);
        }
        this.baseDir = FileUtils.getParentDir((File)configFile);
    }

    public String getMetaPath() {
        return this.metaPath;
    }

    public void setMetaPath(String metaPath) {
        this.metaPath = metaPath;
    }

    public void setSourceUrl(String srcUrl) {
        this.srcUrl = srcUrl;
    }

    public String getSourceUrl() {
        return this.srcUrl;
    }

    public void setSourceConProperty(String name, String value) {
        this.setConProperty(name, value, "sldg.source.info.");
    }

    public Properties getSourceConProperties() {
        return TidyProperties.subProperties((Properties)this.aux, (String)"sldg.source.info.");
    }

    public boolean isValid() {
        try {
            this.toConfig();
            return true;
        }
        catch (IllegalStateException isx) {
            return false;
        }
    }

    public Config toConfig() throws IllegalStateException {
        Properties props = this.toProperties(true);
        try {
            return new Config(props);
        }
        catch (IllegalArgumentException iax) {
            throw new IllegalStateException(iax.getMessage());
        }
    }

    public Properties toProperties(boolean includeBase) {
        TidyProperties props = new TidyProperties(Config.PROP_NAMES);
        props.putAll((Map<?, ?>)this.aux);
        this.set((Properties)props, "sldg.source.jdbc.url", this.srcUrl);
        this.set((Properties)props, "sldg.source.jdbc.driver", this.srcDriverClass);
        this.set((Properties)props, "sldg.source.jdbc.driver.classpath", this.srcDriverCp);
        this.set((Properties)props, "sldg.hash.jdbc.url", this.hashUrl);
        this.set((Properties)props, "sldg.hash.jdbc.driver", this.hashDriverClass);
        this.set((Properties)props, "sldg.source.jdbc.driver", this.srcDriverClass);
        this.set((Properties)props, "sldg.hash.jdbc.driver.classpath", this.hashDriverCp);
        this.set((Properties)props, "sldg.hash.table.prefix", this.hashTablePrefix);
        this.set((Properties)props, "sldg.hash.schema.skip", this.hashSkipSchema);
        this.set((Properties)props, "sldg.hash.schema.trail", this.hashTrailSchema);
        this.set((Properties)props, "sldg.hash.schema.chain", this.hashChainSchema);
        this.set((Properties)props, "sldg.source.salt.seed", this.srcSalt);
        this.set((Properties)props, "sldg.source.query.size", this.srcSizeQuery);
        this.set((Properties)props, "sldg.source.query.row", this.srcRowQuery);
        this.set((Properties)props, "sldg.meta.path", this.metaPath);
        if (includeBase) {
            props.put("sldg.base.dir", this.baseDir.getAbsolutePath());
        }
        return props;
    }

    public void save() {
        Properties props = this.toProperties(false);
        File parentDir = this.configFile.getParentFile();
        if (parentDir != null) {
            FileUtils.ensureDir((File)parentDir);
        }
        try (FileOutputStream out = new FileOutputStream(this.configFile);){
            props.store(out, this.preamble());
        }
        catch (IOException iox) {
            throw new UncheckedIOException("while attempting to write to <" + this.configFile + ">: " + iox, iox);
        }
    }

    protected String preamble() {
        return PREAMBLE;
    }

    private void set(Properties props, String name, String value) {
        if (value != null) {
            props.put(name, value);
        }
    }

    public final File getConfigFile() {
        return this.configFile;
    }

    public final File getBaseDir() {
        return this.baseDir;
    }

    public String getSourceDriverClass() {
        return this.srcDriverClass;
    }

    public void setSourceDriverClass(String srcDriverClass) {
        this.srcDriverClass = srcDriverClass;
    }

    public String getSourceDriverClasspath() {
        return this.srcDriverCp;
    }

    public void setSourceDriverClasspath(String srcDriverCp) {
        this.srcDriverCp = srcDriverCp;
    }

    public String getHashUrl() {
        return this.hashUrl;
    }

    public void setHashUrl(String hashUrl) {
        this.hashUrl = hashUrl;
    }

    public void setHashConProperty(String name, String value) {
        this.setConProperty(name, value, "sldg.hash.info.");
    }

    public Properties getHashConProperties() {
        return TidyProperties.subProperties((Properties)this.aux, (String)"sldg.hash.info.");
    }

    private void setConProperty(String name, String value, String prefix) {
        if (((String)(name = ((String)name).trim())).isEmpty()) {
            throw new IllegalArgumentException("empty property name");
        }
        name = prefix + (String)name;
        if (value == null) {
            this.aux.remove(name);
        } else {
            this.aux.put(name, value);
        }
    }

    public String getHashDriverClass() {
        return this.hashDriverClass;
    }

    public void setHashDriverClass(String hashDriverClass) {
        this.hashDriverClass = hashDriverClass;
    }

    public String getHashDriverClasspath() {
        return this.hashDriverCp;
    }

    public void setHashDriverClasspath(String hashDriverCp) {
        this.hashDriverCp = hashDriverCp;
    }

    public String getHashTablePrefix() {
        return this.hashTablePrefix;
    }

    public void setHashTablePrefix(String hashTablePrefix) {
        this.hashTablePrefix = hashTablePrefix;
    }

    public final String getSrcSalt() {
        return this.srcSalt;
    }

    public void seedSourceSalt() {
        byte[] seed = new byte[SldgConstants.HASH_WIDTH];
        new SecureRandom().nextBytes(seed);
        this.srcSalt = IntegralStrings.toHex((byte[])seed);
    }

    public String getSourceSizeQuery() {
        return this.srcSizeQuery;
    }

    public void setSourceSizeQuery(String srcSizeQuery) {
        this.srcSizeQuery = srcSizeQuery;
    }

    public String getSourceRowQuery() {
        return this.srcRowQuery;
    }

    public void setSourceRowQuery(String srcRowQuery) {
        this.srcRowQuery = srcRowQuery;
    }

    public String getHashSkipSchema() {
        return this.hashSkipSchema;
    }

    public void setHashSkipSchema(String hashSkipSchema) {
        this.hashSkipSchema = hashSkipSchema;
    }

    public String getHashChainSchema() {
        return this.hashChainSchema;
    }

    public void setHashChainSchema(String hashChainSchema) {
        this.hashChainSchema = hashChainSchema;
    }

    public void setDefaultSkipSchema() {
        this.checkTablePrefix();
        this.hashSkipSchema = HashLedgerSchema.protoSkipTableSchema(this.hashTablePrefix);
    }

    private void checkTablePrefix() {
        if (this.hashTablePrefix == null || this.hashTablePrefix.isBlank()) {
            throw new IllegalStateException("hash table prefix not set");
        }
    }

    public void setDefaultChainSchema() {
        this.checkTablePrefix();
        this.hashChainSchema = HashLedgerSchema.protoChainTableSchema(this.hashTablePrefix);
    }

    public String getHashTrailSchema() {
        return this.hashTrailSchema;
    }

    public void setHashTrailSchema(String hashTrailSchema) {
        this.hashTrailSchema = hashTrailSchema;
    }

    public void setDefaultTrailSchema() {
        this.checkTablePrefix();
        this.hashTrailSchema = HashLedgerSchema.protoTrailTableSchema(this.hashTablePrefix);
    }

    public void setDefaultHashSchemas() {
        this.setDefaultSkipSchema();
        this.setDefaultTrailSchema();
        this.setDefaultChainSchema();
    }

    public void setDefaultHashSchemas(String hashTablePrefix) {
        this.setHashTablePrefix(hashTablePrefix);
        this.setDefaultHashSchemas();
    }
}

