/*
 * Decompiled with CFR 0.152.
 */
package io.crums.sldg.sql;

import io.crums.io.FileUtils;
import io.crums.sldg.SldgConstants;
import io.crums.sldg.json.SourceInfoParser;
import io.crums.sldg.sql.ConnectionInfo;
import io.crums.sldg.sql.HashLedgerSchema;
import io.crums.sldg.sql.SqlSourceQuery;
import io.crums.sldg.src.SourceInfo;
import io.crums.sldg.src.TableSalt;
import io.crums.util.IntegralStrings;
import io.crums.util.Lists;
import io.crums.util.TidyProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;

public class Config {
    public static final String ROOT = "sldg.";
    public static final String BASE_DIR = "sldg.base.dir";
    public static final String SOURCE_JDBC_URL = "sldg.source.jdbc.url";
    public static final String SOURCE_JDBC_DRIVER = "sldg.source.jdbc.driver";
    public static final String SOURCE_JDBC_DRIVER_CLASSPATH = "sldg.source.jdbc.driver.classpath";
    public static final String SOURCE_SALT_SEED = "sldg.source.salt.seed";
    public static final String SOURCE_QUERY_SIZE = "sldg.source.query.size";
    public static final String SOURCE_QUERY_ROW = "sldg.source.query.row";
    public static final String HASH_JDBC_URL = "sldg.hash.jdbc.url";
    public static final String HASH_JDBC_DRIVER = "sldg.hash.jdbc.driver";
    public static final String HASH_JDBC_DRIVER_CLASSPATH = "sldg.hash.jdbc.driver.classpath";
    public static final String HASH_TABLE_PREFIX = "sldg.hash.table.prefix";
    public static final String HASH_SCHEMA_SKIP = "sldg.hash.schema.skip";
    public static final String HASH_SCHEMA_CHAIN = "sldg.hash.schema.chain";
    public static final String HASH_SCHEMA_TRAIL = "sldg.hash.schema.trail";
    public static final String SOURCE_INFO_PREFIX = "sldg.source.info.";
    public static final String HASH_INFO_PREFIX = "sldg.hash.info.";
    public static final String META_PATH = "sldg.meta.path";
    public static final List<String> PROP_NAMES = Lists.asReadOnlyList((Object[])new String[]{"sldg.base.dir", "sldg.meta.path", "sldg.source.jdbc.url", "sldg.source.jdbc.driver", "sldg.source.jdbc.driver.classpath", "sldg.source.query.size", "sldg.source.query.row", "sldg.source.salt.seed", "sldg.hash.jdbc.url", "sldg.hash.jdbc.driver", "sldg.hash.jdbc.driver.classpath", "sldg.hash.table.prefix", "sldg.hash.schema.skip", "sldg.hash.schema.chain", "sldg.hash.schema.trail"});
    protected final File baseDir;
    private final String srcUrl;
    private final String srcDriverClass;
    private final String srcDriverCp;
    private final String hashUrl;
    private final String hashDriverClass;
    private final String hashDriverCp;
    private final String hashTablePrefix;
    private final String hashSkipSchema;
    private final String hashChainSchema;
    private final String hashTrailSchema;
    private final String srcSalt;
    private final String srcSizeQuery;
    private final String srcRowQuery;
    private final Properties aux;
    private final String metaPath;

    public static Properties loadProperties(File propertiesFile) {
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(propertiesFile);){
            props.load(in);
        }
        catch (FileNotFoundException fnfx) {
            throw new IllegalArgumentException("properties file does not exist: " + propertiesFile);
        }
        catch (IOException iox) {
            throw new IllegalArgumentException("failed to read properties file: " + propertiesFile, iox);
        }
        File baseDir = FileUtils.getParentDir((File)propertiesFile);
        props.put(BASE_DIR, baseDir.getAbsolutePath());
        return props;
    }

    private ConnectionInfo srcConInfo() {
        return new ConnectionInfo(this.srcUrl, this.srcDriverClass, this.srcDriverCp);
    }

    private ConnectionInfo hashConInfo() {
        ConnectionInfo con = this.srcConInfo();
        if (this.dedicatedSourceCon()) {
            con = new ConnectionInfo(this.hashUrl, this.hashDriverClass, this.hashDriverCp, con);
        }
        return con;
    }

    public Config(File propertiesFile) {
        this(Config.loadProperties(propertiesFile));
    }

    public Config(Properties props) {
        this.baseDir = this.getBaseDir(props);
        this.srcUrl = props.getProperty(SOURCE_JDBC_URL);
        this.enforceRequired(SOURCE_JDBC_URL, this.srcUrl);
        this.srcDriverClass = props.getProperty(SOURCE_JDBC_DRIVER);
        this.srcDriverCp = props.getProperty(SOURCE_JDBC_DRIVER_CLASSPATH);
        this.enforceMeaningfulCp(this.srcDriverCp, this.srcDriverClass, SOURCE_JDBC_DRIVER_CLASSPATH, SOURCE_JDBC_DRIVER);
        this.hashUrl = props.getProperty(HASH_JDBC_URL);
        this.hashDriverClass = props.getProperty(HASH_JDBC_DRIVER);
        this.hashDriverCp = props.getProperty(HASH_JDBC_DRIVER_CLASSPATH);
        this.enforceMeaningfulCp(this.hashDriverCp, this.hashDriverClass, HASH_JDBC_DRIVER_CLASSPATH, HASH_JDBC_DRIVER);
        this.hashTablePrefix = props.getProperty(HASH_TABLE_PREFIX);
        this.enforceRequired(HASH_TABLE_PREFIX, this.hashTablePrefix);
        this.hashSkipSchema = props.getProperty(HASH_SCHEMA_SKIP);
        this.hashChainSchema = props.getProperty(HASH_SCHEMA_CHAIN);
        this.hashTrailSchema = props.getProperty(HASH_SCHEMA_TRAIL);
        this.srcSalt = this.getSrcSalt(props);
        this.srcSizeQuery = props.getProperty(SOURCE_QUERY_SIZE);
        this.enforceRequired(SOURCE_QUERY_SIZE, this.srcSizeQuery);
        this.srcRowQuery = props.getProperty(SOURCE_QUERY_ROW);
        this.enforceRequired(SOURCE_QUERY_ROW, this.srcRowQuery);
        this.aux = this.makeAux(props);
        this.metaPath = props.getProperty(META_PATH);
    }

    public Optional<SourceInfo> getSourceInfo() {
        SourceInfo srcInfo;
        if (this.metaPath == null) {
            return Optional.empty();
        }
        File file = FileUtils.getRelativeUnlessAbsolute((String)this.metaPath, (File)this.baseDir);
        if (!file.isFile()) {
            return Optional.empty();
        }
        try {
            srcInfo = (SourceInfo)SourceInfoParser.INSTANCE.toEntity(file);
        }
        catch (Exception x) {
            Logger.getGlobal().warning("Failed to parse " + file + " :: " + x.getMessage());
            srcInfo = null;
        }
        return Optional.ofNullable(srcInfo);
    }

    private Properties makeAux(Properties props) {
        Properties aux = new Properties(props);
        aux.keySet().removeAll(this.propNames());
        return aux;
    }

    private Properties getSrcInfo() {
        return this.getSubProperties(SOURCE_INFO_PREFIX);
    }

    private Properties getHashInfo() {
        return this.getSubProperties(HASH_INFO_PREFIX);
    }

    private Properties getSubProperties(String prefix) {
        return TidyProperties.subProperties((Properties)this.aux, (String)prefix);
    }

    private File getBaseDir(Properties props) {
        String baseDir = props.getProperty(BASE_DIR);
        this.enforceRequired(BASE_DIR, baseDir);
        File base = new File(baseDir);
        if (!base.isDirectory()) {
            throw new IllegalArgumentException("sldg.base.dir: " + baseDir + " not a directory");
        }
        return base.isAbsolute() ? base : base.getAbsoluteFile();
    }

    private String getSrcSalt(Properties props) {
        String hex = props.getProperty(SOURCE_SALT_SEED);
        this.enforceRequired(SOURCE_SALT_SEED, hex);
        if (!IntegralStrings.isHex((String)hex) || hex.length() != 2 * SldgConstants.HASH_WIDTH) {
            throw new IllegalArgumentException("sldg.source.salt.seed: " + hex);
        }
        return hex;
    }

    private void enforceRequired(String name, String value) {
        if (!this.isSet(value)) {
            throw new IllegalArgumentException("required property not set: " + name);
        }
    }

    private boolean isSet(String value) {
        return value != null && !value.isEmpty();
    }

    private void enforceMeaningfulCp(String driverCp, String driverClass, String cpPropName, String driverPropName) {
        if (this.isSet(driverCp)) {
            if (!driverCp.endsWith(".jar")) {
                throw new IllegalArgumentException("Only .jar files are supported. " + cpPropName + ": " + driverCp);
            }
            if (!this.isSet(driverClass)) {
                throw new IllegalArgumentException(cpPropName + " set while " + driverPropName + " is not");
            }
        }
    }

    public Properties getProperties() {
        return this.getTidyProperties();
    }

    public TidyProperties getTidyProperties() {
        TidyProperties props = new TidyProperties(this.propNames());
        props.putAll((Map)this.aux);
        props.put((Object)SOURCE_JDBC_URL, (Object)this.srcUrl);
        this.set((Properties)props, SOURCE_JDBC_DRIVER, this.srcDriverClass);
        this.set((Properties)props, SOURCE_JDBC_DRIVER_CLASSPATH, this.srcDriverCp);
        this.set((Properties)props, HASH_JDBC_URL, this.hashUrl);
        this.set((Properties)props, HASH_JDBC_DRIVER, this.hashDriverClass);
        this.set((Properties)props, SOURCE_JDBC_DRIVER, this.srcDriverClass);
        this.set((Properties)props, HASH_JDBC_DRIVER_CLASSPATH, this.hashDriverCp);
        props.put((Object)HASH_TABLE_PREFIX, (Object)this.hashTablePrefix);
        props.put((Object)HASH_SCHEMA_SKIP, (Object)this.hashSkipSchema);
        props.put((Object)HASH_SCHEMA_CHAIN, (Object)this.hashChainSchema);
        props.put((Object)HASH_SCHEMA_TRAIL, (Object)this.hashTrailSchema);
        props.put((Object)SOURCE_SALT_SEED, (Object)this.srcSalt);
        props.put((Object)SOURCE_QUERY_SIZE, (Object)this.srcSizeQuery);
        props.put((Object)SOURCE_QUERY_ROW, (Object)this.srcRowQuery);
        return props;
    }

    protected List<String> propNames() {
        return PROP_NAMES;
    }

    private void set(Properties props, String name, String value) {
        if (value != null) {
            props.put(name, value);
        }
    }

    public TableSalt getSourceSalt() {
        return new TableSalt(IntegralStrings.hexToBytes((CharSequence)this.srcSalt));
    }

    public String getHashTablePrefix() {
        return this.hashTablePrefix;
    }

    public HashLedgerSchema getHashLedgerSchema() {
        return new HashLedgerSchema(this);
    }

    public boolean dedicatedSourceCon() {
        return this.hashUrl != null && !this.hashUrl.equals(this.srcUrl);
    }

    public Connection getConnection() {
        if (!this.dedicatedSourceCon()) {
            throw new IllegalStateException("instance uses different JDBC connections for source- and hash-ledgers");
        }
        return this.getSourceConnection();
    }

    public Connection getSourceConnection() {
        return this.srcConInfo().open(this.baseDir, this.getSrcInfo());
    }

    public Connection getHashConnection() {
        if (this.hashUrl == null) {
            return this.getSourceConnection();
        }
        return this.hashConInfo().open(this.baseDir, this.getHashInfo());
    }

    public SqlSourceQuery.Builder getSourceBuilder() {
        return new SqlSourceQuery.DirectBuilder(this.srcSizeQuery, this.srcRowQuery);
    }

    public String getSkipTableSchema() {
        return this.hashSkipSchema;
    }

    public String getChainTableSchema() {
        return this.hashChainSchema;
    }

    public String getTrailTableSchema() {
        return this.hashTrailSchema;
    }
}

