/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl.intenal;

import io.crums.util.mrkl.intenal.Bytes;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;

public class ByteList
extends AbstractList<byte[]>
implements RandomAccess {
    protected final List<byte[]> source;

    public static ByteList newInstance(byte[][] arrays) {
        return ByteList.newInstance(arrays, true);
    }

    public static ByteList newInstance(byte[][] arrays, boolean copy) {
        ArrayList<byte[]> base = new ArrayList<byte[]>(arrays.length);
        for (int index = 0; index < arrays.length; ++index) {
            base.add(copy ? Bytes.copy(arrays[index]) : arrays[index]);
        }
        return new ByteList(base);
    }

    public ByteList(List<byte[]> source) {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public byte[] get(int index) {
        return Bytes.copy(this.source.get(index));
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof byte[])) {
            return false;
        }
        byte[] b = (byte[])o;
        for (byte[] array : this.source) {
            if (!Arrays.equals(array, b)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof byte[])) {
            return -1;
        }
        byte[] array = (byte[])o;
        ListIterator<byte[]> i = this.source.listIterator();
        while (i.hasNext()) {
            if (!Arrays.equals(array, i.next())) continue;
            return i.previousIndex();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof byte[])) {
            return -1;
        }
        byte[] array = (byte[])o;
        ListIterator<byte[]> i = this.source.listIterator(this.source.size());
        while (i.hasPrevious()) {
            if (!Arrays.equals(array, i.previous())) continue;
            return i.nextIndex();
        }
        return -1;
    }

    @Override
    public final boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof ByteList) {
            ByteList other = (ByteList)o;
            if (this.size() != other.size()) {
                return false;
            }
            int index = this.size();
            while (index-- > 0) {
                if (Arrays.equals(this.source.get(index), other.source.get(index))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int hash = 0;
        int index = this.size();
        while (index-- > 0) {
            hash ^= Arrays.hashCode(this.source.get(index));
        }
        return hash;
    }
}

