/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl.index;

import io.crums.util.mrkl.index.AbstractNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TreeIndex<N extends AbstractNode> {
    private final int[] levelCounts;
    private final NodeFactory<N> factory;

    public static TreeIndex<?> newGeneric(int count) {
        return new TreeIndex<AbstractNode>(count, AbstractNode.FACTORY);
    }

    public TreeIndex(int count, NodeFactory<N> factory) {
        this.levelCounts = this.computeLevelCounts(count);
        this.factory = Objects.requireNonNull(factory, "factory");
        factory.init(this);
    }

    public final int count() {
        return this.levelCounts[0];
    }

    public final int totalCount() {
        return 2 * this.count() - 1;
    }

    public final int totalCarries() {
        return this.totalCount() - this.totalCountSansCarries();
    }

    public final int totalCountSansCarries() {
        int total = 0;
        for (int level = this.height(); level >= 0; --level) {
            total += this.countSansCarry(level);
        }
        return total;
    }

    public final int serialIndex(int level, int index) throws IndexOutOfBoundsException {
        Objects.checkIndex(index, this.count(level));
        int zeroIndex = 0;
        for (int h = this.height(); h > level; --h) {
            zeroIndex += this.count(h);
        }
        return zeroIndex + index;
    }

    public final int height() {
        return this.levelCounts.length - 1;
    }

    public final int count(int level) throws IndexOutOfBoundsException {
        return this.levelCounts[level];
    }

    public final int countSansCarry(int level) {
        return this.count() >> level;
    }

    public final int maxIndex(int level) throws IndexOutOfBoundsException {
        return this.levelCounts[level] - 1;
    }

    public final boolean maxIndexJoinsCarry(int level) throws IndexOutOfBoundsException {
        return (this.levelCounts[level] & 1) == 1;
    }

    public final boolean hasCarry(int level) throws IndexOutOfBoundsException {
        return this.count(level) > this.countSansCarry(level);
    }

    public final boolean isCarry(int level, int index) {
        return index == this.count(level) - 1 && this.hasCarry(level);
    }

    public final boolean isRoot(AbstractNode node) {
        return node.level() == this.height();
    }

    public final N getNode(int level, int index) throws IndexOutOfBoundsException {
        Objects.checkIndex(index, this.count(level));
        return this.newNode(level, index, this.isRight(level, index));
    }

    public final N getNode(int serialIndex) throws IndexOutOfBoundsException {
        int index;
        int count;
        if (serialIndex < 0) {
            throw new IndexOutOfBoundsException(serialIndex);
        }
        int level = this.height();
        for (index = serialIndex; level >= 0 && index >= (count = this.count(level)); index -= count, --level) {
        }
        if (level == -1) {
            throw new IndexOutOfBoundsException(serialIndex);
        }
        return this.newNode(level, index, this.isRight(level, index));
    }

    public final N getParent(AbstractNode node) throws IndexOutOfBoundsException {
        return this.getParent(node.level(), node.index());
    }

    public final N getParent(int level, int index) throws IndexOutOfBoundsException {
        N sibling = this.getSibling(level, index);
        if (((AbstractNode)sibling).isLeft()) {
            level = ((AbstractNode)sibling).level();
            index = ((AbstractNode)sibling).index();
        }
        return this.newNode(++level, index >>= 1, this.isRight(level, index));
    }

    public final N getLeftChild(AbstractNode parent) throws IndexOutOfBoundsException {
        return this.getLeftChild(parent.level(), parent.index());
    }

    public final N getLeftChild(int level, int index) throws IndexOutOfBoundsException {
        Objects.checkFromToIndex(1, level, this.height());
        return this.newNode(level - 1, index << 1, false);
    }

    public final N getRightChild(AbstractNode parent) throws IndexOutOfBoundsException {
        return this.getRightChild(parent.level(), parent.index());
    }

    public final N getRightChild(int level, int index) throws IndexOutOfBoundsException {
        Objects.checkFromToIndex(1, level, this.height());
        return this.getSibling(level - 1, index << 1);
    }

    public final N getSibling(AbstractNode node) throws IndexOutOfBoundsException {
        return this.getSibling(node.level(), node.index());
    }

    public final N getSibling(int level, int index) throws IndexOutOfBoundsException {
        Objects.checkIndex(index, this.count(level));
        Objects.checkIndex(level, this.height());
        if ((index & 1) == 1) {
            return this.newNode(level, index - 1, false);
        }
        if (index < this.maxIndex(level)) {
            return this.newNode(level, index + 1, true);
        }
        if (!this.hasCarry(level)) {
            int subLevel = level;
            while (subLevel-- > 0) {
                if (this.maxIndexJoinsCarry(subLevel)) {
                    return this.newNode(subLevel, this.maxIndex(subLevel), true);
                }
                if (!this.hasCarry(subLevel)) continue;
            }
        }
        while (!this.maxIndexJoinsCarry(++level)) {
        }
        return this.newNode(level, this.maxIndex(level), false);
    }

    public final boolean isRight(int level, int index) throws IndexOutOfBoundsException {
        Objects.checkIndex(index, this.count(level));
        if ((index & 1) == 1) {
            return true;
        }
        if (index != this.maxIndex(level)) {
            return false;
        }
        if (level == this.height()) {
            assert (index == 0);
            return false;
        }
        int carries = 0;
        for (int v = level; v >= 0; --v) {
            if (this.maxIndexJoinsCarry(v)) {
                ++carries;
            }
            if (this.hasCarry(v)) break;
        }
        switch (carries) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new AssertionError((Object)("(" + level + "," + index + "): " + carries));
    }

    public final boolean isLeft(int level, int index) throws IndexOutOfBoundsException {
        return !this.isRight(level, index);
    }

    public final List<N> getFrontier() {
        int level = 0;
        int levelCountSansCarry = this.count();
        int frontierSize = Integer.bitCount(levelCountSansCarry);
        ArrayList<N> frontier = new ArrayList<N>(frontierSize);
        while (frontier.size() < frontierSize) {
            if ((levelCountSansCarry & 1) == 1) {
                int index = levelCountSansCarry - 1;
                boolean right = this.isRight(level, index);
                N node = this.newNode(level, index, right);
                frontier.add(node);
            }
            ++level;
            levelCountSansCarry >>= 1;
        }
        return Collections.unmodifiableList(frontier);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TreeIndex) {
            return this.count() == ((TreeIndex)o).count();
        }
        return false;
    }

    public final int hashCode() {
        return this.count();
    }

    public String toString() {
        return "TreeIndex(" + this.count() + ")";
    }

    public static int rootHeightForCount(int count) throws IllegalArgumentException {
        if (count < 2) {
            throw new IllegalArgumentException("count (" + count + ") < 2");
        }
        return 32 - Integer.numberOfLeadingZeros(count - 1);
    }

    private N newNode(int level, int index, boolean right) {
        return this.factory.newNode(level, index, right);
    }

    private int[] computeLevelCounts(int count) {
        int divCount;
        int[] levelCounts = new int[1 + TreeIndex.rootHeightForCount(count)];
        levelCounts[0] = divCount = count;
        int carry = divCount & 1;
        levelCounts[1] = divCount >>= 1;
        carry += divCount & 1;
        for (int level = 2; level < levelCounts.length; ++level) {
            divCount >>= 1;
            if (carry == 2) {
                carry = 0;
            }
            levelCounts[level] = ++divCount;
            carry += divCount & 1;
        }
        return levelCounts;
    }

    public static interface NodeFactory<N extends AbstractNode> {
        default public void init(TreeIndex<N> host) {
        }

        public N newNode(int var1, int var2, boolean var3);
    }
}

