/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl.index;

import io.crums.util.mrkl.index.TreeIndex;

public abstract class AbstractNode {
    public static TreeIndex.NodeFactory<AbstractNode> FACTORY = new TreeIndex.NodeFactory<AbstractNode>(){

        @Override
        public void init(TreeIndex<AbstractNode> host) {
        }

        @Override
        public AbstractNode newNode(int level, int index, final boolean right) {
            if (index == 0 && right) {
                throw new IllegalArgumentException("index 0 must be left");
            }
            return new AbstractNode(this, level, index){
                final /* synthetic */ 1 this$0;
                {
                    this.this$0 = this$0;
                    super(level, index);
                }

                @Override
                public boolean isRight() {
                    return right;
                }
            };
        }
    };
    private final int level;
    private final int index;

    protected AbstractNode(int level, int index) throws IndexOutOfBoundsException {
        this.level = level;
        this.index = index;
        if (level < 0 || level > 32) {
            throw new IndexOutOfBoundsException("level: " + level);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
    }

    public final int level() {
        return this.level;
    }

    public final boolean isLeaf() {
        return this.level == 0;
    }

    public final int index() {
        return this.index;
    }

    public final boolean isLeft() {
        return !this.isRight();
    }

    public abstract boolean isRight();

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractNode) {
            AbstractNode other = (AbstractNode)o;
            return this.index == other.index && this.level == other.level && this.isRight() == other.isRight();
        }
        return false;
    }

    public final int hashCode() {
        int state = this.level * 814279 + this.index;
        if (this.isRight()) {
            state = -state;
        }
        return state;
    }

    public String toString() {
        return "(" + this.level + ":" + this.index + ")";
    }
}

