/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Node;
import io.crums.util.mrkl.Proof;
import io.crums.util.mrkl.index.TreeIndex;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;

public abstract class Tree {
    public static final byte LEAF_PAD = 0;
    public static final byte BRANCH_PAD = 1;
    private final String algo;
    private final TreeIndex<Node> idx;

    public static byte[] hashLeaves(byte[] left, byte[] right, MessageDigest digest) {
        Tree.checkArgs(left, right, digest);
        return Tree.hashLeftRight(left, right, digest, (byte)0);
    }

    public static byte[] hashLeaves(ByteBuffer left, ByteBuffer right, MessageDigest digest) {
        Tree.checkArgs(left, right, digest);
        return Tree.hashLeftRight(left, right, digest, (byte)0);
    }

    public static byte[] hashInternals(byte[] left, byte[] right, MessageDigest digest) {
        byte[] hash = Tree.hashLeftRight(left, right, digest, (byte)1);
        if (left.length != hash.length) {
            throw new IllegalArgumentException("digest length/left length mismatch: " + hash.length + " (" + digest.getAlgorithm() + ") / " + left.length);
        }
        if (right.length != hash.length) {
            throw new IllegalArgumentException("digest length/right length mismatch: " + hash.length + " (" + digest.getAlgorithm() + ") / " + right.length);
        }
        return hash;
    }

    public static byte[] hashInternals(ByteBuffer left, ByteBuffer right, MessageDigest digest) {
        int lr = left.remaining();
        int rr = right.remaining();
        byte[] hash = Tree.hashLeftRight(left, right, digest, (byte)1);
        if (lr != hash.length) {
            throw new IllegalArgumentException("digest length /left remaining mismatch: " + hash.length + " (" + digest.getAlgorithm() + ") / " + lr);
        }
        if (rr != hash.length) {
            throw new IllegalArgumentException("digest length /right remaining mismatch: " + hash.length + " (" + digest.getAlgorithm() + ") / " + rr);
        }
        return hash;
    }

    public static byte[] hashUncommon(byte[] leftInternal, byte[] rightLeaf, MessageDigest digest) {
        Tree.checkArgs(leftInternal, rightLeaf, digest);
        if (leftInternal.length != digest.getDigestLength()) {
            throw new IllegalArgumentException("digest length / leftInternal length mismatch: " + digest.getDigestLength() + " (" + digest.getAlgorithm() + ") / " + leftInternal.length);
        }
        digest.reset();
        digest.update((byte)1);
        digest.update(leftInternal);
        digest.update((byte)0);
        digest.update(rightLeaf);
        return digest.digest();
    }

    public static byte[] hashUncommon(ByteBuffer leftInternal, ByteBuffer rightLeaf, MessageDigest digest) {
        Tree.checkArgs(leftInternal, rightLeaf, digest);
        if (leftInternal.remaining() != digest.getDigestLength()) {
            throw new IllegalArgumentException("digest length / leftInternal remaining mismatch: " + digest.getDigestLength() + " (" + digest.getAlgorithm() + ") / " + leftInternal.remaining());
        }
        digest.reset();
        digest.update((byte)1);
        digest.update(leftInternal);
        digest.update((byte)0);
        digest.update(rightLeaf);
        return digest.digest();
    }

    private static void checkArgs(Object left, Object right, MessageDigest digest) {
        Objects.requireNonNull(left, "left");
        Objects.requireNonNull(right, "right");
        Objects.requireNonNull(digest, "digest");
    }

    private static byte[] hashLeftRight(byte[] left, byte[] right, MessageDigest digest, byte padding) {
        digest.reset();
        digest.update(padding);
        digest.update(left);
        digest.update(padding);
        digest.update(right);
        return digest.digest();
    }

    private static byte[] hashLeftRight(ByteBuffer left, ByteBuffer right, MessageDigest digest, byte padding) {
        digest.reset();
        digest.update(padding);
        digest.update(left);
        digest.update(padding);
        digest.update(right);
        return digest.digest();
    }

    protected Tree(int leaves, String algo) {
        this.algo = Objects.requireNonNull(algo, "algo");
        this.idx = new TreeIndex<Node>(leaves, new NodeFactory());
    }

    protected Tree(Tree copy) {
        this.algo = copy.algo;
        this.idx = copy.idx;
    }

    public final Node root() {
        return this.idx.getNode(0);
    }

    public final byte[] hash() {
        return this.data(this.idx.height(), 0);
    }

    public final String getHashAlgo() {
        return this.algo;
    }

    public final TreeIndex<Node> idx() {
        return this.idx;
    }

    final boolean verify(Node node, MessageDigest digest) {
        byte[] hash;
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(digest, "digest");
        if (!this.getHashAlgo().equals(digest.getAlgorithm())) {
            throw new IllegalArgumentException("Algo mismatch. Expected '" + this.getHashAlgo() + "'; digest's is '" + digest.getAlgorithm() + "'");
        }
        if (node.isLeaf()) {
            return true;
        }
        try {
            byte[] left = this.data(node.leftChild());
            byte[] right = this.data(node.rightChild());
            hash = node.isCarry() && node.rightChild().isLeaf() ? Tree.hashUncommon(left, right, digest) : (node.level() == 1 ? Tree.hashLeaves(left, right, digest) : Tree.hashInternals(left, right, digest));
        }
        catch (IllegalArgumentException iax) {
            return false;
        }
        return Arrays.equals(hash, this.data(node));
    }

    final byte[] data(Node node) {
        return this.data(node.level(), node.index());
    }

    public abstract byte[] data(int var1, int var2);

    public abstract int leafWidth();

    public final boolean isLeafWidthFixed() {
        return this.leafWidth() > 0;
    }

    public final boolean isOmniWidth() {
        return this.hashAlgoWidth() == this.leafWidth();
    }

    public final int hashAlgoWidth() {
        return this.idx().getNode(1, 0).data().length;
    }

    public final Proof proof(int leafIndex) {
        return new Proof(this, leafIndex);
    }

    public String toString() {
        StringBuilder string = new StringBuilder(32);
        string.append(this.getClass().getSimpleName()).append('[');
        return this.appendToStringDetail(string).append(']').toString();
    }

    protected StringBuilder appendToStringDetail(StringBuilder string) {
        string.append(this.algo).append(':').append(this.idx.count());
        if (this.isOmniWidth()) {
            string.append(":omni");
        } else if (this.isLeafWidthFixed()) {
            string.append(":fixed:").append(this.leafWidth());
        } else {
            string.append(":var");
        }
        return string;
    }

    private class NodeFactory
    implements TreeIndex.NodeFactory<Node> {
        private NodeFactory() {
        }

        @Override
        public Node newNode(int level, int index, boolean right) {
            return new Node(level, index, Tree.this);
        }
    }
}

