/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Node;
import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.index.AbstractNode;
import io.crums.util.mrkl.index.TreeIndex;
import io.crums.util.mrkl.intenal.ByteList;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Proof {
    private final String algo;
    private final int leafCount;
    private final int leafIndex;
    private final List<byte[]> hashChain;

    public Proof(Tree tree, int leafIndex) throws IndexOutOfBoundsException {
        this.algo = tree.getHashAlgo();
        this.leafCount = tree.idx().count();
        this.leafIndex = leafIndex;
        ArrayList<byte[]> chain = new ArrayList<byte[]>(tree.idx().height() + 1);
        Node node = tree.idx().getNode(0, leafIndex);
        chain.add(node.data());
        Node parent = node;
        while (!parent.isRoot()) {
            chain.add(parent.sibling().data());
            parent = parent.parent();
        }
        chain.add(tree.root().data());
        this.hashChain = chain;
        this.checkChainLength();
    }

    public Proof(String algo, int leafCount, int leafIndex, byte[][] chain) {
        this(algo, leafCount, leafIndex, chain, true);
        this.checkChainLength();
    }

    public Proof(String algo, int leafCount, int leafIndex, byte[][] chain, boolean copy) {
        this.algo = Objects.requireNonNull(algo, "algo");
        Objects.checkIndex(leafIndex, leafCount);
        this.leafCount = leafCount;
        this.leafIndex = leafIndex;
        this.hashChain = new ArrayList<byte[]>(chain.length);
        for (byte[] link : chain) {
            this.hashChain.add(copy ? Arrays.copyOf(link, link.length) : link);
        }
        this.checkChainLength();
    }

    private void checkChainLength() {
        int cLen = Proof.chainLength(this.leafCount, this.leafIndex);
        if (this.hashChain.size() != cLen) {
            throw new IllegalArgumentException("illegal chain length, expected " + cLen + "; but was " + this.hashChain.size());
        }
    }

    protected Proof(Proof copy) {
        Objects.requireNonNull(copy, "null proof");
        this.algo = copy.algo;
        this.leafCount = copy.leafCount;
        this.leafIndex = copy.leafIndex;
        this.hashChain = copy.hashChain;
    }

    public final boolean verify(MessageDigest digest) {
        if (!digest.getAlgorithm().equals(this.algo)) {
            throw new IllegalArgumentException("algo mismatch: expected '" + this.algo + "'; digest's '" + digest.getAlgorithm() + "'");
        }
        byte[] rootHash = Proof.merkeRootInternal(this.leafIndex, this.leafCount, this.chain(), digest);
        return Arrays.equals(rootHash, this.rootHash());
    }

    public static int chainLength(int leafCount, int leafIndex) {
        TreeIndex<?> tree = TreeIndex.newGeneric(leafCount);
        Object node = tree.getNode(0, leafIndex);
        int count = 2;
        while (!tree.isRoot((AbstractNode)node)) {
            ++count;
            node = tree.getParent((AbstractNode)node);
        }
        return count;
    }

    public static int funnelLength(int leafCount, int leafIndex) {
        return Proof.chainLength(leafCount, leafIndex) - 2;
    }

    public static byte[] merkleRoot(ByteBuffer item, int index, int count, List<ByteBuffer> funnel, MessageDigest digest) {
        if (funnel.size() != Proof.funnelLength(count, index)) {
            throw new IllegalArgumentException("funnel size (" + funnel.size() + ") for " + index + ":" + count + "; expected " + Proof.funnelLength(count, index));
        }
        ArrayList<ByteBuffer> chain = new ArrayList<ByteBuffer>(){

            @Override
            public ByteBuffer get(int index) {
                return ((ByteBuffer)super.get(index)).slice();
            }
        };
        chain.add(item);
        chain.addAll(funnel);
        return Proof.merkeRootInternal(index, count, (List<ByteBuffer>)chain, digest);
    }

    private static byte[] merkeRootInternal(int index, int count, List<ByteBuffer> hashChain, MessageDigest digest) {
        byte[] hash;
        TreeIndex<?> tree = TreeIndex.newGeneric(count);
        Object node = tree.getSibling(0, index);
        if (((AbstractNode)node).isLeaf()) {
            ByteBuffer right;
            ByteBuffer left;
            if (((AbstractNode)node).isLeft()) {
                left = hashChain.get(1);
                right = hashChain.get(0);
            } else {
                left = hashChain.get(0);
                right = hashChain.get(1);
            }
            hash = Tree.hashLeaves(left, right, digest);
        } else {
            assert (((AbstractNode)node).isLeft());
            hash = Tree.hashUncommon(hashChain.get(1), hashChain.get(0), digest);
        }
        node = tree.getParent((AbstractNode)node);
        int cindex = 2;
        while (((AbstractNode)node).level() != tree.height()) {
            Object rightNode;
            ByteBuffer right;
            ByteBuffer left;
            if (((AbstractNode)node).isLeft()) {
                left = ByteBuffer.wrap(hash);
                right = hashChain.get(cindex);
                rightNode = tree.getSibling((AbstractNode)node);
                assert (!((AbstractNode)node).isLeaf());
            } else {
                left = hashChain.get(cindex);
                right = ByteBuffer.wrap(hash);
                rightNode = node;
            }
            hash = ((AbstractNode)rightNode).isLeaf() ? Tree.hashUncommon(left, right, digest) : Tree.hashInternals(left, right, digest);
            node = tree.getParent((AbstractNode)node);
            ++cindex;
        }
        return hash;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Proof) {
            Proof other = (Proof)o;
            if (this.leafIndex != other.leafIndex || this.leafCount != other.leafCount || !other.algo.equals(this.algo)) {
                return false;
            }
            return other.hashChain().equals(this.hashChain());
        }
        return false;
    }

    public final int hashCode() {
        int hash = this.hashChain.hashCode();
        return hash ^ this.leafIndex ^ 2 * this.leafCount - 1;
    }

    public final int leafIndex() {
        return this.leafIndex;
    }

    public final int leafCount() {
        return this.leafCount;
    }

    public final String getHashAlgo() {
        return this.algo;
    }

    public final List<byte[]> hashChain() {
        return new ByteList(this.hashChain);
    }

    public final List<ByteBuffer> chain() {
        return new AbstractList<ByteBuffer>(){

            @Override
            public int size() {
                return Proof.this.hashChain.size();
            }

            @Override
            public ByteBuffer get(int index) {
                return ByteBuffer.wrap(Proof.this.hashChain.get(index)).asReadOnlyBuffer();
            }
        };
    }

    public final List<ByteBuffer> funnel() {
        return this.chain().subList(1, this.hashChain.size() - 1);
    }

    public final byte[] rootHash() {
        byte[] root = this.hashChain.get(this.hashChain.size() - 1);
        return Arrays.copyOf(root, root.length);
    }

    public final byte[] item() {
        byte[] item = this.hashChain.get(0);
        return Arrays.copyOf(item, item.length);
    }
}

