/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.index.AbstractNode;
import java.security.MessageDigest;

public class Node
extends AbstractNode {
    private final Tree tree;

    Node(int level, int index, Tree tree) {
        super(level, index);
        this.tree = tree;
    }

    @Override
    public final boolean isRight() {
        return this.tree.idx().isRight(this.level(), this.index());
    }

    public final int serialIndex() {
        return this.tree.idx().serialIndex(this.level(), this.index());
    }

    public byte[] data() {
        return this.tree.data(this.level(), this.index());
    }

    public boolean verify(MessageDigest digest) {
        return this.tree.verify(this, digest);
    }

    public final boolean isRoot() {
        return this.level() == this.tree.idx().height();
    }

    public Node sibling() {
        return this.isRoot() ? null : this.tree.idx().getSibling(this);
    }

    public Node parent() {
        return this.isRoot() ? null : this.tree.idx().getParent(this);
    }

    public Node leftChild() {
        return this.isLeaf() ? null : this.tree.idx().getLeftChild(this);
    }

    public Node rightChild() {
        return this.isLeaf() ? null : this.tree.idx().getRightChild(this);
    }

    public Node getRoot() {
        return this.isRoot() ? this : this.tree.idx().getNode(this.tree.idx().height(), 0);
    }

    public Node getLeaf(int index) throws IndexOutOfBoundsException {
        return this.index() == index && this.level() == 0 ? this : this.tree.idx().getNode(0, index);
    }

    public final boolean isCarry() {
        return !this.isLeaf() && this.leftChild().level() != this.rightChild().level();
    }

    public final int leafCount() {
        return this.tree.idx().count();
    }

    public Tree tree() {
        return this.tree;
    }
}

