/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Tree;
import java.util.AbstractList;
import java.util.Objects;
import java.util.RandomAccess;

class LevelByteList
extends AbstractList<byte[]>
implements RandomAccess {
    private final Tree tree;
    private final int level;
    private final int size;

    public LevelByteList(Tree tree, int level) throws IndexOutOfBoundsException {
        this(tree, level, false);
    }

    public LevelByteList(Tree tree, int level, boolean includeCarry) throws IndexOutOfBoundsException {
        this.tree = Objects.requireNonNull(tree, "tree");
        this.level = level;
        this.size = includeCarry || !tree.idx().hasCarry(level) ? tree.idx().count(level) : tree.idx().count(level) - 1;
    }

    @Override
    public byte[] get(int index) {
        Objects.checkIndex(index, this.size);
        return this.tree.data(this.level, index);
    }

    public final int level() {
        return this.level;
    }

    public final Tree tree() {
        return this.tree;
    }

    @Override
    public int size() {
        return this.size;
    }
}

