/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.intenal.Bytes;
import java.util.Objects;

public class FreeLeafTree
extends Tree {
    private final byte[][] data;

    public FreeLeafTree(byte[][] data, int leaves, String algo) {
        this(data, leaves, algo, true);
    }

    public FreeLeafTree(byte[][] data, int leaves, String algo, boolean copy) {
        super(leaves, algo);
        Objects.requireNonNull(data, "data");
        byte[][] byArray = this.data = copy ? this.deepCopy(data) : data;
        if (data.length != this.idx().totalCount()) {
            throw new IllegalArgumentException("expected " + this.idx().totalCount() + " data elements for " + leaves + " many leaves; only " + data.length + " are given");
        }
    }

    @Override
    public byte[] data(int level, int index) {
        int serialIndex = this.idx().serialIndex(level, index);
        return Bytes.copy(this.data[serialIndex]);
    }

    public final byte[] data(int serialIndex) {
        return Bytes.copy(this.data[serialIndex]);
    }

    private byte[][] deepCopy(byte[][] data) {
        byte[][] copy = new byte[data.length][];
        int index = data.length;
        while (index-- > 0) {
            copy[index] = Bytes.copy(data[index]);
        }
        return copy;
    }

    @Override
    public int leafWidth() {
        return -1;
    }
}

