/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.intenal.Bytes;
import java.nio.ByteBuffer;
import java.util.Objects;

public class FixedLeafTree
extends Tree {
    public static final int MIN_ALGO_WIDTH = 8;
    public static final int MIN_LEAF_WIDTH = 1;
    private final byte[] data;
    private final int algoWidth;
    private final int leafWidth;
    private final int levelZeroOffset;

    public FixedLeafTree(int leaves, String algo, byte[] data, int algoWidth, int leafWidth) throws IllegalArgumentException {
        super(leaves, algo);
        this.data = Objects.requireNonNull(data, "data");
        this.algoWidth = algoWidth;
        this.leafWidth = leafWidth;
        FixedLeafTree.validateArgs(algoWidth, leafWidth);
        long zOff = (long)(this.idx().totalCount() - leaves) * (long)algoWidth;
        if (zOff >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("data provably too short");
        }
        this.levelZeroOffset = (int)zOff;
        if ((long)data.length < (long)this.levelZeroOffset + (long)leaves * (long)leafWidth) {
            throw new IllegalArgumentException("data too short");
        }
    }

    protected FixedLeafTree(FixedLeafTree copy) {
        super(copy);
        this.data = copy.data;
        this.algoWidth = copy.algoWidth;
        this.leafWidth = copy.leafWidth;
        this.levelZeroOffset = copy.levelZeroOffset;
    }

    @Override
    public byte[] data(int level, int index) {
        if (level == 0) {
            int offset = this.levelZeroOffset + index * this.leafWidth;
            return Bytes.copy(this.data, offset, this.leafWidth);
        }
        int offset = this.idx().serialIndex(level, index) * this.algoWidth;
        return Bytes.copy(this.data, offset, this.algoWidth);
    }

    @Override
    public int leafWidth() {
        return this.leafWidth;
    }

    public ByteBuffer dataBlock() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public ByteBuffer leavesBlock() {
        return ByteBuffer.wrap(this.data, this.levelZeroOffset, this.leafWidth * this.idx().count()).slice().asReadOnlyBuffer();
    }

    protected ByteBuffer extraBlock() {
        int startIndex = FixedLeafTree.treeDataLength(this.idx().count(), this.algoWidth, this.leafWidth);
        return ByteBuffer.wrap(this.data, startIndex, this.data.length - startIndex).slice().asReadOnlyBuffer();
    }

    public int hashWidth() {
        return this.algoWidth;
    }

    public static boolean fitsModelCapacity(int leaves, int algoWidth, int leafWidth) {
        return FixedLeafTree.treeDataLength(leaves, algoWidth, leafWidth) > 0;
    }

    public static int treeDataLength(int leaves, int algoWidth, int leafWidth) {
        if (leaves < 2) {
            throw new IllegalArgumentException("leaves (" + leaves + ") < 2");
        }
        FixedLeafTree.validateArgs(algoWidth, leafWidth);
        long bytes = (long)leaves * (long)leafWidth;
        return (bytes += ((long)leaves - 1L) * (long)algoWidth) <= Integer.MAX_VALUE ? (int)bytes : -1;
    }

    private static void validateArgs(int algoWidth, int leafWidth) {
        if (algoWidth < 8) {
            throw new IllegalArgumentException("algoWidth (" + algoWidth + ") < 8");
        }
        if (leafWidth < 1) {
            throw new IllegalArgumentException("leafWidth (" + leafWidth + ") < 1");
        }
    }
}

