/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Builder;
import io.crums.util.mrkl.FixedLeafTree;
import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.index.TreeIndex;
import io.crums.util.mrkl.intenal.Bytes;

public class FixedLeafBuilder
extends Builder {
    private final int leafWidth;

    public FixedLeafBuilder(String algo) {
        this(algo, true);
    }

    public FixedLeafBuilder(String algo, int leafWidth) throws IllegalArgumentException {
        this(algo, leafWidth, true);
    }

    public FixedLeafBuilder(String algo, int leafWidth, boolean copyOnWrite) throws IllegalArgumentException {
        super(algo, copyOnWrite);
        this.leafWidth = leafWidth;
        if (leafWidth < 1) {
            throw new IllegalArgumentException("leaf width: " + leafWidth);
        }
    }

    public FixedLeafBuilder(String algo, boolean copyOnWrite) throws IllegalArgumentException {
        super(algo, copyOnWrite);
        this.leafWidth = this.hashWidth();
    }

    protected FixedLeafBuilder(FixedLeafBuilder copy) {
        super(copy);
        this.leafWidth = copy.leafWidth;
    }

    FixedLeafBuilder(Builder copy) {
        super(copy);
        this.leafWidth = copy.leafWidth();
        if (this.leafWidth < 1) {
            throw new IllegalArgumentException("not a fixed leaf width: " + this.leafWidth);
        }
    }

    @Override
    public int leafWidth() {
        return this.leafWidth;
    }

    @Override
    public int add(byte[] item, int off, int len) throws IllegalArgumentException, IndexOutOfBoundsException {
        if (len != this.leafWidth) {
            throw new IllegalArgumentException("len " + len + "; expected " + this.leafWidth);
        }
        return super.add(item, off, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree build() {
        Object object = this.lock;
        synchronized (object) {
            this.completeTree();
            Tree tree = this.packageTree();
            this.clear();
            return tree;
        }
    }

    @Override
    protected Tree packageTree() {
        int fixedByteSize = FixedLeafTree.treeDataLength(this.count(), this.digest.getDigestLength(), this.leafWidth);
        TreeIndex<?> idx = TreeIndex.newGeneric(this.count());
        byte[] buffer = new byte[fixedByteSize];
        int pos = 0;
        int pWidth = this.digest.getDigestLength();
        for (int level = idx.height(); level > 0; --level) {
            int index = 0;
            while (index < this.levelSize(level)) {
                Bytes.transfer(this.level(level).get(index), buffer, pos);
                ++index;
                pos += pWidth;
            }
        }
        int index = 0;
        while (index < this.count()) {
            Bytes.transfer(this.level(0).get(index), buffer, pos);
            ++index;
            pos += this.leafWidth;
        }
        assert (pos == buffer.length);
        return new FixedLeafTree(this.count(), this.getHashAlgo(), buffer, pWidth, this.leafWidth);
    }
}

