/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.intenal.Bytes;
import java.util.Objects;

public class DeltaTree
extends Tree {
    private final Tree base;
    private final byte[] deltaNodes;

    public DeltaTree(Tree base, byte[] deltaNodes) {
        super(DeltaTree.computeNewLeafCount(base, deltaNodes), base.getHashAlgo());
        this.base = base;
        this.deltaNodes = deltaNodes;
    }

    protected DeltaTree(DeltaTree copy) {
        super(copy);
        this.base = copy.base;
        this.deltaNodes = copy.deltaNodes;
    }

    public static int computeNewLeafCount(Tree base, byte[] deltaNodes) throws IllegalArgumentException {
        Objects.requireNonNull(base, "base");
        Objects.requireNonNull(deltaNodes, "deltaNodes");
        if (!base.isOmniWidth()) {
            throw new IllegalArgumentException("only omni-width trees are supported: " + String.valueOf(base));
        }
        int nodeWidth = base.leafWidth();
        int newNodes = deltaNodes.length / nodeWidth;
        if (newNodes <= 0) {
            throw new IllegalArgumentException("empty deltaNodes array");
        }
        if (newNodes * nodeWidth != deltaNodes.length) {
            throw new IllegalArgumentException("deltaNodes.length " + deltaNodes.length + " not a multiple of node width " + nodeWidth);
        }
        int newTotalCount = base.idx().totalCountSansCarries() + newNodes;
        if ((newTotalCount & 1) == 0) {
            throw new IllegalArgumentException("total node count after append must be odd: " + String.valueOf(base) + "; new nodes " + newNodes);
        }
        return (newTotalCount + 1) / 2;
    }

    @Override
    public byte[] data(int level, int index) {
        if (index < this.base.idx().countSansCarry(level)) {
            return this.base.data(level, index);
        }
        int deltaIndex = 0;
        for (int lev = this.idx().height(); lev > level; --lev) {
            deltaIndex += this.idx().count(lev) - this.base.idx().countSansCarry(lev);
        }
        int offset = (deltaIndex += index - this.base.idx().countSansCarry(level)) * this.leafWidth();
        return Bytes.copy(this.deltaNodes, offset, this.base.leafWidth());
    }

    @Override
    public int leafWidth() {
        return this.base.leafWidth();
    }
}

