/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.DeltaTree;
import io.crums.util.mrkl.FixedLeafBuilder;
import io.crums.util.mrkl.LevelByteList;
import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.intenal.Bytes;
import io.crums.util.mrkl.intenal.ListExtension;
import java.util.List;

public class DeltaBuilder
extends FixedLeafBuilder {
    private final Tree base;
    private final int nodeWidth;
    private int itemsAdded;

    public DeltaBuilder(Tree tree) {
        this(tree, true);
    }

    public DeltaBuilder(Tree tree, boolean copyOnWrite) {
        super(tree.getHashAlgo(), tree.leafWidth(), copyOnWrite);
        this.base = tree;
        this.nodeWidth = this.base.leafWidth();
        if (!this.base.isOmniWidth()) {
            throw new IllegalArgumentException("only omni-width trees are supported: " + String.valueOf(this.base));
        }
        this.data.clear();
        int heightSansCarries = 31 - Integer.numberOfLeadingZeros(this.base.idx().count());
        for (int level = 0; level <= heightSansCarries; ++level) {
            LevelByteList treeLevelData = new LevelByteList(this.base, level);
            this.data.add(new ListExtension<byte[]>(treeLevelData));
        }
        assert (((List)this.data.get(this.data.size() - 1)).size() == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree build() {
        Object object = this.lock;
        synchronized (object) {
            if (this.itemsAdded() == 0 && this.base.idx().totalCarries() == 0) {
                return this.base;
            }
            return super.build();
        }
    }

    @Override
    protected DeltaTree packageTree() {
        int newNodes = 2 * this.count() - 1 - this.base.idx().totalCountSansCarries();
        byte[] appendedNodes = new byte[newNodes * this.nodeWidth];
        int offset = 0;
        int level = this.data.size();
        while (level-- > 0) {
            List levelNodes = (List)this.data.get(level);
            if (levelNodes instanceof ListExtension) {
                levelNodes = ((ListExtension)levelNodes).second();
            }
            for (byte[] node : levelNodes) {
                Bytes.transfer(node, appendedNodes, offset);
                offset += this.nodeWidth;
            }
        }
        assert (offset == appendedNodes.length);
        return new DeltaTree(this.base, appendedNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            int level = this.data.size();
            while (level-- > 0) {
                List levelData = (List)this.data.get(level);
                if (levelData instanceof ListExtension) {
                    ((ListExtension)levelData).second().clear();
                    continue;
                }
                levelData.clear();
                this.data.remove(level);
            }
            this.itemsAdded = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(byte[] item, int off, int len) throws IndexOutOfBoundsException {
        Object object = this.lock;
        synchronized (object) {
            int indexOfItem = super.add(item, off, len);
            ++this.itemsAdded;
            return indexOfItem;
        }
    }

    public int itemsAdded() {
        return this.itemsAdded;
    }
}

