/*
 * Decompiled with CFR 0.152.
 */
package io.crums.util.mrkl;

import io.crums.util.mrkl.FixedLeafBuilder;
import io.crums.util.mrkl.FreeLeafTree;
import io.crums.util.mrkl.Tree;
import io.crums.util.mrkl.index.AbstractNode;
import io.crums.util.mrkl.index.TreeIndex;
import io.crums.util.mrkl.intenal.Bytes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class Builder {
    protected final Object lock;
    protected final List<List<byte[]>> data;
    protected final MessageDigest digest;
    protected final boolean copyOnWrite;
    private int leafWidth = -2;
    private static final int LEAFWIDTH_UNSET = -2;
    private static final int LEAFWIDTH_VARIABLE = -1;

    public Builder(String algo) throws IllegalArgumentException {
        this(algo, true);
    }

    public Builder(String algo, boolean copyOnWrite) throws IllegalArgumentException {
        this.lock = new Object();
        this.data = new ArrayList<List<byte[]>>();
        try {
            this.digest = MessageDigest.getInstance(algo);
        }
        catch (NoSuchAlgorithmException nsax) {
            throw new IllegalArgumentException("algo: " + algo, nsax);
        }
        if (this.digest.getDigestLength() == 0) {
            throw new IllegalArgumentException(algo + " implementation does not advertise hash length");
        }
        this.copyOnWrite = copyOnWrite;
        this.data.add(new ArrayList());
    }

    protected Builder(Builder copy) {
        this.lock = copy.lock;
        this.digest = copy.digest;
        this.copyOnWrite = copy.copyOnWrite;
        this.data = copy.data;
        this.leafWidth = copy.leafWidth;
    }

    public int add(byte[] item) {
        return this.add(item, 0, item.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hash(byte[] data) {
        Object object = this.lock;
        synchronized (object) {
            this.digest.reset();
            return this.digest.digest(data);
        }
    }

    public final int hashWidth() {
        return this.digest.getDigestLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(byte[] item, int off, int len) throws IndexOutOfBoundsException {
        Object object = this.lock;
        synchronized (object) {
            this.level(0).add(this.copyImpl(item, off, len));
            if (len != this.leafWidth && this.leafWidth != -1) {
                int n = this.leafWidth = this.leafWidth == -2 ? len : -1;
            }
            if (this.levelPaired(0)) {
                this.nextLevel(0).add(Tree.hashLeaves(this.lastLeft(0), this.lastRight(0), this.digest));
                int index = 1;
                while (this.levelPaired(index)) {
                    this.nextLevel(index).add(Tree.hashInternals(this.lastLeft(index), this.lastRight(index), this.digest));
                    ++index;
                }
            }
            return this.count() - 1;
        }
    }

    private byte[] copyImpl(byte[] item, int off, int len) {
        if (this.copyOnWrite || off != 0 || len != item.length) {
            return Bytes.copy(item, off, len);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree build() {
        Object object = this.lock;
        synchronized (object) {
            Tree tree;
            if (this.leafWidth > 0) {
                tree = new FixedLeafBuilder(this).build();
            } else {
                this.completeTree();
                tree = this.packageTree();
            }
            this.clear();
            return tree;
        }
    }

    protected void completeTree() {
        if (this.count() < 2) {
            throw new IllegalStateException("nothing to build; count is " + this.count());
        }
        TreeIndex<?> idx = TreeIndex.newGeneric(this.count());
        assert (idx.height() == this.maxLevel() + 1 || idx.height() == this.maxLevel());
        for (int level = 1; level <= idx.height(); ++level) {
            if (idx.hasCarry(level)) {
                int index = idx.maxIndex(level);
                byte[] left = this.nodeData((AbstractNode)idx.getLeftChild(level, index));
                Object rightChild = idx.getRightChild(level, index);
                byte[] right = this.nodeData((AbstractNode)rightChild);
                byte[] parent = ((AbstractNode)rightChild).isLeaf() ? Tree.hashUncommon(left, right, this.digest) : Tree.hashInternals(left, right, this.digest);
                this.ensureLevel(level).add(parent);
            }
            assert (this.levelSize(level) == idx.count(level));
        }
    }

    protected Tree packageTree() {
        assert (this.leafWidth != -2);
        TreeIndex<?> idx = TreeIndex.newGeneric(this.count());
        byte[][] bb = new byte[idx.totalCount()][];
        int serialIndex = 0;
        for (int level = idx.height(); level >= 0; --level) {
            int index = 0;
            while (index < this.levelSize(level)) {
                bb[serialIndex] = this.level(level).get(index);
                ++index;
                ++serialIndex;
            }
        }
        return new FreeLeafTree(bb, this.count(), this.getHashAlgo(), false);
    }

    public int leafWidth() {
        return this.leafWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.data.forEach(level -> level.clear());
            this.data.clear();
            this.data.add(new ArrayList());
            this.leafWidth = -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int count() {
        Object object = this.lock;
        synchronized (object) {
            return this.level(0).size();
        }
    }

    public byte[] item(int index) throws IndexOutOfBoundsException {
        byte[] item = this.data.get(0).get(index);
        byte[] copy = new byte[item.length];
        int i = item.length;
        while (i-- > 0) {
            copy[i] = item[i];
        }
        return copy;
    }

    public final String getHashAlgo() {
        return this.digest.getAlgorithm();
    }

    protected final int levelSize(int level) {
        return this.data.get(level).size();
    }

    private int maxLevel() {
        return this.data.size() - 1;
    }

    private byte[] nodeData(AbstractNode node) {
        return this.level(node.level()).get(node.index());
    }

    private byte[] lastLeft(int level) {
        return this.lastSib(level, 2);
    }

    private byte[] lastRight(int level) {
        return this.lastSib(level, 1);
    }

    private byte[] lastSib(int level, int distance) {
        assert (this.levelPaired(level));
        List<byte[]> levelData = this.level(level);
        return levelData.get(levelData.size() - distance);
    }

    private boolean levelPaired(int index) {
        return (this.level(index).size() & 1) == 0;
    }

    private List<byte[]> ensureLevel(int index) {
        List<byte[]> level;
        if (this.data.size() == index) {
            level = this.newByteArrayList(index);
            this.data.add(level);
        } else {
            level = this.data.get(index);
        }
        return level;
    }

    protected List<byte[]> newByteArrayList(int level) {
        return new ArrayList<byte[]>();
    }

    protected final List<byte[]> level(int index) {
        return this.data.get(index);
    }

    private List<byte[]> nextLevel(int index) {
        return this.ensureLevel(index + 1);
    }
}

