/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.ODataHttpMethod;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataInternalServerErrorException;
import org.apache.olingo.odata2.api.exception.ODataMethodNotAllowedException;
import org.apache.olingo.odata2.api.exception.ODataNotAcceptableException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.ODataContextImpl;
import org.apache.olingo.odata2.core.ODataRequestHandler;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.servlet.ODataExceptionWrapper;
import org.apache.olingo.odata2.core.servlet.RestUtil;

public class ODataServlet
extends HttpServlet {
    public static ThreadLocal<HttpServletRequest> REQUEST = new ThreadLocal();
    public static ThreadLocal<HttpServletResponse> RESPONSE = new ThreadLocal();
    private static final String HTTP_METHOD_OPTIONS = "OPTIONS";
    private static final String HTTP_METHOD_HEAD = "HEAD";
    private static final String BUFFER_SIZE = "org.apache.olingo.odata2.core.servlet.buffer.size";
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final String DEFAULT_READ_CHARSET = "utf-8";
    public static ThreadLocal<Locale> LOCALE = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            REQUEST.set(req);
            RESPONSE.set(resp);
            LOCALE.set(req.getLocale());
            ODataServiceFactory serviceFactory = this.getServiceFactory(req);
            if (serviceFactory == null) {
                throw new ODataRuntimeException("Unable to get Service Factory. Check either 'org.apache.olingo.odata2.service.factory' or 'org.apache.olingo.odata2.service.factory.instance' config.");
            }
            String xHttpMethod = req.getHeader("X-HTTP-Method");
            String xHttpMethodOverride = req.getHeader("X-HTTP-Method-Override");
            if (xHttpMethod != null && xHttpMethodOverride != null && !xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
                ODataExceptionWrapper wrapper = new ODataExceptionWrapper(req, serviceFactory);
                this.createResponse(resp, wrapper.wrapInExceptionResponse((Exception)new ODataBadRequestException(ODataBadRequestException.AMBIGUOUS_XMETHOD)));
                return;
            }
            if (req.getPathInfo() != null) {
                this.handle(req, resp, xHttpMethod, xHttpMethodOverride, serviceFactory);
            } else {
                this.handleRedirect(req, resp, serviceFactory);
            }
        }
        finally {
            LOCALE.set(null);
            LOCALE.remove();
            REQUEST.set(null);
            REQUEST.remove();
            RESPONSE.set(null);
            RESPONSE.remove();
        }
    }

    protected ODataServiceFactory getServiceFactory(HttpServletRequest request) {
        try {
            ODataServiceFactory factoryInstance = this.getODataServiceFactoryInstance(request);
            if (factoryInstance == null) {
                return this.createODataServiceFactory(request);
            }
            return factoryInstance;
        }
        catch (Exception e) {
            throw new ODataRuntimeException(e);
        }
    }

    protected void handle(HttpServletRequest req, HttpServletResponse resp, String xHttpMethod, String xHttpMethodOverride, ODataServiceFactory serviceFactory) throws IOException {
        String method = req.getMethod();
        if (ODataHttpMethod.GET.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.GET, resp, serviceFactory);
        } else if (ODataHttpMethod.POST.name().equals(method)) {
            if (xHttpMethod == null && xHttpMethodOverride == null) {
                this.handleRequest(req, ODataHttpMethod.POST, resp, serviceFactory);
            } else if (xHttpMethod == null) {
                boolean methodHandled = this.handleHttpTunneling(req, resp, xHttpMethodOverride, serviceFactory);
                if (!methodHandled) {
                    this.createMethodNotAllowedResponse(req, ODataHttpException.COMMON, resp, serviceFactory);
                }
            } else {
                boolean methodHandled = this.handleHttpTunneling(req, resp, xHttpMethod, serviceFactory);
                if (!methodHandled) {
                    this.createNotImplementedResponse(req, ODataNotImplementedException.TUNNELING, resp, serviceFactory);
                }
            }
        } else if (ODataHttpMethod.PUT.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.PUT, resp, serviceFactory);
        } else if (ODataHttpMethod.DELETE.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.DELETE, resp, serviceFactory);
        } else if (ODataHttpMethod.PATCH.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.PATCH, resp, serviceFactory);
        } else if (ODataHttpMethod.MERGE.name().equals(method)) {
            this.handleRequest(req, ODataHttpMethod.MERGE, resp, serviceFactory);
        } else if (HTTP_METHOD_HEAD.equals(method)) {
            this.handleRequest(req, ODataHttpMethod.GET, resp, serviceFactory);
        } else if (HTTP_METHOD_OPTIONS.equals(method)) {
            this.createNotImplementedResponse(req, ODataNotImplementedException.COMMON, resp, serviceFactory);
        } else {
            this.createNotImplementedResponse(req, ODataHttpException.COMMON, resp, serviceFactory);
        }
    }

    private boolean handleHttpTunneling(HttpServletRequest req, HttpServletResponse resp, String xHttpMethod, ODataServiceFactory serviceFactory) throws IOException {
        if (ODataHttpMethod.MERGE.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.MERGE, resp, serviceFactory);
        } else if (ODataHttpMethod.PATCH.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.PATCH, resp, serviceFactory);
        } else if (ODataHttpMethod.DELETE.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.DELETE, resp, serviceFactory);
        } else if (ODataHttpMethod.PUT.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.PUT, resp, serviceFactory);
        } else if (ODataHttpMethod.GET.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.GET, resp, serviceFactory);
        } else if (HTTP_METHOD_HEAD.equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.GET, resp, serviceFactory);
        } else if (ODataHttpMethod.POST.name().equals(xHttpMethod)) {
            this.handleRequest(req, ODataHttpMethod.POST, resp, serviceFactory);
        } else if (HTTP_METHOD_OPTIONS.equals(xHttpMethod)) {
            this.createNotImplementedResponse(req, ODataNotImplementedException.COMMON, resp, serviceFactory);
        } else {
            this.createNotImplementedResponse(req, ODataNotImplementedException.COMMON, resp, serviceFactory);
        }
        return true;
    }

    private void handleRequest(HttpServletRequest req, ODataHttpMethod method, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        try {
            ODataRequest odataRequest;
            String pathSplitAsString = this.getInitParameter("org.apache.olingo.odata2.path.split");
            String formEncoding = this.getInitParameter("org.apache.olingo.odata.accept.forms.encoding");
            int pathSplit = 0;
            if (pathSplitAsString != null) {
                pathSplit = Integer.parseInt(pathSplitAsString);
            }
            if (req.getHeader("Accept") != null && req.getHeader("Accept").isEmpty()) {
                this.createNotAcceptableResponse(req, ODataNotAcceptableException.COMMON, resp, serviceFactory);
                return;
            }
            try {
                odataRequest = ODataRequest.method((ODataHttpMethod)method).httpMethod(req.getMethod()).contentType(RestUtil.extractRequestContentType(req.getContentType()).toContentTypeString()).acceptHeaders(RestUtil.extractAcceptHeaders(req.getHeader("Accept"))).acceptableLanguages(RestUtil.extractAcceptableLanguage(req.getHeader("Accept-Language"))).pathInfo(RestUtil.buildODataPathInfo(req, pathSplit)).allQueryParameters(RestUtil.extractAllQueryParameters(req.getQueryString(), formEncoding)).requestHeaders(RestUtil.extractHeaders(req)).body((InputStream)req.getInputStream()).build();
            }
            catch (IllegalArgumentException e) {
                throw new ODataBadRequestException(ODataBadRequestException.INVALID_REQUEST, (Throwable)e);
            }
            ODataContextImpl context = new ODataContextImpl(odataRequest, serviceFactory);
            context.setParameter("~httpRequestObject", req);
            ODataService service = serviceFactory.createService((ODataContext)context);
            if (service == null) {
                this.createServiceUnavailableResponse(req, ODataInternalServerErrorException.NOSERVICE, resp, serviceFactory);
            } else {
                context.setService(service);
                service.getProcessor().setContext((ODataContext)context);
                ODataRequestHandler requestHandler = new ODataRequestHandler(serviceFactory, service, context);
                ODataResponse odataResponse = requestHandler.handle(odataRequest);
                boolean omitResponseBody = HTTP_METHOD_HEAD.equals(req.getMethod());
                this.createResponse(resp, odataResponse, omitResponseBody);
            }
        }
        catch (Exception e) {
            ODataExceptionWrapper wrapper = new ODataExceptionWrapper(req, serviceFactory);
            this.createResponse(resp, wrapper.wrapInExceptionResponse(e));
        }
    }

    protected void handleRedirect(HttpServletRequest req, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        String method = req.getMethod();
        if (ODataHttpMethod.GET.name().equals(method) || ODataHttpMethod.POST.name().equals(method) || ODataHttpMethod.PUT.name().equals(method) || ODataHttpMethod.DELETE.name().equals(method) || ODataHttpMethod.PATCH.name().equals(method) || ODataHttpMethod.MERGE.name().equals(method) || HTTP_METHOD_HEAD.equals(method) || HTTP_METHOD_OPTIONS.equals(method)) {
            ODataResponse odataResponse = ODataResponse.status((HttpStatusCodes)HttpStatusCodes.TEMPORARY_REDIRECT).header("Location", this.createLocation(req)).build();
            this.createResponse(resp, odataResponse);
        } else {
            this.createNotImplementedResponse(req, ODataHttpException.COMMON, resp, serviceFactory);
        }
    }

    private String createLocation(HttpServletRequest req) {
        String servletPath;
        StringBuilder location = new StringBuilder();
        String contextPath = req.getContextPath();
        if (contextPath != null) {
            location.append(contextPath);
        }
        if ((servletPath = req.getServletPath()) != null) {
            location.append(servletPath);
        }
        location.append("/");
        return location.toString();
    }

    protected void createResponse(HttpServletResponse resp, ODataResponse response) throws IOException {
        this.createResponse(resp, response, false);
    }

    protected void createResponse(HttpServletResponse resp, ODataResponse response, boolean omitResponseBody) throws IOException {
        resp.setStatus(response.getStatus().getStatusCode());
        resp.setContentType(response.getContentHeader());
        for (String headerName : response.getHeaderNames()) {
            resp.setHeader(headerName, response.getHeader(headerName));
        }
        if (omitResponseBody) {
            return;
        }
        Object entity = response.getEntity();
        if (entity != null) {
            int contentLength;
            ServletOutputStream out = resp.getOutputStream();
            if (entity instanceof InputStream) {
                contentLength = this.handleStream((InputStream)entity, out);
            } else if (entity instanceof String) {
                String body = (String)entity;
                byte[] entityBytes = body.getBytes(DEFAULT_READ_CHARSET);
                out.write(entityBytes);
                contentLength = entityBytes.length;
            } else {
                throw new IOException("Illegal entity object in ODataResponse of type '" + String.valueOf(entity.getClass()) + "'.");
            }
            if (response.getHeader("Content-Length") != null) {
                try {
                    contentLength = Integer.parseInt(response.getHeader("Content-Length"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            resp.setContentLength(contentLength);
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleStream(InputStream stream, ServletOutputStream out) throws IOException {
        int contentLength = 0;
        byte[] buffer = this.getBuffer();
        try {
            int len;
            while ((len = stream.read(buffer)) != -1) {
                contentLength += len;
                out.write(buffer, 0, len);
            }
        }
        finally {
            stream.close();
        }
        return contentLength;
    }

    private byte[] getBuffer() {
        int bufferSize = 32768;
        String bufSizeInit = this.getInitParameter(BUFFER_SIZE);
        if (bufSizeInit != null) {
            try {
                bufferSize = Integer.parseInt(bufSizeInit);
                if (bufferSize <= 0) {
                    bufferSize = 32768;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new byte[bufferSize];
    }

    private void createNotImplementedResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse((Exception)new ODataNotImplementedException(messageReference));
        this.createResponse(resp, response);
    }

    private void createMethodNotAllowedResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse((Exception)new ODataMethodNotAllowedException(messageReference));
        this.createResponse(resp, response);
    }

    private void createNotAcceptableResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse((Exception)((Object)new ODataNotAcceptableException(messageReference)));
        this.createResponse(resp, response);
    }

    private void createServiceUnavailableResponse(HttpServletRequest req, MessageReference messageReference, HttpServletResponse resp, ODataServiceFactory serviceFactory) throws IOException {
        ODataExceptionWrapper exceptionWrapper = new ODataExceptionWrapper(req, serviceFactory);
        ODataResponse response = exceptionWrapper.wrapInExceptionResponse((Exception)new ODataInternalServerErrorException(messageReference));
        this.createResponse(resp, response);
    }

    private ODataServiceFactory createODataServiceFactory(HttpServletRequest req) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String factoryClassName = this.getInitParameter("org.apache.olingo.odata2.service.factory");
        if (factoryClassName == null) {
            return null;
        }
        ClassLoader cl = (ClassLoader)req.getAttribute("org.apache.olingo.odata2.service.factory.classloader");
        if (cl == null) {
            return (ODataServiceFactory)Class.forName(factoryClassName).newInstance();
        }
        return (ODataServiceFactory)Class.forName(factoryClassName, true, cl).newInstance();
    }

    private ODataServiceFactory getODataServiceFactoryInstance(HttpServletRequest req) {
        Object factory = req.getAttribute("org.apache.olingo.odata2.service.factory.instance");
        if (factory == null) {
            return null;
        }
        if (factory instanceof ODataServiceFactory) {
            return (ODataServiceFactory)factory;
        }
        throw new ODataRuntimeException("Invalid service factory instance of type " + String.valueOf(factory.getClass()));
    }
}

