/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.Calendar;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeFacade;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmArray;
import org.apache.olingo.odata2.core.edm.EdmAuto;
import org.apache.olingo.odata2.core.edm.EdmBinary;
import org.apache.olingo.odata2.core.edm.EdmBoolean;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.edm.EdmDecimal;
import org.apache.olingo.odata2.core.edm.EdmDouble;
import org.apache.olingo.odata2.core.edm.EdmGuid;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmInt32;
import org.apache.olingo.odata2.core.edm.EdmInt64;
import org.apache.olingo.odata2.core.edm.EdmNull;
import org.apache.olingo.odata2.core.edm.EdmObject;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.EdmSingle;
import org.apache.olingo.odata2.core.edm.EdmString;
import org.apache.olingo.odata2.core.edm.EdmTime;
import org.apache.olingo.odata2.core.edm.Uint7;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;

public class EdmSimpleTypeFacadeImpl
implements EdmSimpleTypeFacade {
    public EdmLiteral parseUriLiteral(String uriLiteral) throws EdmLiteralException {
        if (uriLiteral == null || "null".equals(uriLiteral)) {
            return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Null), uriLiteral);
        }
        if ("true".equals(uriLiteral) || "false".equals(uriLiteral)) {
            return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Boolean), uriLiteral);
        }
        if (uriLiteral.length() >= 2 && uriLiteral.startsWith("'") && uriLiteral.endsWith("'")) {
            try {
                EdmSimpleType type = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.String);
                return new EdmLiteral(type, (String)type.valueOfString(uriLiteral, EdmLiteralKind.URI, null, String.class));
            }
            catch (EdmSimpleTypeException e) {
                throw new EdmLiteralException(EdmLiteralException.LITERALFORMAT.addContent(new Object[]{uriLiteral}), (Throwable)e);
            }
        }
        if (uriLiteral.matches("-?\\p{Digit}+")) {
            try {
                int i = (Integer)EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Int32).valueOfString(uriLiteral, EdmLiteralKind.URI, null, Integer.class);
                if (i == 0 || i == 1) {
                    return new EdmLiteral(EdmSimpleTypeFacadeImpl.getInternalEdmSimpleTypeByString("Bit"), uriLiteral);
                }
                if (i >= 0 && i <= 127) {
                    return new EdmLiteral(EdmSimpleTypeFacadeImpl.getInternalEdmSimpleTypeByString("Uint7"), uriLiteral);
                }
                if (i >= -128 && i < 0) {
                    return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.SByte), uriLiteral);
                }
                if (i > 127 && i <= 255) {
                    return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Byte), uriLiteral);
                }
                if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
                    return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Int16), uriLiteral);
                }
                return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Int32), uriLiteral);
            }
            catch (EdmSimpleTypeException e) {
                throw new EdmLiteralException(EdmLiteralException.LITERALFORMAT.addContent(new Object[]{uriLiteral}), (Throwable)e);
            }
        }
        if (uriLiteral.endsWith("L") || uriLiteral.endsWith("l")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.Int64, uriLiteral, 0, 1);
        }
        if (uriLiteral.endsWith("M") || uriLiteral.endsWith("m")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.Decimal, uriLiteral, 0, 1);
        }
        if (uriLiteral.endsWith("D") || uriLiteral.endsWith("d")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.Double, uriLiteral, 0, 1);
        }
        if ("-INF".equals(uriLiteral) || "INF".equals(uriLiteral) || "NaN".equals(uriLiteral)) {
            return new EdmLiteral(EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Single), uriLiteral);
        }
        if (uriLiteral.endsWith("F") || uriLiteral.endsWith("f")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.Single, uriLiteral, 0, 1);
        }
        if (uriLiteral.startsWith("datetime'")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.DateTime, uriLiteral, 9, 1);
        }
        if (uriLiteral.startsWith("datetimeoffset'")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.DateTimeOffset, uriLiteral, 15, 1);
        }
        if (uriLiteral.startsWith("guid'")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.Guid, uriLiteral, 5, 1);
        }
        if (uriLiteral.startsWith("time'")) {
            return EdmSimpleTypeFacadeImpl.createEdmLiteral(EdmSimpleTypeKind.Time, uriLiteral, 5, 1);
        }
        if (uriLiteral.startsWith("X'") || uriLiteral.startsWith("binary'")) {
            try {
                EdmSimpleType type = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Binary);
                byte[] value = (byte[])type.valueOfString(uriLiteral, EdmLiteralKind.URI, null, byte[].class);
                return new EdmLiteral(type, type.valueToString((Object)value, EdmLiteralKind.DEFAULT, null));
            }
            catch (EdmSimpleTypeException e) {
                throw new EdmLiteralException(EdmLiteralException.LITERALFORMAT.addContent(new Object[]{uriLiteral}), (Throwable)e);
            }
        }
        throw new EdmLiteralException(EdmLiteralException.UNKNOWNLITERAL.addContent(new Object[]{uriLiteral}));
    }

    private static EdmLiteral createEdmLiteral(EdmSimpleTypeKind typeKind, String literal, int prefixLength, int suffixLength) throws EdmLiteralException {
        EdmSimpleType type = EdmSimpleTypeFacadeImpl.getEdmSimpleType(typeKind);
        if (type.validate(literal, EdmLiteralKind.URI, null)) {
            return new EdmLiteral(type, literal.substring(prefixLength, literal.length() - suffixLength));
        }
        throw new EdmLiteralException(EdmLiteralException.LITERALFORMAT.addContent(new Object[]{literal}));
    }

    public EdmSimpleType getEdmSimpleTypeInstance(EdmSimpleTypeKind typeKind) {
        return EdmSimpleTypeFacadeImpl.getEdmSimpleType(typeKind);
    }

    public static Class getEdmClassType(EdmSimpleTypeKind typeKind) {
        switch (typeKind) {
            case Array: {
                return String.class;
            }
            case Binary: {
                return Object.class;
            }
            case Boolean: {
                return Boolean.class;
            }
            case Byte: {
                return Integer.class;
            }
            case DateTime: {
                return Calendar.class;
            }
            case DateTimeOffset: {
                return Calendar.class;
            }
            case Decimal: {
                return Double.class;
            }
            case Double: {
                return Double.class;
            }
            case Guid: {
                return String.class;
            }
            case Int16: {
                return Long.class;
            }
            case Int32: {
                return Long.class;
            }
            case Int64: {
                return Long.class;
            }
            case Object: {
                return String.class;
            }
            case SByte: {
                return Integer.class;
            }
            case Single: {
                return Integer.class;
            }
            case Auto: {
                return Object.class;
            }
            case String: {
                return String.class;
            }
            case Time: {
                return Calendar.class;
            }
            case Null: {
                return Object.class;
            }
        }
        throw new ODataRuntimeException("Invalid Type " + typeKind);
    }

    public static EdmSimpleType getEdmSimpleType(EdmSimpleTypeKind typeKind) {
        switch (typeKind) {
            case Array: {
                return EdmArray.getInstance();
            }
            case Binary: {
                return EdmBinary.getInstance();
            }
            case Boolean: {
                return EdmBoolean.getInstance();
            }
            case Byte: {
                return EdmByte.getInstance();
            }
            case DateTime: {
                return EdmDateTime.getInstance();
            }
            case DateTimeOffset: {
                return EdmDateTimeOffset.getInstance();
            }
            case Decimal: {
                return EdmDecimal.getInstance();
            }
            case Double: {
                return EdmDouble.getInstance();
            }
            case Guid: {
                return EdmGuid.getInstance();
            }
            case Int16: {
                return EdmInt16.getInstance();
            }
            case Int32: {
                return EdmInt32.getInstance();
            }
            case Int64: {
                return EdmInt64.getInstance();
            }
            case Object: {
                return EdmObject.getInstance();
            }
            case SByte: {
                return EdmSByte.getInstance();
            }
            case Single: {
                return EdmSingle.getInstance();
            }
            case Auto: {
                return EdmAuto.getInstance();
            }
            case String: {
                return EdmString.getInstance();
            }
            case Time: {
                return EdmTime.getInstance();
            }
            case Null: {
                return EdmNull.getInstance();
            }
        }
        throw new ODataRuntimeException("Invalid Type " + typeKind);
    }

    public static EdmSimpleType getInternalEdmSimpleTypeByString(String edmSimpleType) {
        if ("Bit".equals(edmSimpleType)) {
            return Bit.getInstance();
        }
        if ("Uint7".equals(edmSimpleType)) {
            return Uint7.getInstance();
        }
        throw new ODataRuntimeException("Invalid internal Type " + edmSimpleType);
    }
}

