/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmAction;
import org.apache.olingo.odata2.api.edm.EdmConcurrencyMode;
import org.apache.olingo.odata2.api.edm.EdmContentKind;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AnnotationAttribute;
import org.apache.olingo.odata2.api.edm.provider.AnnotationElement;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.AssociationSetEnd;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.CustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.FunctionImportParameter;
import org.apache.olingo.odata2.api.edm.provider.Key;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.OnDelete;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.ReferentialConstraint;
import org.apache.olingo.odata2.api.edm.provider.ReferentialConstraintRole;
import org.apache.olingo.odata2.api.edm.provider.ReturnType;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.api.edm.provider.Using;
import org.apache.olingo.odata2.api.ep.EntityProviderException;

public class XmlMetadataConsumer {
    private Map<String, Set<String>> inscopeMap = new HashMap<String, Set<String>>();
    private Map<String, String> aliasNamespaceMap = new HashMap<String, String>();
    private Map<String, String> xmlNamespaceMap;
    private Map<String, String> mandatoryNamespaces;
    private Map<FullQualifiedName, EntityType> entityTypesMap = new HashMap<FullQualifiedName, EntityType>();
    private Map<FullQualifiedName, ComplexType> complexTypesMap = new HashMap<FullQualifiedName, ComplexType>();
    private Map<FullQualifiedName, Association> associationsMap = new HashMap<FullQualifiedName, Association>();
    private Map<FullQualifiedName, EntityContainer> containerMap = new HashMap<FullQualifiedName, EntityContainer>();
    private List<NavigationProperty> navProperties = new ArrayList<NavigationProperty>();
    private String currentHandledStartTagName;
    private String currentNamespace;
    private String edmNamespace = "http://schemas.microsoft.com/ado/2008/09/edm";
    private Set<String> edmNamespaces;

    public DataServices readMetadata(XMLStreamReader reader, boolean validate) throws EntityProviderException {
        try {
            this.initialize();
            DataServices dataServices = new DataServices();
            ArrayList<Schema> schemas = new ArrayList<Schema>();
            while (!(!reader.hasNext() || reader.isEndElement() && "http://schemas.microsoft.com/ado/2007/06/edmx".equals(reader.getNamespaceURI()) && "Edmx".equals(reader.getLocalName()))) {
                reader.next();
                if (!reader.isStartElement()) continue;
                this.extractNamespaces(reader);
                if ("Schema".equals(reader.getLocalName())) {
                    this.edmNamespace = reader.getNamespaceURI();
                    this.checkEdmNamespace();
                    schemas.add(this.readSchema(reader));
                    continue;
                }
                if (!"DataServices".equals(reader.getLocalName())) continue;
                dataServices.setDataServiceVersion(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "DataServiceVersion"));
            }
            if (!reader.isEndElement() || !"Edmx".equals(reader.getLocalName())) {
                throw new EntityProviderException(EntityProviderException.MISSING_TAG.addContent(new Object[]{"Edmx"}));
            }
            if (validate) {
                this.validate();
            }
            dataServices.setSchemas(schemas);
            reader.close();
            return dataServices;
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private Schema readSchema(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "Schema");
        Schema schema = new Schema();
        ArrayList<Using> usings = new ArrayList<Using>();
        ArrayList<ComplexType> complexTypes = new ArrayList<ComplexType>();
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        ArrayList<Association> associations = new ArrayList<Association>();
        ArrayList<EntityContainer> entityContainers = new ArrayList<EntityContainer>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        schema.setNamespace(reader.getAttributeValue(null, "Namespace"));
        this.inscopeMap.put(schema.getNamespace(), new HashSet());
        schema.setAlias(reader.getAttributeValue(null, "Alias"));
        schema.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        this.currentNamespace = schema.getNamespace();
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Schema".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Using".equals(this.currentHandledStartTagName)) {
                usings.add(this.readUsing(reader, schema.getNamespace()));
                continue;
            }
            if ("EntityType".equals(this.currentHandledStartTagName)) {
                entityTypes.add(this.readEntityType(reader));
                continue;
            }
            if ("ComplexType".equals(this.currentHandledStartTagName)) {
                complexTypes.add(this.readComplexType(reader));
                continue;
            }
            if ("Association".equals(this.currentHandledStartTagName)) {
                associations.add(this.readAssociation(reader));
                continue;
            }
            if ("EntityContainer".equals(this.currentHandledStartTagName)) {
                entityContainers.add(this.readEntityContainer(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (schema.getAlias() != null) {
            this.aliasNamespaceMap.put(schema.getAlias(), schema.getNamespace());
        }
        if (!annotationElements.isEmpty()) {
            schema.setAnnotationElements(annotationElements);
        }
        schema.setUsings(usings).setEntityTypes(entityTypes).setComplexTypes(complexTypes).setAssociations(associations).setEntityContainers(entityContainers);
        return schema;
    }

    private Using readUsing(XMLStreamReader reader, String schemaNamespace) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "Using");
        Using using = new Using();
        using.setNamespace(reader.getAttributeValue(null, "Namespace"));
        this.inscopeMap.get(schemaNamespace).add(using.getNamespace());
        using.setAlias(reader.getAttributeValue(null, "Alias"));
        using.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Using".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            using.setAnnotationElements(annotationElements);
        }
        if (using.getAlias() != null) {
            this.aliasNamespaceMap.put(using.getAlias(), using.getNamespace());
        }
        return using;
    }

    private EntityContainer readEntityContainer(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "EntityContainer");
        EntityContainer container = new EntityContainer();
        ArrayList<EntitySet> entitySets = new ArrayList<EntitySet>();
        ArrayList<AssociationSet> associationSets = new ArrayList<AssociationSet>();
        ArrayList<FunctionImport> functionImports = new ArrayList<FunctionImport>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        container.setName(reader.getAttributeValue(null, "Name"));
        if (reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer") != null) {
            container.setDefaultEntityContainer("true".equalsIgnoreCase(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "IsDefaultEntityContainer")));
        }
        container.setExtendz(reader.getAttributeValue(null, "Extendz"));
        container.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "EntityContainer".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("EntitySet".equals(this.currentHandledStartTagName)) {
                entitySets.add(this.readEntitySet(reader));
                continue;
            }
            if ("AssociationSet".equals(this.currentHandledStartTagName)) {
                associationSets.add(this.readAssociationSet(reader));
                continue;
            }
            if ("FunctionImport".equals(this.currentHandledStartTagName)) {
                functionImports.add(this.readFunctionImport(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            container.setAnnotationElements(annotationElements);
        }
        container.setEntitySets(entitySets).setAssociationSets(associationSets).setFunctionImports(functionImports);
        this.containerMap.put(new FullQualifiedName(this.currentNamespace, container.getName()), container);
        return container;
    }

    private FunctionImport readFunctionImport(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "FunctionImport");
        FunctionImport function = new FunctionImport();
        ArrayList<FunctionImportParameter> functionParameters = new ArrayList<FunctionImportParameter>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        function.setName(reader.getAttributeValue(null, "Name"));
        function.setHttpMethod(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HttpMethod"));
        function.setEntitySet(reader.getAttributeValue(null, "EntitySet"));
        String returnTypeString = reader.getAttributeValue(null, "ReturnType");
        if (returnTypeString != null) {
            FullQualifiedName fqName;
            ReturnType returnType = new ReturnType();
            if (returnTypeString.startsWith("Collection") || returnTypeString.startsWith("collection")) {
                returnTypeString = returnTypeString.substring(returnTypeString.indexOf("(") + 1, returnTypeString.length() - 1);
                fqName = this.extractFQName(returnTypeString);
                if (function.getEntitySet() == null && this.entityTypesMap.get(fqName) != null) {
                    throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"EntitySet = " + function.getEntitySet(), "FunctionImport" + function.getName()}));
                }
                returnType.setMultiplicity(EdmMultiplicity.MANY);
            } else {
                fqName = this.extractFQName(returnTypeString);
                if (function.getEntitySet() != null && this.entityTypesMap.get(fqName) == null) {
                    throw new EntityProviderException(EntityProviderException.INVALID_ATTRIBUTE.addContent(new Object[]{"EntitySet = " + function.getEntitySet(), "FunctionImport : " + function.getName()}));
                }
                returnType.setMultiplicity(EdmMultiplicity.ONE);
            }
            fqName = this.extractFQName(returnTypeString);
            returnType.setTypeName(fqName);
            function.setReturnType(returnType);
        }
        function.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "FunctionImport".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Parameter".equals(this.currentHandledStartTagName)) {
                functionParameters.add(this.readFunctionImportParameter(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            function.setAnnotationElements(annotationElements);
        }
        function.setParameters(functionParameters);
        return function;
    }

    private FunctionImportParameter readFunctionImportParameter(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        reader.require(1, this.edmNamespace, "Parameter");
        FunctionImportParameter functionParameter = new FunctionImportParameter();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        functionParameter.setName(reader.getAttributeValue(null, "Name"));
        functionParameter.setMode(reader.getAttributeValue(null, "Mode"));
        String type = reader.getAttributeValue(null, "Type");
        if (type == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Type"}).addContent(new Object[]{"Parameter"}));
        }
        functionParameter.setType(EdmSimpleTypeKind.valueOf((String)this.extractFQName(type).getName()));
        functionParameter.setFacets((EdmFacets)this.readFacets(reader));
        functionParameter.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Parameter".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            functionParameter.setAnnotationElements(annotationElements);
        }
        return functionParameter;
    }

    private AssociationSet readAssociationSet(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "AssociationSet");
        AssociationSet associationSet = new AssociationSet();
        ArrayList<AssociationSetEnd> ends = new ArrayList<AssociationSetEnd>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        associationSet.setName(reader.getAttributeValue(null, "Name"));
        String association = reader.getAttributeValue(null, "Association");
        if (association == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Association"}).addContent(new Object[]{"AssociationSet"}));
        }
        associationSet.setAssociation(this.extractFQName(association));
        associationSet.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "AssociationSet".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("End".equals(this.currentHandledStartTagName)) {
                AssociationSetEnd associationSetEnd = new AssociationSetEnd();
                associationSetEnd.setEntitySet(reader.getAttributeValue(null, "EntitySet"));
                associationSetEnd.setRole(reader.getAttributeValue(null, "Role"));
                ends.add(associationSetEnd);
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (ends.size() != 2) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Count of AssociationSet ends should be 2"}));
        }
        associationSet.setEnd1((AssociationSetEnd)ends.get(0)).setEnd2((AssociationSetEnd)ends.get(1));
        if (!annotationElements.isEmpty()) {
            associationSet.setAnnotationElements(annotationElements);
        }
        return associationSet;
    }

    private EntitySet readEntitySet(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "EntitySet");
        EntitySet entitySet = new EntitySet();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        entitySet.setName(reader.getAttributeValue(null, "Name"));
        String entityType = reader.getAttributeValue(null, "EntityType");
        if (entityType == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"EntityType"}).addContent(new Object[]{"EntitySet"}));
        }
        FullQualifiedName fqName = this.extractFQName(entityType);
        entitySet.setEntityType(fqName);
        entitySet.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "EntitySet".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            entitySet.setAnnotationElements(annotationElements);
        }
        return entitySet;
    }

    private Association readAssociation(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "Association");
        Association association = new Association();
        association.setName(reader.getAttributeValue(null, "Name"));
        ArrayList<AssociationEnd> associationEnds = new ArrayList<AssociationEnd>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        association.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Association".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("End".equals(this.currentHandledStartTagName)) {
                associationEnds.add(this.readAssociationEnd(reader));
                continue;
            }
            if ("ReferentialConstraint".equals(this.currentHandledStartTagName)) {
                association.setReferentialConstraint(this.readReferentialConstraint(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (associationEnds.size() < 2 && associationEnds.size() > 2) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Count of association ends should be 2"}));
        }
        if (!annotationElements.isEmpty()) {
            association.setAnnotationElements(annotationElements);
        }
        association.setEnd1((AssociationEnd)associationEnds.get(0)).setEnd2((AssociationEnd)associationEnds.get(1));
        this.associationsMap.put(new FullQualifiedName(this.currentNamespace, association.getName()), association);
        return association;
    }

    private ReferentialConstraint readReferentialConstraint(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "ReferentialConstraint");
        ReferentialConstraint refConstraint = new ReferentialConstraint();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        refConstraint.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "ReferentialConstraint".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Principal".equals(this.currentHandledStartTagName)) {
                reader.require(1, this.edmNamespace, "Principal");
                refConstraint.setPrincipal(this.readReferentialConstraintRole(reader));
                continue;
            }
            if ("Dependent".equals(this.currentHandledStartTagName)) {
                reader.require(1, this.edmNamespace, "Dependent");
                refConstraint.setDependent(this.readReferentialConstraintRole(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            refConstraint.setAnnotationElements(annotationElements);
        }
        return refConstraint;
    }

    private ReferentialConstraintRole readReferentialConstraintRole(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        ReferentialConstraintRole rcRole = new ReferentialConstraintRole();
        rcRole.setRole(reader.getAttributeValue(null, "Role"));
        ArrayList<PropertyRef> propertyRefs = new ArrayList<PropertyRef>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        rcRole.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && ("Principal".equals(reader.getLocalName()) || "Dependent".equals(reader.getLocalName())))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("PropertyRef".equals(this.currentHandledStartTagName)) {
                propertyRefs.add(this.readPropertyRef(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            rcRole.setAnnotationElements(annotationElements);
        }
        rcRole.setPropertyRefs(propertyRefs);
        return rcRole;
    }

    private ComplexType readComplexType(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "ComplexType");
        ComplexType complexType = new ComplexType();
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        complexType.setName(reader.getAttributeValue(null, "Name"));
        String baseType = reader.getAttributeValue(null, "BaseType");
        if (baseType != null) {
            complexType.setBaseType(this.extractFQName(baseType));
        }
        if (reader.getAttributeValue(null, "Abstract") != null) {
            complexType.setAbstract("true".equalsIgnoreCase(reader.getAttributeValue(null, "Abstract")));
        }
        complexType.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "ComplexType".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Property".equals(this.currentHandledStartTagName)) {
                properties.add(this.readProperty(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            complexType.setAnnotationElements(annotationElements);
        }
        complexType.setProperties(properties);
        if (complexType.getName() == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Name"}));
        }
        FullQualifiedName fqName = new FullQualifiedName(this.currentNamespace, complexType.getName());
        this.complexTypesMap.put(fqName, complexType);
        return complexType;
    }

    private EntityType readEntityType(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        String baseType;
        reader.require(1, this.edmNamespace, "EntityType");
        EntityType entityType = new EntityType();
        ArrayList<Property> properties = new ArrayList<Property>();
        ArrayList<NavigationProperty> navPropertiesList = new ArrayList<NavigationProperty>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        Key key = null;
        entityType.setName(reader.getAttributeValue(null, "Name"));
        String hasStream = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "HasStream");
        if (hasStream != null) {
            entityType.setHasStream("true".equalsIgnoreCase(hasStream));
        }
        if (reader.getAttributeValue(null, "Abstract") != null) {
            entityType.setAbstract("true".equalsIgnoreCase(reader.getAttributeValue(null, "Abstract")));
        }
        if ((baseType = reader.getAttributeValue(null, "BaseType")) != null) {
            entityType.setBaseType(this.extractFQName(baseType));
        }
        entityType.setCustomizableFeedMappings(this.readCustomizableFeedMappings(reader));
        entityType.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "EntityType".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.currentHandledStartTagName = reader.getLocalName();
            if ("Key".equals(this.currentHandledStartTagName)) {
                key = this.readEntityTypeKey(reader);
            } else if ("Property".equals(this.currentHandledStartTagName)) {
                properties.add(this.readProperty(reader));
            } else if ("NavigationProperty".equals(this.currentHandledStartTagName)) {
                navPropertiesList.add(this.readNavigationProperty(reader));
            } else {
                annotationElements.add(this.readAnnotationElement(reader));
            }
            this.extractNamespaces(reader);
        }
        if (!annotationElements.isEmpty()) {
            entityType.setAnnotationElements(annotationElements);
        }
        entityType.setKey(key).setProperties(properties).setNavigationProperties(navPropertiesList);
        if (entityType.getName() == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Name"}));
        }
        FullQualifiedName fqName = new FullQualifiedName(this.currentNamespace, entityType.getName());
        this.entityTypesMap.put(fqName, entityType);
        return entityType;
    }

    private Key readEntityTypeKey(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "Key");
        ArrayList<PropertyRef> keys = new ArrayList<PropertyRef>();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        List<AnnotationAttribute> annotationAttributes = this.readAnnotationAttribute(reader);
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Key".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("PropertyRef".equals(this.currentHandledStartTagName)) {
                reader.require(1, this.edmNamespace, "PropertyRef");
                keys.add(this.readPropertyRef(reader));
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        Key key = new Key().setKeys(keys).setAnnotationAttributes(annotationAttributes);
        if (!annotationElements.isEmpty()) {
            key.setAnnotationElements(annotationElements);
        }
        return key;
    }

    private PropertyRef readPropertyRef(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "PropertyRef");
        PropertyRef propertyRef = new PropertyRef();
        propertyRef.setName(reader.getAttributeValue(null, "Name"));
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        propertyRef.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "PropertyRef".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            propertyRef.setAnnotationElements(annotationElements);
        }
        return propertyRef;
    }

    private NavigationProperty readNavigationProperty(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "NavigationProperty");
        NavigationProperty navProperty = new NavigationProperty();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        navProperty.setName(reader.getAttributeValue(null, "Name"));
        String relationship = reader.getAttributeValue(null, "Relationship");
        if (relationship == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Relationship"}).addContent(new Object[]{"NavigationProperty"}));
        }
        FullQualifiedName fqName = this.extractFQName(relationship);
        navProperty.setRelationship(fqName);
        navProperty.setFromRole(reader.getAttributeValue(null, "FromRole"));
        navProperty.setToRole(reader.getAttributeValue(null, "ToRole"));
        navProperty.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "NavigationProperty".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            navProperty.setAnnotationElements(annotationElements);
        }
        this.navProperties.add(navProperty);
        return navProperty;
    }

    private Property readProperty(XMLStreamReader reader) throws XMLStreamException, EntityProviderException {
        reader.require(1, this.edmNamespace, "Property");
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        String type = reader.getAttributeValue(null, "Type");
        if (type == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Type"}).addContent(new Object[]{"Property"}));
        }
        FullQualifiedName fqName = this.extractFQName(type);
        Property property = "Edm".equals(fqName.getNamespace()) ? this.readSimpleProperty(reader, fqName) : this.readComplexProperty(reader, fqName);
        property.setFacets((EdmFacets)this.readFacets(reader));
        property.setCustomizableFeedMappings(this.readCustomizableFeedMappings(reader));
        property.setMimeType(reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "MimeType"));
        property.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "Property".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            property.setAnnotationElements(annotationElements);
        }
        return property;
    }

    private Property readComplexProperty(XMLStreamReader reader, FullQualifiedName fqName) throws XMLStreamException {
        ComplexProperty property = new ComplexProperty();
        property.setName(reader.getAttributeValue(null, "Name"));
        property.setType(fqName);
        return property;
    }

    private Property readSimpleProperty(XMLStreamReader reader, FullQualifiedName fqName) throws XMLStreamException {
        SimpleProperty property = new SimpleProperty();
        property.setName(reader.getAttributeValue(null, "Name"));
        property.setType(EdmSimpleTypeKind.valueOf((String)fqName.getName()));
        return property;
    }

    private Facets readFacets(XMLStreamReader reader) throws XMLStreamException {
        String isNullable = reader.getAttributeValue(null, "Nullable");
        String maxLength = reader.getAttributeValue(null, "MaxLength");
        String precision = reader.getAttributeValue(null, "Precision");
        String scale = reader.getAttributeValue(null, "Scale");
        String isFixedLength = reader.getAttributeValue(null, "FixedLength");
        String isUnicode = reader.getAttributeValue(null, "Unicode");
        String concurrencyMode = reader.getAttributeValue(null, "ConcurrencyMode");
        String defaultValue = reader.getAttributeValue(null, "DefaultValue");
        String collation = reader.getAttributeValue(null, "Collation");
        if (isNullable != null || maxLength != null || precision != null || scale != null || isFixedLength != null || isUnicode != null || concurrencyMode != null || defaultValue != null || collation != null) {
            Facets facets = new Facets();
            if (isNullable != null) {
                facets.setNullable(Boolean.valueOf("true".equalsIgnoreCase(isNullable)));
            }
            if (maxLength != null) {
                if ("Max".equals(maxLength) || "max".equals(maxLength)) {
                    facets.setMaxLength(Integer.valueOf(Integer.MAX_VALUE));
                } else {
                    facets.setMaxLength(Integer.valueOf(Integer.parseInt(maxLength)));
                }
            }
            if (precision != null) {
                facets.setPrecision(Integer.valueOf(Integer.parseInt(precision)));
            }
            if (scale != null) {
                facets.setScale(Integer.valueOf(Integer.parseInt(scale)));
            }
            if (isFixedLength != null) {
                facets.setFixedLength(Boolean.valueOf("true".equalsIgnoreCase(isFixedLength)));
            }
            if (isUnicode != null) {
                facets.setUnicode(Boolean.valueOf("true".equalsIgnoreCase(isUnicode)));
            }
            for (int i = 0; i < EdmConcurrencyMode.values().length; ++i) {
                if (!EdmConcurrencyMode.values()[i].name().equalsIgnoreCase(concurrencyMode)) continue;
                facets.setConcurrencyMode(EdmConcurrencyMode.values()[i]);
            }
            facets.setDefaultValue(defaultValue);
            facets.setCollation(collation);
            return facets;
        }
        return null;
    }

    private CustomizableFeedMappings readCustomizableFeedMappings(XMLStreamReader reader) {
        String targetPath = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_TargetPath");
        String sourcePath = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_SourcePath");
        String nsUri = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsUri");
        String nsPrefix = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_NsPrefix");
        String keepInContent = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_KeepInContent");
        String contentKind = reader.getAttributeValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "FC_ContentKind");
        if (targetPath != null || sourcePath != null || nsUri != null || nsPrefix != null || keepInContent != null || contentKind != null) {
            CustomizableFeedMappings feedMapping = new CustomizableFeedMappings();
            if (keepInContent != null) {
                feedMapping.setFcKeepInContent(Boolean.valueOf("true".equals(keepInContent)));
            }
            for (int i = 0; i < EdmContentKind.values().length; ++i) {
                if (!EdmContentKind.values()[i].name().equalsIgnoreCase(contentKind)) continue;
                feedMapping.setFcContentKind(EdmContentKind.values()[i]);
            }
            feedMapping.setFcTargetPath(targetPath).setFcSourcePath(sourcePath).setFcNsUri(nsUri).setFcNsPrefix(nsPrefix);
            return feedMapping;
        }
        return null;
    }

    private AssociationEnd readAssociationEnd(XMLStreamReader reader) throws EntityProviderException, XMLStreamException {
        reader.require(1, this.edmNamespace, "End");
        AssociationEnd associationEnd = new AssociationEnd();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        associationEnd.setRole(reader.getAttributeValue(null, "Role"));
        associationEnd.setMultiplicity(EdmMultiplicity.fromLiteral((String)reader.getAttributeValue(null, "Multiplicity")));
        String type = reader.getAttributeValue(null, "Type");
        if (type == null) {
            throw new EntityProviderException(EntityProviderException.MISSING_ATTRIBUTE.addContent(new Object[]{"Type"}).addContent(new Object[]{"End"}));
        }
        associationEnd.setType(this.extractFQName(type));
        associationEnd.setAnnotationAttributes(this.readAnnotationAttribute(reader));
        while (!(!reader.hasNext() || reader.isEndElement() && this.edmNamespace.equals(reader.getNamespaceURI()) && "End".equals(reader.getLocalName()))) {
            reader.next();
            if (!reader.isStartElement()) continue;
            this.extractNamespaces(reader);
            this.currentHandledStartTagName = reader.getLocalName();
            if ("OnDelete".equals(this.currentHandledStartTagName)) {
                OnDelete onDelete = new OnDelete();
                for (int i = 0; i < EdmAction.values().length; ++i) {
                    if (!EdmAction.values()[i].name().equalsIgnoreCase(reader.getAttributeValue(null, "Action"))) continue;
                    onDelete.setAction(EdmAction.values()[i]);
                }
                associationEnd.setOnDelete(onDelete);
                continue;
            }
            annotationElements.add(this.readAnnotationElement(reader));
        }
        if (!annotationElements.isEmpty()) {
            associationEnd.setAnnotationElements(annotationElements);
        }
        return associationEnd;
    }

    private AnnotationElement readAnnotationElement(XMLStreamReader reader) throws XMLStreamException {
        AnnotationElement aElement = new AnnotationElement();
        ArrayList<AnnotationElement> annotationElements = new ArrayList<AnnotationElement>();
        ArrayList<AnnotationAttribute> annotationAttributes = new ArrayList<AnnotationAttribute>();
        aElement.setName(reader.getLocalName());
        String elementNamespace = reader.getNamespaceURI();
        if (!this.edmNamespaces.contains(elementNamespace)) {
            aElement.setPrefix(reader.getPrefix());
            aElement.setNamespace(elementNamespace);
        }
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            AnnotationAttribute annotationAttribute = new AnnotationAttribute();
            annotationAttribute.setText(reader.getAttributeValue(i));
            annotationAttribute.setName(reader.getAttributeLocalName(i));
            annotationAttribute.setPrefix(reader.getAttributePrefix(i));
            String namespace = reader.getAttributeNamespace(i);
            if (namespace != null && !this.isDefaultNamespace(namespace)) {
                annotationAttribute.setNamespace(namespace);
            }
            annotationAttributes.add(annotationAttribute);
        }
        if (!annotationAttributes.isEmpty()) {
            aElement.setAttributes(annotationAttributes);
        }
        boolean justRead = false;
        if (reader.hasNext()) {
            reader.next();
            justRead = true;
        }
        while (!(!justRead || reader.isEndElement() && aElement.getName() != null && aElement.getName().equals(reader.getLocalName()))) {
            justRead = false;
            if (reader.isStartElement()) {
                annotationElements.add(this.readAnnotationElement(reader));
                if (!reader.hasNext()) continue;
                reader.next();
                justRead = true;
                continue;
            }
            if (!reader.isCharacters()) continue;
            String elementText = "";
            do {
                justRead = false;
                elementText = elementText + reader.getText();
                if (!reader.hasNext()) continue;
                reader.next();
                justRead = true;
            } while (justRead && reader.isCharacters());
            aElement.setText(elementText);
        }
        if (!annotationElements.isEmpty()) {
            aElement.setChildElements(annotationElements);
        }
        return aElement;
    }

    private List<AnnotationAttribute> readAnnotationAttribute(XMLStreamReader reader) {
        ArrayList<AnnotationAttribute> annotationAttributes = new ArrayList<AnnotationAttribute>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace == null || this.isDefaultNamespace(attributeNamespace) || this.mandatoryNamespaces.containsValue(attributeNamespace) || this.edmNamespaces.contains(attributeNamespace)) continue;
            annotationAttributes.add(new AnnotationAttribute().setName(reader.getAttributeLocalName(i)).setPrefix(reader.getAttributePrefix(i)).setNamespace(attributeNamespace).setText(reader.getAttributeValue(i)));
        }
        if (annotationAttributes.isEmpty()) {
            return null;
        }
        return annotationAttributes;
    }

    private boolean isDefaultNamespace(String namespace) {
        return namespace.isEmpty();
    }

    private void checkMandatoryNamespacesAvailable() throws EntityProviderException {
        if (!this.xmlNamespaceMap.containsValue("http://schemas.microsoft.com/ado/2007/06/edmx")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{"http://schemas.microsoft.com/ado/2007/06/edmx"}));
        }
        if (!this.xmlNamespaceMap.containsValue("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata"}));
        }
    }

    private void checkEdmNamespace() throws EntityProviderException {
        if (!this.edmNamespaces.contains(this.edmNamespace)) {
            throw new EntityProviderException(EntityProviderException.INVALID_NAMESPACE.addContent(new Object[]{"Schema"}));
        }
    }

    private void extractNamespaces(XMLStreamReader reader) throws EntityProviderException {
        int namespaceCount = reader.getNamespaceCount();
        for (int i = 0; i < namespaceCount; ++i) {
            String namespacePrefix = reader.getNamespacePrefix(i);
            String namespaceUri = reader.getNamespaceURI(i);
            if (namespacePrefix == null || this.isDefaultNamespace(namespacePrefix)) {
                namespacePrefix = "edm";
            }
            if (this.xmlNamespaceMap.containsKey(namespacePrefix)) continue;
            this.xmlNamespaceMap.put(namespacePrefix, namespaceUri);
        }
    }

    private FullQualifiedName extractFQName(String name) throws EntityProviderException {
        String[] names = name.split("\\.(?=[^\\.]+$)");
        if (names.length != 2) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Attribute should specify a namespace qualified name or an alias qualified name"}));
        }
        return new FullQualifiedName(names[0], names[1]);
    }

    private FullQualifiedName validateEntityTypeWithAlias(FullQualifiedName aliasName) throws EntityProviderException {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.entityTypesMap.containsKey(fqName)) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Invalid Type"}));
        }
        return fqName;
    }

    private void validateEntityTypes() throws EntityProviderException {
        for (Map.Entry<FullQualifiedName, EntityType> entityTypes : this.entityTypesMap.entrySet()) {
            if (entityTypes.getValue() == null || entityTypes.getKey() == null) continue;
            EntityType entityType = entityTypes.getValue();
            if (entityType.getBaseType() != null) {
                EntityType baseEntityType;
                FullQualifiedName baseTypeFQName = entityType.getBaseType();
                if (!this.entityTypesMap.containsKey(baseTypeFQName)) {
                    FullQualifiedName fqName = this.validateEntityTypeWithAlias(baseTypeFQName);
                    baseEntityType = this.entityTypesMap.get(fqName);
                } else {
                    baseEntityType = this.fetchLastBaseType(baseTypeFQName, this.entityTypesMap);
                }
                if (baseEntityType == null || baseEntityType.getKey() != null) continue;
                throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Missing key for EntityType " + baseEntityType.getName()}));
            }
            if (entityType.getKey() != null) continue;
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Missing key for EntityType " + entityType.getName()}));
        }
    }

    private EntityType fetchLastBaseType(FullQualifiedName baseTypeFQName, Map<FullQualifiedName, EntityType> entityTypesMap) throws EntityProviderException {
        EntityType baseEntityType = null;
        while (baseTypeFQName != null && (baseEntityType = entityTypesMap.get(baseTypeFQName)).getKey() == null) {
            if (baseEntityType != null && baseEntityType.getBaseType() != null) {
                baseTypeFQName = baseEntityType.getBaseType();
                continue;
            }
            if (baseEntityType.getBaseType() != null) continue;
            break;
        }
        return baseEntityType;
    }

    private FullQualifiedName validateComplexTypeWithAlias(FullQualifiedName aliasName) throws EntityProviderException {
        String namespace = this.aliasNamespaceMap.get(aliasName.getNamespace());
        FullQualifiedName fqName = new FullQualifiedName(namespace, aliasName.getName());
        if (!this.complexTypesMap.containsKey(fqName)) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Invalid BaseType"}).addContent(new Object[]{fqName}));
        }
        return fqName;
    }

    private void validateComplexTypes() throws EntityProviderException {
        for (Map.Entry<FullQualifiedName, ComplexType> complexTypes : this.complexTypesMap.entrySet()) {
            FullQualifiedName baseTypeFQName;
            ComplexType complexType;
            if (complexTypes.getValue() == null || complexTypes.getKey() == null || (complexType = complexTypes.getValue()).getBaseType() == null || this.complexTypesMap.containsKey(baseTypeFQName = complexType.getBaseType())) continue;
            this.validateComplexTypeWithAlias(baseTypeFQName);
        }
    }

    private void validateRelationship() throws EntityProviderException {
        for (NavigationProperty navProperty : this.navProperties) {
            if (this.associationsMap.containsKey(navProperty.getRelationship())) {
                Association assoc = this.associationsMap.get(navProperty.getRelationship());
                if (!(assoc.getEnd1().getRole().equals(navProperty.getFromRole()) ^ assoc.getEnd1().getRole().equals(navProperty.getToRole())) || !(assoc.getEnd2().getRole().equals(navProperty.getFromRole()) ^ assoc.getEnd2().getRole().equals(navProperty.getToRole()))) {
                    throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Invalid end of association"}));
                }
                if (!this.entityTypesMap.containsKey(assoc.getEnd1().getType())) {
                    this.validateEntityTypeWithAlias(assoc.getEnd1().getType());
                }
                if (this.entityTypesMap.containsKey(assoc.getEnd2().getType())) continue;
                this.validateEntityTypeWithAlias(assoc.getEnd2().getType());
                continue;
            }
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Invalid Relationship"}));
        }
    }

    private void validateAssociation() throws EntityProviderException {
        for (Map.Entry<FullQualifiedName, EntityContainer> container : this.containerMap.entrySet()) {
            for (AssociationSet associationSet : container.getValue().getAssociationSets()) {
                FullQualifiedName association = associationSet.getAssociation();
                if (this.associationsMap.containsKey(association)) {
                    this.validateAssociationEnd(associationSet.getEnd1(), this.associationsMap.get(association));
                    this.validateAssociationEnd(associationSet.getEnd2(), this.associationsMap.get(association));
                    boolean end1 = false;
                    boolean end2 = false;
                    for (EntitySet entitySet : container.getValue().getEntitySets()) {
                        if (entitySet.getName().equals(associationSet.getEnd1().getEntitySet())) {
                            end1 = true;
                        }
                        if (!entitySet.getName().equals(associationSet.getEnd2().getEntitySet())) continue;
                        end2 = true;
                    }
                    if (end1 && end2) continue;
                    throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Invalid AssociationSet"}));
                }
                throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Invalid AssociationSet"}));
            }
        }
    }

    private void validateAssociationEnd(AssociationSetEnd end, Association association) throws EntityProviderException {
        if (!(association.getEnd1().getRole().equals(end.getRole()) ^ association.getEnd2().getRole().equals(end.getRole()))) {
            throw new EntityProviderException(EntityProviderException.COMMON.addContent(new Object[]{"Invalid Association"}));
        }
    }

    private void validateEntitySet() throws EntityProviderException {
        for (Map.Entry<FullQualifiedName, EntityContainer> container : this.containerMap.entrySet()) {
            for (EntitySet entitySet : container.getValue().getEntitySets()) {
                FullQualifiedName entityType = entitySet.getEntityType();
                if (this.entityTypesMap.containsKey(entityType)) continue;
                this.validateEntityTypeWithAlias(entityType);
            }
        }
    }

    private void validate() throws EntityProviderException {
        this.checkMandatoryNamespacesAvailable();
        this.validateEntityTypes();
        this.validateComplexTypes();
        this.validateRelationship();
        this.validateEntitySet();
        this.validateAssociation();
    }

    private void initialize() {
        this.xmlNamespaceMap = new HashMap<String, String>();
        this.mandatoryNamespaces = new HashMap<String, String>();
        this.mandatoryNamespaces.put("edmx", "http://schemas.microsoft.com/ado/2007/06/edmx");
        this.mandatoryNamespaces.put("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
        this.edmNamespaces = new HashSet<String>();
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2006/04/edm");
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2007/05/edm");
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2008/01/edm");
        this.edmNamespaces.add("http://schemas.microsoft.com/ado/2008/09/edm");
    }
}

