/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.SimpleProperty;
import org.apache.olingo.odata2.core.edm.EdmSimpleTypeFacadeImpl;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmPropertyImplProv;

public class EdmSimplePropertyImplProv
extends EdmPropertyImplProv {
    private SimpleProperty property;
    private List<EdmProperty> composite;

    public EdmSimplePropertyImplProv(EdmImplProv edm, SimpleProperty property) throws EdmException {
        super(edm, property.getType().getFullQualifiedName(), (Property)property);
        this.property = property;
        if (this.property.getComposite() != null) {
            this.composite = new LinkedList<EdmProperty>();
            for (Property p : this.property.getComposite()) {
                this.composite.add(new EdmSimplePropertyImplProv(edm, (SimpleProperty)p));
            }
        }
    }

    @Override
    public EdmType getType() throws EdmException {
        if (this.edmType == null) {
            this.edmType = EdmSimpleTypeFacadeImpl.getEdmSimpleType(this.property.getType());
            if (this.edmType == null) {
                throw new EdmException(EdmException.COMMON);
            }
        }
        return this.edmType;
    }

    public boolean isSimple() {
        return true;
    }

    public List<EdmProperty> getComposite() {
        return this.composite;
    }

    public SimpleProperty getProperty() {
        return this.property;
    }
}

