/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;

public class EdmString
extends AbstractSimpleType {
    private static final Pattern PATTERN_ASCII = Pattern.compile("\\p{ASCII}*");
    private static final EdmString instance = new EdmString();

    public static EdmString getInstance() {
        return instance;
    }

    public Class<?> getDefaultType() {
        return String.class;
    }

    public final String valueToObjectKeyString(Object value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        if (value == null) {
            return null;
        }
        String result = this.internalValueToString(value, literalKind, facets);
        return result;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        String result = literalKind == EdmLiteralKind.URI ? (value.length() >= 2 && value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1).replace("''", "'") : value) : value;
        if (facets != null && facets.isUnicode() != null && !facets.isUnicode().booleanValue() && !PATTERN_ASCII.matcher(result).matches()) {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_FACETS_NOT_MATCHED.addContent(new Object[]{value, facets}));
        }
        if (returnType.isAssignableFrom(String.class)) {
            return returnType.cast(result);
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(new Object[]{returnType}));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        String result = value instanceof String ? (String)value : String.valueOf(value);
        return result;
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        int length = literal.length();
        StringBuilder uriLiteral = new StringBuilder(length + 2);
        uriLiteral.append('\'');
        for (int i = 0; i < length; ++i) {
            char c = literal.charAt(i);
            if (c == '\'') {
                uriLiteral.append(c);
            }
            uriLiteral.append(c);
        }
        uriLiteral.append('\'');
        return uriLiteral.toString();
    }
}

