/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.OnWriteEntryContent;
import org.apache.olingo.odata2.api.ep.callback.OnWriteFeedContent;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackResult;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackResult;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonFeedEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonLinkEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonPropertyEntityProducer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonEntryEntityProducer {
    private final EntityProviderWriteProperties properties;
    private String eTag;
    private String location;
    private JsonStreamWriter jsonStreamWriter;

    public JsonEntryEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(Writer writer, EntityInfoAggregator entityInfo, Map<String, Object> data, boolean isRootElement) throws EntityProviderException {
        EdmEntityType type = entityInfo.getEntityType();
        try {
            this.jsonStreamWriter = new JsonStreamWriter(writer);
            if (this.properties.getCallback() != null && isRootElement) {
                this.jsonStreamWriter.unquotedValue(this.properties.getCallback());
                this.jsonStreamWriter.unquotedValue("(");
            }
            if (isRootElement && !this.properties.isOmitJsonWrapper()) {
                this.jsonStreamWriter.beginObject();
                if (this.properties.getClientCallbacks() != null && !this.properties.getClientCallbacks().isEmpty()) {
                    JsonFeedEntityProducer.appendClientCallbacks(this.jsonStreamWriter, this.properties.getClientCallbacks());
                }
                this.jsonStreamWriter.name("d");
            }
            this.jsonStreamWriter.beginObject();
            boolean containsMetadata = false;
            if (!this.properties.isContentOnly() || this.properties.isContentOnly() && this.properties.isIncludeMetadataInContentOnly()) {
                this.writeMetadata(entityInfo, data, type);
                containsMetadata = true;
            }
            this.writeProperties(entityInfo, data, type, containsMetadata);
            if (!this.properties.isContentOnly()) {
                this.writeNavigationProperties(writer, entityInfo, data, type);
            } else {
                this.writeAdditonalLinksInContentOnlyCase(entityInfo);
            }
            this.jsonStreamWriter.endObject();
            if (isRootElement && !this.properties.isOmitJsonWrapper()) {
                this.jsonStreamWriter.endObject();
            }
            if (this.properties.getCallback() != null && isRootElement) {
                this.jsonStreamWriter.unquotedValue(")");
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), e);
        }
    }

    private void writeNavigationProperties(Writer writer, EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type) throws EdmException, EntityProviderException, IOException {
        for (String navigationPropertyName : type.getNavigationPropertyNames()) {
            if (!entityInfo.getSelectedNavigationPropertyNames().contains(navigationPropertyName)) continue;
            this.jsonStreamWriter.separator();
            this.jsonStreamWriter.name(navigationPropertyName);
            if (entityInfo.getExpandedNavigationPropertyNames().contains(navigationPropertyName)) {
                if (this.properties.getCallbacks() != null && this.properties.getCallbacks().containsKey(navigationPropertyName)) {
                    this.writeExpandedNavigationProperty(writer, entityInfo, data, type, navigationPropertyName);
                    continue;
                }
                this.writeDeferredUri(entityInfo, navigationPropertyName);
                continue;
            }
            this.writeDeferredUri(entityInfo, navigationPropertyName);
        }
    }

    private void writeExpandedNavigationProperty(Writer writer, EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type, String navigationPropertyName) throws EdmException, EntityProviderException, IOException {
        EdmNavigationProperty navigationProperty = (EdmNavigationProperty)type.getProperty(navigationPropertyName);
        boolean isFeed = navigationProperty.getMultiplicity() == EdmMultiplicity.MANY;
        EdmEntitySet entitySet = entityInfo.getEntitySet();
        EdmEntitySet inlineEntitySet = entitySet.getRelatedEntitySet(navigationProperty);
        WriteFeedCallbackContext context = isFeed ? new WriteFeedCallbackContext() : new WriteEntryCallbackContext();
        context.setSourceEntitySet(entitySet);
        context.setNavigationProperty(navigationProperty);
        context.setEntryData(data);
        context.setCurrentWriteProperties(this.properties);
        context.setCurrentExpandSelectTreeNode((ExpandSelectTreeNode)this.properties.getExpandSelectTree().getLinks().get(navigationPropertyName));
        ODataCallback callback = (ODataCallback)this.properties.getCallbacks().get(navigationPropertyName);
        if (callback == null) {
            throw new EntityProviderProducerException(EntityProviderException.EXPANDNOTSUPPORTED);
        }
        try {
            if (isFeed) {
                WriteFeedCallbackResult result = ((OnWriteFeedContent)callback).retrieveFeedResult(context);
                ArrayList<Map<String, Object>> inlineData = result.getFeedData();
                if (inlineData == null) {
                    inlineData = new ArrayList<Map<String, Object>>();
                }
                if (this.properties.isOmitInlineForNullData() && inlineData.isEmpty()) {
                    this.writeDeferredUri(entityInfo, navigationPropertyName);
                    return;
                }
                EntityProviderWriteProperties inlineProperties = result.getInlineProperties();
                EntityInfoAggregator inlineEntityInfo = EntityInfoAggregator.create(inlineEntitySet, inlineProperties.getExpandSelectTree());
                JsonFeedEntityProducer jsonFeedEntityProducer = new JsonFeedEntityProducer(inlineProperties);
                if (this.properties.isResponsePayload()) {
                    jsonFeedEntityProducer.appendAsObject(writer, inlineEntityInfo, inlineData, false);
                } else {
                    jsonFeedEntityProducer.appendAsArray(writer, inlineEntityInfo, inlineData);
                }
            } else {
                WriteEntryCallbackResult result = ((OnWriteEntryContent)callback).retrieveEntryResult((WriteEntryCallbackContext)context);
                Map inlineData = result.getEntryData();
                if (this.properties.isOmitInlineForNullData() && (inlineData == null || inlineData.isEmpty())) {
                    this.writeDeferredUri(entityInfo, navigationPropertyName);
                    return;
                }
                if (inlineData != null && !inlineData.isEmpty()) {
                    EntityProviderWriteProperties inlineProperties = result.getInlineProperties();
                    EntityInfoAggregator inlineEntityInfo = EntityInfoAggregator.create(inlineEntitySet, inlineProperties.getExpandSelectTree());
                    new JsonEntryEntityProducer(inlineProperties).append(writer, inlineEntityInfo, inlineData, false);
                } else {
                    this.jsonStreamWriter.unquotedValue("null");
                }
            }
        }
        catch (ODataApplicationException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), e);
        }
    }

    private void writeProperties(EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type, boolean containsMetadata) throws EdmException, EntityProviderException, IOException {
        boolean omitComma = !containsMetadata;
        List propertyNames = type.getPropertyNames();
        for (String propertyName : propertyNames) {
            if (this.properties.isDataBasedPropertySerialization() && data.containsKey(propertyName)) {
                omitComma = this.appendPropertyNameValue(entityInfo, data, omitComma, propertyName);
                continue;
            }
            if (this.properties.isDataBasedPropertySerialization() || !entityInfo.getSelectedPropertyNames().contains(propertyName)) continue;
            omitComma = this.appendPropertyNameValue(entityInfo, data, omitComma, propertyName);
        }
    }

    private boolean appendPropertyNameValue(EntityInfoAggregator entityInfo, Map<String, Object> data, boolean omitComma, String propertyName) throws IOException, EdmException, EntityProviderException {
        if (omitComma) {
            omitComma = false;
        } else {
            this.jsonStreamWriter.separator();
        }
        this.jsonStreamWriter.name(propertyName);
        JsonPropertyEntityProducer.appendPropertyValue(this.jsonStreamWriter, entityInfo.getPropertyInfo(propertyName), data.get(propertyName), this.properties.isValidatingFacets(), this.properties.isDataBasedPropertySerialization());
        return omitComma;
    }

    private void writeMetadata(EntityInfoAggregator entityInfo, Map<String, Object> data, EdmEntityType type) throws IOException, EntityProviderException, EdmException {
        this.location = this.properties.getServiceRoot() == null ? "" : this.properties.getServiceRoot().toASCIIString() + AtomEntryEntityProducer.createSelfLink(entityInfo, data, null);
        this.jsonStreamWriter.name("__metadata");
        this.jsonStreamWriter.beginObject();
        this.jsonStreamWriter.namedStringValue("id", this.location);
        this.jsonStreamWriter.separator();
        this.jsonStreamWriter.namedStringValue("uri", this.location);
        this.jsonStreamWriter.separator();
        this.jsonStreamWriter.namedStringValueRaw("type", type.getNamespace() + "." + type.getName());
        if (!this.properties.isOmitETag()) {
            this.eTag = AtomEntryEntityProducer.createETag(entityInfo, data);
            if (this.eTag != null) {
                this.jsonStreamWriter.separator();
                this.jsonStreamWriter.namedStringValue("etag", this.eTag);
            }
        }
        if (type.hasStream()) {
            this.jsonStreamWriter.separator();
            EdmMapping entityTypeMapping = entityInfo.getEntityType().getMapping();
            String mediaResourceMimeType = null;
            Object mediaSrc = null;
            if (entityTypeMapping != null) {
                String mediaResourceMimeTypeKey;
                String mediaResourceSourceKey = entityTypeMapping.getMediaResourceSourceKey();
                if (mediaResourceSourceKey != null) {
                    mediaSrc = (String)data.get(mediaResourceSourceKey);
                }
                if (mediaSrc == null) {
                    mediaSrc = this.location + "/$value";
                }
                if ((mediaResourceMimeTypeKey = entityTypeMapping.getMediaResourceMimeTypeKey()) != null) {
                    mediaResourceMimeType = (String)data.get(mediaResourceMimeTypeKey);
                }
                if (mediaResourceMimeType == null) {
                    mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
                }
            } else {
                mediaSrc = this.location + "/$value";
                mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            this.jsonStreamWriter.namedStringValueRaw("content_type", mediaResourceMimeType);
            this.jsonStreamWriter.separator();
            this.jsonStreamWriter.namedStringValue("media_src", (String)mediaSrc);
            this.jsonStreamWriter.separator();
            this.jsonStreamWriter.namedStringValue("edit_media", this.location + "/$value");
        }
        this.jsonStreamWriter.endObject();
    }

    private void writeDeferredUri(EntityInfoAggregator entityInfo, String navigationPropertyName) throws IOException, EntityProviderException, EdmException {
        this.jsonStreamWriter.beginObject().name("__deferred");
        Object target = null;
        Map links = this.properties.getAdditionalLinks();
        Map key = links == null ? null : (Map)links.get(navigationPropertyName);
        target = key == null || key.isEmpty() ? this.location + "/" + Encoder.encode(navigationPropertyName) : this.createCustomTargetLink(entityInfo, navigationPropertyName, key);
        JsonLinkEntityProducer.appendUri(this.jsonStreamWriter, (String)target);
        this.jsonStreamWriter.endObject();
    }

    private String createCustomTargetLink(EntityInfoAggregator entityInfo, String navigationPropertyName, Map<String, Object> key) throws EntityProviderException, EdmException {
        EntityInfoAggregator targetEntityInfo = EntityInfoAggregator.create(entityInfo.getEntitySet().getRelatedEntitySet((EdmNavigationProperty)entityInfo.getEntityType().getProperty(navigationPropertyName)));
        String target = (this.properties.getServiceRoot() == null ? "" : this.properties.getServiceRoot().toASCIIString()) + AtomEntryEntityProducer.createSelfLink(targetEntityInfo, key, null);
        return target;
    }

    private void writeAdditonalLinksInContentOnlyCase(EntityInfoAggregator entityInfo) throws IOException, EntityProviderException, EdmException {
        Map links = this.properties.getAdditionalLinks();
        if (links != null && !links.isEmpty()) {
            for (Map.Entry entry : links.entrySet()) {
                Map navigationKeyMap = (Map)entry.getValue();
                if (navigationKeyMap == null || navigationKeyMap.isEmpty()) continue;
                String target = this.createCustomTargetLink(entityInfo, (String)entry.getKey(), navigationKeyMap);
                this.jsonStreamWriter.separator();
                this.jsonStreamWriter.name((String)entry.getKey());
                this.jsonStreamWriter.beginObject().name("__deferred");
                JsonLinkEntityProducer.appendUri(this.jsonStreamWriter, target);
                this.jsonStreamWriter.endObject();
            }
        }
    }

    public String getETag() {
        return this.eTag;
    }

    public String getLocation() {
        return this.location;
    }
}

