/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.core.commons.ContentType;

public class JsonErrorDocumentConsumer {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final Map<String, Locale> AVAILABLE_LOCALES;

    public ODataErrorContext readError(InputStream errorDocument) throws EntityProviderException {
        JsonReader reader = this.createJsonReader(errorDocument);
        try {
            return this.parseJson(reader);
        }
        catch (IOException | IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private ODataErrorContext parseJson(JsonReader reader) throws IOException, EntityProviderException {
        if (reader.hasNext()) {
            reader.beginObject();
            String currentName = reader.nextName();
            if (!"error".equals(currentName)) {
                throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Invalid object with name '" + currentName + "' found."}));
            }
        } else {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"No content to parse found."}));
        }
        ODataErrorContext errorContext = this.parseError(reader);
        errorContext.setContentType(ContentType.APPLICATION_JSON.toContentTypeString());
        return errorContext;
    }

    private ODataErrorContext parseError(JsonReader reader) throws IOException, EntityProviderException {
        ODataErrorContext errorContext = new ODataErrorContext();
        reader.beginObject();
        boolean messageFound = false;
        boolean codeFound = false;
        while (reader.hasNext()) {
            String currentName = reader.nextName();
            if ("code".equals(currentName)) {
                codeFound = true;
                errorContext.setErrorCode(this.getValue(reader));
                continue;
            }
            if ("message".equals(currentName)) {
                messageFound = true;
                this.parseMessage(reader, errorContext);
                continue;
            }
            if ("innererror".equals(currentName)) {
                this.parseInnerError(reader, errorContext);
                continue;
            }
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Invalid name '" + currentName + "' found."}));
        }
        if (!codeFound) {
            throw new EntityProviderException(EntityProviderException.MISSING_PROPERTY.addContent(new Object[]{"Mandatory 'code' property not found.'"}));
        }
        if (!messageFound) {
            throw new EntityProviderException(EntityProviderException.MISSING_PROPERTY.addContent(new Object[]{"Mandatory 'message' property not found.'"}));
        }
        reader.endObject();
        return errorContext;
    }

    private void parseInnerError(JsonReader reader, ODataErrorContext errorContext) throws IOException {
        JsonToken token = reader.peek();
        if (token == JsonToken.STRING) {
            String innerError = reader.nextString();
            errorContext.setInnerError(innerError);
        } else if (token == JsonToken.BEGIN_OBJECT) {
            errorContext.setInnerError(this.readJson(reader));
        }
    }

    private String readJson(JsonReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (reader.hasNext()) {
            JsonToken token = reader.peek();
            if (token == JsonToken.NAME) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                String name = reader.nextName();
                sb.append("\"").append(name).append("\"").append(":");
                continue;
            }
            if (token == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                sb.append("{").append(this.readJson(reader)).append("}");
                reader.endObject();
                continue;
            }
            if (token == JsonToken.BEGIN_ARRAY) {
                reader.beginArray();
                sb.append("[").append(this.readJson(reader)).append("]");
                reader.endArray();
                continue;
            }
            sb.append("\"").append(reader.nextString()).append("\"");
        }
        return sb.toString();
    }

    private void parseMessage(JsonReader reader, ODataErrorContext errorContext) throws IOException, EntityProviderException {
        reader.beginObject();
        boolean valueFound = false;
        boolean langFound = false;
        while (reader.hasNext()) {
            String currentName = reader.nextName();
            if ("lang".equals(currentName)) {
                langFound = true;
                String langValue = this.getValue(reader);
                if (langValue == null) continue;
                errorContext.setLocale(this.getLocale(langValue));
                continue;
            }
            if ("value".equals(currentName)) {
                valueFound = true;
                errorContext.setMessage(this.getValue(reader));
                continue;
            }
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Invalid name '" + currentName + "' found."}));
        }
        if (!langFound) {
            throw new EntityProviderException(EntityProviderException.MISSING_PROPERTY.addContent(new Object[]{"Mandatory 'lang' property not found.'"}));
        }
        if (!valueFound) {
            throw new EntityProviderException(EntityProviderException.MISSING_PROPERTY.addContent(new Object[]{"Mandatory 'value' property not found.'"}));
        }
        reader.endObject();
    }

    private Locale getLocale(String langValue) {
        return AVAILABLE_LOCALES.get(langValue);
    }

    private String getValue(JsonReader reader) throws IOException {
        JsonToken token = reader.peek();
        if (JsonToken.NULL == token) {
            reader.skipValue();
            return null;
        }
        return reader.nextString();
    }

    private JsonReader createJsonReader(InputStream in) throws EntityProviderException {
        if (in == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent(new Object[]{"Got not supported NULL object as content to de-serialize."}));
        }
        try {
            return new JsonReader((Reader)new InputStreamReader(in, DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    static {
        Locale[] locales;
        AVAILABLE_LOCALES = new HashMap<String, Locale>();
        for (Locale l2 : locales = (Locale[])Arrays.stream(Locale.getAvailableLocales()).filter(l -> l.getScript().isEmpty()).toArray(Locale[]::new)) {
            AVAILABLE_LOCALES.put(l2.getLanguage() + "-" + l2.getCountry(), l2);
        }
    }
}

