/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotations;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmAssociationSet;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.edm.provider.EdmAnnotationsImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmAssociationSetImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmEntitySetImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmFunctionImportImplProv;
import org.apache.olingo.odata2.core.edm.provider.EdmImplProv;

public class EdmEntityContainerImplProv
implements EdmEntityContainer,
EdmAnnotatable {
    private EdmImplProv edm;
    private List<EntityContainer> entityContainerHierachy;
    private EntityContainerInfo entityContainerInfo;
    private Map<String, EdmEntitySet> edmEntitySets;
    private Map<String, EdmAssociationSet> edmAssociationSets;
    private Map<String, EdmFunctionImport> edmFunctionImports;
    private EdmEntityContainer edmExtendedEntityContainer;
    private boolean isDefaultContainer;
    private EdmAnnotations annotations;

    public EdmEntityContainerImplProv(EdmImplProv edm, EntityContainerInfo entityContainerInfo) throws EdmException {
        this.edm = edm;
        this.entityContainerInfo = entityContainerInfo;
        this.edmEntitySets = new HashMap<String, EdmEntitySet>();
        this.edmAssociationSets = new HashMap<String, EdmAssociationSet>();
        this.edmFunctionImports = new HashMap<String, EdmFunctionImport>();
        this.isDefaultContainer = entityContainerInfo.isDefaultEntityContainer();
        if (entityContainerInfo.getExtendz() != null) {
            this.edmExtendedEntityContainer = edm.getEntityContainer(entityContainerInfo.getExtendz());
            if (this.edmExtendedEntityContainer == null) {
                throw new EdmException(EdmException.COMMON);
            }
        }
    }

    public String getName() throws EdmException {
        return this.entityContainerInfo.getName();
    }

    public EdmEntitySet getEntitySet(String name) throws EdmException {
        EntitySet entitySet;
        EdmEntitySet edmEntitySet = this.edmEntitySets.get(name);
        if (edmEntitySet != null) {
            return edmEntitySet;
        }
        try {
            entitySet = this.edm.edmProvider.getEntitySet(this.entityContainerInfo.getName(), name);
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.PROVIDERPROBLEM, (Throwable)e);
        }
        if (entitySet != null) {
            edmEntitySet = this.createEntitySet(entitySet);
        } else if (this.edmExtendedEntityContainer != null && (edmEntitySet = this.edmExtendedEntityContainer.getEntitySet(name)) != null) {
            this.edmEntitySets.put(name, edmEntitySet);
        }
        return edmEntitySet;
    }

    public EdmFunctionImport getFunctionImport(String name) throws EdmException {
        FunctionImport functionImport;
        EdmFunctionImport edmFunctionImport = this.edmFunctionImports.get(name);
        if (edmFunctionImport != null) {
            return edmFunctionImport;
        }
        try {
            functionImport = this.edm.edmProvider.getFunctionImport(this.entityContainerInfo.getName(), name);
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.PROVIDERPROBLEM, (Throwable)e);
        }
        if (functionImport != null) {
            edmFunctionImport = this.createFunctionImport(functionImport);
            this.edmFunctionImports.put(name, edmFunctionImport);
        } else if (this.edmExtendedEntityContainer != null && (edmFunctionImport = this.edmExtendedEntityContainer.getFunctionImport(name)) != null) {
            this.edmFunctionImports.put(name, edmFunctionImport);
        }
        return edmFunctionImport;
    }

    public EdmAssociationSet getAssociationSet(EdmEntitySet sourceEntitySet, EdmNavigationProperty navigationProperty) throws EdmException {
        AssociationSet associationSet;
        String entitySetFromRole;
        EdmAssociation edmAssociation = navigationProperty.getRelationship();
        String association = edmAssociation.getNamespace() + "." + edmAssociation.getName();
        String entitySetName = sourceEntitySet.getName();
        String key = entitySetName + ">>" + association + ">>" + (entitySetFromRole = navigationProperty.getFromRole());
        EdmAssociationSet edmAssociationSet = this.edmAssociationSets.get(key);
        if (edmAssociationSet != null) {
            return edmAssociationSet;
        }
        FullQualifiedName associationFQName = new FullQualifiedName(edmAssociation.getNamespace(), edmAssociation.getName());
        try {
            associationSet = this.edm.edmProvider.getAssociationSet(this.entityContainerInfo.getName(), associationFQName, entitySetName, entitySetFromRole);
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.PROVIDERPROBLEM, (Throwable)e);
        }
        if (associationSet != null) {
            edmAssociationSet = this.createAssociationSet(associationSet);
            this.edmAssociationSets.put(key, edmAssociationSet);
            return edmAssociationSet;
        }
        if (this.edmExtendedEntityContainer != null) {
            edmAssociationSet = this.edmExtendedEntityContainer.getAssociationSet(sourceEntitySet, navigationProperty);
            this.edmAssociationSets.put(key, edmAssociationSet);
            return edmAssociationSet;
        }
        throw new EdmException(EdmException.COMMON);
    }

    private EdmEntitySet createEntitySet(EntitySet entitySet) throws EdmException {
        EdmEntitySetImplProv edmEntitySet = new EdmEntitySetImplProv(this.edm, entitySet, this);
        this.edmEntitySets.put(entitySet.getName(), edmEntitySet);
        return edmEntitySet;
    }

    private EdmFunctionImport createFunctionImport(FunctionImport functionImport) throws EdmException {
        return new EdmFunctionImportImplProv(this.edm, functionImport, this);
    }

    private EdmAssociationSet createAssociationSet(AssociationSet associationSet) throws EdmException {
        return new EdmAssociationSetImplProv(this.edm, associationSet, this);
    }

    public boolean isDefaultEntityContainer() {
        return this.isDefaultContainer;
    }

    public EdmAnnotations getAnnotations() throws EdmException {
        if (this.annotations == null) {
            this.annotations = new EdmAnnotationsImplProv(this.entityContainerInfo.getAnnotationAttributes(), this.entityContainerInfo.getAnnotationElements());
        }
        return this.annotations;
    }

    public List<EdmEntitySet> getEntitySets() throws EdmException {
        try {
            ArrayList<EdmEntitySet> edmEntitySetsList = new ArrayList<EdmEntitySet>();
            List<EntityContainer> entityContainerHierachyList = this.getEntityContainerHierachy();
            for (EntityContainer entityContainer : entityContainerHierachyList) {
                List entitySets = entityContainer.getEntitySets();
                for (EntitySet entitySet : entitySets) {
                    EdmEntitySet ees = this.createEntitySet(entitySet);
                    edmEntitySetsList.add(ees);
                }
            }
            return edmEntitySetsList;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.PROVIDERPROBLEM, (Throwable)e);
        }
    }

    public List<EdmAssociationSet> getAssociationSets() throws EdmException {
        try {
            List<EntityContainer> containers = this.getEntityContainerHierachy();
            ArrayList<EdmAssociationSet> edmAssociationSetsList = new ArrayList<EdmAssociationSet>();
            for (EntityContainer entityContainer : containers) {
                List associationSets = entityContainer.getAssociationSets();
                for (AssociationSet associationSet : associationSets) {
                    EdmAssociationSet eas = this.createAssociationSet(associationSet);
                    edmAssociationSetsList.add(eas);
                }
            }
            return edmAssociationSetsList;
        }
        catch (ODataException e) {
            throw new EdmException(EdmException.PROVIDERPROBLEM, (Throwable)e);
        }
    }

    private Map<String, EntityContainer> getEntityContainerMap() throws ODataException {
        HashMap<String, EntityContainer> name2Container = new HashMap<String, EntityContainer>();
        List schemas = this.edm.edmProvider.getSchemas();
        for (Schema schema : schemas) {
            List containers = schema.getEntityContainers();
            for (EntityContainer container : containers) {
                name2Container.put(container.getName(), container);
            }
        }
        return name2Container;
    }

    private List<EntityContainer> getEntityContainerHierachy() throws ODataException {
        if (this.entityContainerHierachy != null) {
            return this.entityContainerHierachy;
        }
        this.entityContainerHierachy = new ArrayList<EntityContainer>();
        Map<String, EntityContainer> name2Container = this.getEntityContainerMap();
        String currentName = this.getName();
        while (currentName != null) {
            EntityContainer currentContainer = name2Container.get(currentName);
            this.entityContainerHierachy.add(currentContainer);
            currentName = currentContainer.getExtendz();
        }
        if (this.entityContainerHierachy.isEmpty()) {
            throw new EdmException(EdmException.PROVIDERPROBLEM, "No container at all found.");
        }
        return this.entityContainerHierachy;
    }
}

