/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset.jdbc;

import cronapp.reports.j4c.dataset.jdbc.ForeignKey;
import cronapp.reports.j4c.dataset.jdbc.Index;
import cronapp.reports.j4c.dataset.jdbc.JDBC;
import cronapp.reports.j4c.dataset.jdbc.PrimaryKey;
import cronapp.reports.j4c.dataset.jdbc.Relation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class Schema {
    private final Map<String, Relation> relations;
    private final Map<String, PrimaryKey> primaryKeys;
    private final Map<String, ForeignKey> foreignKeys;
    private final Map<String, Index> indexes;

    public Schema(Map<String, Relation> relations, Map<String, PrimaryKey> primaryKeys, Map<String, ForeignKey> foreignKeys, Map<String, Index> indexes) {
        this.relations = relations;
        this.primaryKeys = primaryKeys;
        this.foreignKeys = foreignKeys;
        this.indexes = indexes;
    }

    public Map<String, Relation> getRelations() {
        return this.relations;
    }

    public Map<String, PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Map<String, ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public Map<String, Index> getIndexes() {
        return this.indexes;
    }

    public static Schema create(Connection conn, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return Schema.create(meta, catalog, table);
    }

    public static Schema create(DatabaseMetaData meta, String catalog, String table) throws SQLException {
        Map<String, Relation> relations = JDBC.fetchColumns(meta, catalog, table);
        Map<String, PrimaryKey> primaryKeys = JDBC.fetchPrimaryKeys(meta, catalog, table);
        Map<String, ForeignKey> foreignKeys = JDBC.fetchForeignKeys(meta, catalog, table);
        HashMap<String, Index> indexes = new HashMap<String, Index>();
        for (String tableName : relations.keySet()) {
            indexes.putAll(JDBC.fetchIndexes(meta, catalog, null, tableName, true));
        }
        return new Schema(relations, primaryKeys, foreignKeys, indexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema createSchema(DataSource dataSource, String table) throws SQLException {
        Schema result;
        try (Connection conn = dataSource.getConnection();){
            result = Schema.create(conn, table);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        if (this.relations != null ? !this.relations.equals(schema.relations) : schema.relations != null) {
            return false;
        }
        if (this.primaryKeys != null ? !this.primaryKeys.equals(schema.primaryKeys) : schema.primaryKeys != null) {
            return false;
        }
        if (this.foreignKeys != null ? !this.foreignKeys.equals(schema.foreignKeys) : schema.foreignKeys != null) {
            return false;
        }
        return this.indexes != null ? this.indexes.equals(schema.indexes) : schema.indexes == null;
    }

    public int hashCode() {
        int result = this.relations != null ? this.relations.hashCode() : 0;
        result = 31 * result + (this.primaryKeys != null ? this.primaryKeys.hashCode() : 0);
        result = 31 * result + (this.foreignKeys != null ? this.foreignKeys.hashCode() : 0);
        result = 31 * result + (this.indexes != null ? this.indexes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Schema{relations=" + this.relations + ", primaryKeys=" + this.primaryKeys + ", foreignKeys=" + this.foreignKeys + ", indexes=" + this.indexes + '}';
    }
}

