/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports;

import cronapp.reports.ReportDataset;
import cronapp.reports.ReportExport;
import cronapp.reports.commons.Functions;
import cronapp.reports.commons.Parameter;
import cronapp.reports.j4c.commons.J4CDatasetType;
import cronapp.reports.j4c.dataset.J4CDataset;
import java.net.URL;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintDesign {
    private static final Logger log = LoggerFactory.getLogger(PrintDesign.class);
    private final JasperDesign jasperDesign;
    private final String fileTarget;
    private final List<Parameter> frontParameters;
    private final Map<String, Object> printParameters;
    private final Map<String, JRParameter> designParameters;
    private final ClassLoader loader;

    PrintDesign(JasperDesign jasperDesign, String fileTarget, List<Parameter> frontParameters) {
        this.jasperDesign = jasperDesign;
        this.fileTarget = fileTarget;
        this.frontParameters = frontParameters;
        this.printParameters = new HashMap<String, Object>();
        this.designParameters = jasperDesign.getParametersMap();
        this.loader = Thread.currentThread().getContextClassLoader();
    }

    public PrintDesign updateParameters() {
        this.frontParameters.forEach(parameter -> this.printParameters.put(parameter.getName(), parameter.getValue()));
        this.designParameters.entrySet().stream().filter(p -> !this.printParameters.containsKey(p.getKey())).forEach(parameter -> {
            String key = (String)parameter.getKey();
            JRParameter value = (JRParameter)parameter.getValue();
            if (value == null) {
                this.printParameters.put(key, null);
            } else {
                JRExpression valueExpression = value.getDefaultValueExpression();
                if (valueExpression != null) {
                    this.printParameters.put(key, valueExpression.getText());
                }
            }
        });
        return this;
    }

    public PrintDesign updateImages() {
        this.printParameters.entrySet().stream().filter(parameter -> ((String)parameter.getKey()).contains("image_")).forEach(parameter -> {
            URL resource;
            JRParameter jrParameter = this.designParameters.get(parameter.getKey());
            JRExpression defaultValueExpression = jrParameter.getDefaultValueExpression();
            if (defaultValueExpression != null && (resource = this.loader.getResource(defaultValueExpression.getText().replaceAll("\"", ""))) != null) {
                this.printParameters.put((String)parameter.getKey(), resource.getPath());
            }
        });
        return this;
    }

    public PrintDesign updateSubreports() {
        this.printParameters.entrySet().stream().filter(parameter -> ((String)parameter.getKey()).contains("sub_")).forEach(parameter -> {
            URL resource;
            JRParameter jrParameter = this.designParameters.get(parameter.getKey());
            JRExpression defaultValueExpression = jrParameter.getDefaultValueExpression();
            if (defaultValueExpression != null && (resource = this.loader.getResource(defaultValueExpression.getText().replaceAll("\"", "").replaceAll(".jrxml", ".jasper"))) != null) {
                this.printParameters.put((String)parameter.getKey(), resource.getPath());
            }
        });
        return this;
    }

    public ReportExport print(Connection connection) {
        JasperPrint jasperPrint;
        try {
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)this.jasperDesign);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.printParameters, (Connection)connection);
        }
        catch (JRException e) {
            log.error("Problems during the compile.");
            throw new RuntimeException(e);
        }
        return new ReportExport(this.fileTarget, jasperPrint);
    }

    public ReportExport print(Collection<?> objectCollection) {
        JasperPrint jasperPrint;
        try {
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)this.jasperDesign);
            JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(objectCollection);
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.printParameters, (JRDataSource)dataSource);
        }
        catch (JRException e) {
            log.error("Problems during the compile.");
            throw new RuntimeException(e);
        }
        return new ReportExport(this.fileTarget, jasperPrint);
    }

    public String getDatasource() {
        return this.jasperDesign.getProperty("DATASOURCE");
    }

    public J4CDataset getCollectionDataset() {
        List<ReportDataset> datasets;
        ReportDataset reportDataset;
        J4CDataset dataset;
        String property = this.jasperDesign.getProperty("REPORT_DATASET");
        if (Functions.isExists(property) && (dataset = (reportDataset = ReportDataset.getMain(datasets = ReportDataset.listFromJson(property))).getJ4CDataset()).getDatasetType().equals((Object)J4CDatasetType.COLLECTION)) {
            return dataset;
        }
        return null;
    }

    public Map<String, Object> getPrintParameters() {
        return Collections.unmodifiableMap(this.printParameters);
    }
}

