/*
 * Decompiled with CFR 0.152.
 */
package cronapp.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import cronapi.AppConfig;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.util.Operations;
import cronapp.s3.S3Context;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

@CronapiMetaData(categoryName="{{cronapp.s3.CronappS3.Description}}", categoryTags={"s3", "storage"})
public class CronappS3 {
    private static S3Context getContext(String namespace) throws Exception {
        Var config;
        if (StringUtils.isEmpty((String)namespace)) {
            namespace = AppConfig.guid();
        }
        if (!(config = Operations.getSystemParameter((Var)Var.valueOf((Object)("storage." + namespace + ".server")))).isEmptyOrNull().booleanValue()) {
            Var key = Operations.getSystemParameter((Var)Var.valueOf((Object)("storage." + namespace + ".key")));
            Var secret = Operations.getSystemParameter((Var)Var.valueOf((Object)("storage." + namespace + ".secret")));
            Var region = Operations.getSystemParameter((Var)Var.valueOf((Object)("storage." + namespace + ".region")));
            return CronappS3.configure(config.getObjectAsString(), key.getObjectAsString(), secret.getObjectAsString(), region.getObjectAsString());
        }
        config = Operations.getSystemParameter((Var)Var.valueOf((Object)"storage.server"));
        if (!config.isEmptyOrNull().booleanValue()) {
            Var key = Operations.getSystemParameter((Var)Var.valueOf((Object)"storage.key"));
            Var secret = Operations.getSystemParameter((Var)Var.valueOf((Object)"storage.secret"));
            Var region = Operations.getSystemParameter((Var)Var.valueOf((Object)"storage.region"));
            return CronappS3.configure(config.getObjectAsString(), key.getObjectAsString(), secret.getObjectAsString(), region.getObjectAsString());
        }
        throw new Exception("Storage not configured");
    }

    @CronapiMetaData
    public static S3Context configure(@ParamMetaData(blockType="cloudservices:storage") String bucket, String key, String secret, String region) {
        if (StringUtils.isBlank((String)region)) {
            region = "us-east-1";
        }
        if (StringUtils.isBlank((String)key) && StringUtils.isBlank((String)(key = Operations.getSystemParameter((Var)Var.valueOf((Object)("storage." + bucket + ".server"))).getObjectAsString()))) {
            key = Operations.getSystemParameter((Var)Var.valueOf((Object)"storage.key")).getObjectAsString();
        }
        if (StringUtils.isBlank((String)secret) && StringUtils.isBlank((String)(secret = Operations.getSystemParameter((Var)Var.valueOf((Object)("storage." + bucket + ".secret"))).getObjectAsString()))) {
            secret = Operations.getSystemParameter((Var)Var.valueOf((Object)"storage.secret")).getObjectAsString();
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(key, secret);
        AmazonS3 s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).withRegion(region)).build();
        S3Context context = new S3Context();
        context.bucket = bucket;
        context.client = s3client;
        return context;
    }

    @CronapiMetaData
    public static void get(S3Context context, String path, Var file) throws Exception {
        S3Object s3object = context.client.getObject(context.bucket, path);
        try (S3ObjectInputStream inputStreamS3 = s3object.getObjectContent();){
            if (file.getObject() instanceof OutputStream) {
                IOUtils.copy((InputStream)inputStreamS3, (OutputStream)((OutputStream)file.getObject()));
            } else {
                FileUtils.copyInputStreamToFile((InputStream)inputStreamS3, (File)file.getObjectAsFile());
            }
        }
    }

    @CronapiMetaData
    public static Var getBytes(S3Context context, String path) throws Exception {
        S3Object s3object = context.client.getObject(context.bucket, path);
        try (S3ObjectInputStream inputStreamS3 = s3object.getObjectContent();){
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStreamS3, (OutputStream)bytes);
            Var var = Var.valueOf((Object)bytes.toByteArray());
            return var;
        }
    }

    @CronapiMetaData
    public static void put(S3Context context, String path, Var file) throws Exception {
        if (file.getObject() instanceof byte[]) {
            context.client.putObject(context.bucket, path, (InputStream)new ByteArrayInputStream(file.getObjectAsByteArray()), new ObjectMetadata());
        } else if (file.getObject() instanceof InputStream) {
            context.client.putObject(context.bucket, path, (InputStream)file.getObject(), new ObjectMetadata());
        } else {
            context.client.putObject(context.bucket, path, file.getObjectAsFile());
        }
    }

    @CronapiMetaData
    public static void remove(S3Context context, String path) throws Exception {
        context.client.deleteObject(context.bucket, path);
    }

    @CronapiMetaData
    public static Var list(S3Context context, String path) throws Exception {
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(context.bucket).withPrefix(path);
        ListObjectsV2Result result = context.client.listObjectsV2(request);
        Var list = Var.valueOf(new LinkedList());
        list.getObjectAsList().addAll(result.getObjectSummaries());
        while (StringUtils.isNotEmpty((String)result.getNextContinuationToken())) {
            request.withContinuationToken(result.getNextContinuationToken());
            result = context.client.listObjectsV2(request);
            list.getObjectAsList().addAll(result.getObjectSummaries());
        }
        return list;
    }
}

