/*
 * Decompiled with CFR 0.152.
 */
package cronapp.cache;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.map.IMap;
import cronapi.AppConfig;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.util.Operations;
import cronapp.cache.HazelcastContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CronapiMetaData(categoryName="Hazelcast", categoryTags={"Hazelcast", "Cache", "Memory Cache"})
public class CronappHazelCast {
    private static final Logger log = LoggerFactory.getLogger(CronappHazelCast.class);
    private static Map<String, HazelcastContext> CACHE = new ConcurrentHashMap<String, HazelcastContext>();

    private static void connect(HazelcastContext context) {
        context.client = HazelcastClient.newHazelcastClient((ClientConfig)context.clientConfig);
        context.client.getLifecycleService().addLifecycleListener(context.lifecycleListener);
        context.connected = true;
    }

    private static void reconnect(HazelcastContext context) {
        context.connected = false;
        while (!context.connected.booleanValue()) {
            try {
                Thread.sleep(3000L);
                CronappHazelCast.connect(context);
            }
            catch (InterruptedException e) {
                break;
            }
            catch (Exception exception) {
            }
        }
    }

    @CronapiMetaData
    public static HazelcastContext configure(String namespace, @ParamMetaData(blockType="cloudservices:service:type=hazelcast") String host) {
        HazelcastContext cachedContext;
        if (StringUtils.isEmpty((String)namespace)) {
            namespace = AppConfig.guid();
        }
        if ((cachedContext = CACHE.get(namespace)) != null) {
            return cachedContext;
        }
        if (StringUtils.isBlank((String)host) && StringUtils.isBlank((String)(host = Operations.getSystemParameter((Var)Var.valueOf((Object)("cache." + namespace + ".server"))).getObjectAsString()))) {
            host = Operations.getSystemParameter((Var)Var.valueOf((Object)"cache.server")).getObjectAsString();
        }
        HazelcastContext context = new HazelcastContext();
        context.namespace = namespace;
        context.host = host;
        context.lifecycleListener = lifecycleEvent -> {
            if ("CLIENT_DISCONNECTED".equals(lifecycleEvent.getState().name())) {
                context.connected = false;
            } else if ("SHUTTING_DOWN".equals(lifecycleEvent.getState().name())) {
                CronappHazelCast.reconnect(context);
            }
        };
        context.clientConfig = new ClientConfig();
        context.clientConfig.getNetworkConfig().addAddress(new String[]{host});
        CACHE.put(namespace, context);
        try {
            CronappHazelCast.connect(context);
        }
        catch (Exception e) {
            new Thread(() -> CronappHazelCast.reconnect(context)).start();
        }
        return context;
    }

    @CronapiMetaData
    public static void put(HazelcastContext context, String key, Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG) Long expiration) throws Exception {
        if (!context.connected.booleanValue() || context.client == null) {
            return;
        }
        IMap map = context.client.getMap(context.namespace);
        map.put((Object)key, (Object)Var.valueOf((Object)value), expiration == null ? 0L : expiration, TimeUnit.SECONDS);
    }

    @CronapiMetaData
    public static Var get(HazelcastContext context, String key, Var defaultValue) throws Exception {
        if (!context.connected.booleanValue() || context.client == null) {
            return Var.VAR_NULL;
        }
        IMap map = context.client.getMap(context.namespace);
        return Var.valueOf((Object)map.getOrDefault((Object)key, (Object)defaultValue));
    }
}

