/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.telegram;

import com.fasterxml.jackson.databind.ObjectMapper;
import cronapi.CronapiMetaData;
import cronapi.Var;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.facilities.TelegramHttpClientBuilder;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendAnimation;
import org.telegram.telegrambots.meta.api.methods.send.SendAudio;
import org.telegram.telegrambots.meta.api.methods.send.SendChatAction;
import org.telegram.telegrambots.meta.api.methods.send.SendContact;
import org.telegram.telegrambots.meta.api.methods.send.SendDice;
import org.telegram.telegrambots.meta.api.methods.send.SendGame;
import org.telegram.telegrambots.meta.api.methods.send.SendInvoice;
import org.telegram.telegrambots.meta.api.methods.send.SendLocation;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaGroup;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.send.SendPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendSticker;
import org.telegram.telegrambots.meta.api.methods.send.SendVenue;
import org.telegram.telegrambots.meta.api.methods.send.SendVideo;
import org.telegram.telegrambots.meta.api.methods.send.SendVideoNote;
import org.telegram.telegrambots.meta.api.methods.send.SendVoice;
import org.telegram.telegrambots.meta.api.methods.updates.GetUpdates;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

@CronapiMetaData
public final class BotOperations {
    private static final Logger log = LoggerFactory.getLogger(BotOperations.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final CloseableHttpClient httpClient = TelegramHttpClientBuilder.build((DefaultBotOptions)new DefaultBotOptions());
    private static final HttpClientContext httpContext = HttpClientContext.create();
    private static final Object lock = new Object();

    private static DefaultAbsSender createSender(final String botToken) {
        return new DefaultAbsSender(new DefaultBotOptions()){

            public String getBotToken() {
                return botToken;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @CronapiMetaData
    public static Var getUpdates(Var botToken, Var limit, Var offset, Var allowedUpdates) throws Exception {
        block20: {
            GetUpdates request = GetUpdates.builder().limit(limit.getObjectAsInt()).timeout(Integer.valueOf(50)).offset(offset.getObjectAsInt()).build();
            if (Boolean.TRUE.equals(allowedUpdates.isNull())) {
                request.setAllowedUpdates(allowedUpdates.getObjectAsList());
            }
            String url = "https://api.telegram.org/bot" + botToken.getObjectAsString() + "/getupdates";
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("charset", StandardCharsets.UTF_8.name());
            httpPost.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)request), ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)httpContext);){
                String responseContent222 = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                if (response.getStatusLine().getStatusCode() >= 500) {
                    log.warn(responseContent222);
                    Object object = lock;
                    synchronized (object) {
                        lock.wait(500L);
                        break block20;
                    }
                }
                try {
                    List updates = request.deserializeResponse(responseContent222).stream().map(Var::valueOf).collect(Collectors.toList());
                    Var var = Var.valueOf(updates);
                    return var;
                }
                catch (JSONException e) {
                    log.error("Error deserializing update: " + responseContent222, (Throwable)e);
                }
            }
            catch (InvalidObjectException | SocketException | TelegramApiRequestException e2) {
                log.error(e2.getLocalizedMessage(), e2);
            }
            catch (SocketTimeoutException e3) {
                log.info(e3.getLocalizedMessage(), (Throwable)e3);
            }
            catch (InterruptedException e4) {
                log.info(e4.getLocalizedMessage(), (Throwable)e4);
                Thread.currentThread().interrupt();
            }
            catch (InternalError e5) {
                if (e5.getCause() instanceof InvocationTargetException) {
                    Throwable cause = e5.getCause().getCause();
                    log.error(cause.getLocalizedMessage(), cause);
                }
                throw e5;
            }
        }
        return Var.valueOf(Collections.emptyList());
    }

    @CronapiMetaData
    public static Var sendMessage(Var botToken, Var chatId, Var text) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendMessage method = SendMessage.builder().chatId(chatId.getObjectAsString()).text(text.getObjectAsString()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendAnimation(Var botToken, Var chatId, Var animation) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendAnimation method = SendAnimation.builder().chatId(chatId.getObjectAsString()).animation(new InputFile(animation.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendAudio(Var botToken, Var chatId, Var audio) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendAudio method = SendAudio.builder().chatId(chatId.getObjectAsString()).audio(new InputFile(audio.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendChatAction(Var botToken, Var chatId, Var action) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendChatAction method = SendChatAction.builder().chatId(chatId.getObjectAsString()).action(action.getObjectAsString()).build();
        Boolean message = (Boolean)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendContact(Var botToken, Var chatId, Var phoneNumber, Var firstName) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendContact method = SendContact.builder().chatId(chatId.getObjectAsString()).phoneNumber(phoneNumber.getObjectAsString()).firstName(firstName.getObjectAsString()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendDice(Var botToken, Var chatId) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendDice method = SendDice.builder().chatId(chatId.getObjectAsString()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendGame(Var botToken, Var chatId, Var gameShortName) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendGame method = SendGame.builder().chatId(chatId.getObjectAsString()).gameShortName(gameShortName.getObjectAsString()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendInvoice(Var botToken, Var chatId, Var title, Var description, Var payload, Var providerToken, Var startParameter, Var currency, Var prices) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendInvoice method = SendInvoice.builder().chatId(chatId.getObjectAsString()).title(title.getObjectAsString()).description(description.getObjectAsString()).payload(payload.getObjectAsString()).providerToken(providerToken.getObjectAsString()).startParameter(startParameter.getObjectAsString()).currency(currency.getObjectAsString()).prices((Collection)prices.getObjectAsList()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendLocation(Var botToken, Var chatId, Var latitude, Var longitude) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendLocation method = SendLocation.builder().chatId(chatId.getObjectAsString()).latitude(latitude.getObjectAsDouble()).longitude(longitude.getObjectAsDouble()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendMediaGroup(Var botToken, Var chatId, Var medias) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendMediaGroup method = SendMediaGroup.builder().chatId(chatId.getObjectAsString()).medias(medias.getObjectAsList()).build();
        List message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendPhoto(Var botToken, Var chatId, Var photo) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendPhoto method = SendPhoto.builder().chatId(chatId.getObjectAsString()).photo(new InputFile(photo.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendSticker(Var botToken, Var chatId, Var sticker) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendSticker method = SendSticker.builder().chatId(chatId.getObjectAsString()).sticker(new InputFile(sticker.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendVenue(Var botToken, Var chatId, Var latitude, Var longitude, Var title, Var address) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendVenue method = SendVenue.builder().chatId(chatId.getObjectAsString()).latitude(latitude.getObjectAsDouble()).longitude(longitude.getObjectAsDouble()).title(title.getObjectAsString()).address(address.getObjectAsString()).build();
        Message message = (Message)sender.execute((BotApiMethod)method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendVideo(Var botToken, Var chatId, Var video) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendVideo method = SendVideo.builder().chatId(chatId.getObjectAsString()).video(new InputFile(video.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendVideoNote(Var botToken, Var chatId, Var videoNote) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendVideoNote method = SendVideoNote.builder().chatId(chatId.getObjectAsString()).videoNote(new InputFile(videoNote.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }

    @CronapiMetaData
    public static Var sendVoice(Var botToken, Var chatId, Var voice) throws Exception {
        DefaultAbsSender sender = BotOperations.createSender(botToken.getObjectAsString());
        SendVoice method = SendVoice.builder().chatId(chatId.getObjectAsString()).voice(new InputFile(voice.getObjectAsString())).build();
        Message message = sender.execute(method);
        return Var.valueOf((Object)message);
    }
}

