/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.mailer;

import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.fs.FileSystemService;
import cronapp.framework.mailer.MailQueueRepository;
import cronapp.framework.mailer.MailerOptions;
import cronapp.framework.mailer.MailerService;
import cronapp.framework.mailer.model.MailQueue;
import cronapp.framework.scheduler.SchedulerHelper;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Date;
import javax.activation.DataSource;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;

@DisallowConcurrentExecution
public class MailerJob
implements Job {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MailerService mailer;
    private final MailQueueRepository repository;
    private final MailerOptions options;
    private final FileSystemService fileSystem;
    private final JavaMailSender sender;
    private CronappSettingsService settings;

    public MailerJob(MailerService mailer, MailQueueRepository repository, MailerOptions options, FileSystemService fileSystem, JavaMailSender sender, CronappSettingsService settings) {
        this.mailer = mailer;
        this.repository = repository;
        this.options = options;
        this.fileSystem = fileSystem;
        this.sender = sender;
        this.settings = settings;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Example mailQueueExample = Example.of((Object)MailQueue.newBuilder().setApplicationId(this.settings.getApplicationId()).build());
        Page mailQueues = this.repository.findAll(mailQueueExample, (Pageable)PageRequest.of((int)0, (int)this.options.getBatchSize(), (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"failedAt", "scheduledAt"}));
        mailQueues.forEach(mailQueue -> {
            try {
                MimeMessage message;
                DataSource resource = this.fileSystem.open(mailQueue.getContent(), this.options.getStorageName());
                try (InputStream resourceStream = resource.getInputStream();){
                    message = this.sender.createMimeMessage(resourceStream);
                }
                this.mailer.send(message);
                this.repository.delete(mailQueue);
            }
            catch (CronappFrameworkException | IOException e) {
                this.logger.error("Error sending message", e);
                mailQueue.setFailedAt(Date.from(Instant.now()));
                this.repository.save(mailQueue);
            }
        });
    }

    @Bean(name={"mailerJobDetail"})
    public JobDetailFactoryBean mailerJobDetail() {
        return SchedulerHelper.createJobDetail(this.getClass());
    }

    @Bean(name={"mailerJobTrigger"})
    public CronTriggerFactoryBean mailerJobTrigger(@Qualifier(value="mailerJobDetail") JobDetail jobDetail) {
        return SchedulerHelper.createCronTrigger((JobDetail)jobDetail, (String)this.options.getSchedulerExpression());
    }
}

