/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.mailer;

import cronapi.CronapiMetaData;
import cronapi.Variable;
import cronapi.VariableFactory;
import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.mailer.MailerService;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.validator.routines.UrlValidator;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

@CronapiMetaData
public final class MailerApi {
    @CronapiMetaData
    public static <T> T createMessage() throws MessagingException {
        JavaMailSender sender = (JavaMailSender)CronappConfiguration.getBean(JavaMailSender.class);
        MimeMessage message = sender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
        return (T)VariableFactory.getInstance().newVariable((Object)helper);
    }

    @CronapiMetaData
    public static void addAttachment(Variable messageVar, Variable nameVar, Variable resourceVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String name = nameVar.toString();
        DataSource dataSource = (DataSource)resourceVar.getTypedObject(DataSource.class);
        try {
            helper.addAttachment(name, dataSource);
        }
        catch (MessagingException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    @CronapiMetaData
    public static void addInlineAttachment(Variable contentIdVar, Variable messageVar, Variable resourceVar) throws Exception {
        DataSource dataSource;
        String contentId = contentIdVar.toString();
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        if (resourceVar.isString()) {
            String resource = resourceVar.getObjectAsString();
            if (UrlValidator.getInstance().isValid(resource)) {
                URL url = new URL(resource);
                dataSource = new URLDataSource(url);
            } else {
                dataSource = new FileDataSource(resource);
            }
        } else {
            dataSource = (DataSource)resourceVar.getTypedObject(DataSource.class);
        }
        try {
            helper.addInline(contentId, dataSource);
        }
        catch (MessagingException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    @CronapiMetaData
    public static void setText(Variable messageVar, Variable plainTextVar, Variable htmlTextVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String plainText = plainTextVar.toString();
        String htmlText = htmlTextVar.toString();
        try {
            if (!plainText.isEmpty() && !htmlText.isEmpty()) {
                helper.setText(plainText, htmlText);
            } else if (!plainText.isEmpty()) {
                helper.setText(plainText, false);
            } else if (!htmlText.isEmpty()) {
                helper.setText(htmlText, true);
            }
        }
        catch (MessagingException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    @CronapiMetaData
    public static void addTo(Variable messageVar, Variable addressVar, Variable nameVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String address = addressVar.toString();
        String name = nameVar.toString();
        try {
            helper.addTo(address, name);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new CronappFrameworkException(e);
        }
    }

    @CronapiMetaData
    public static void addCc(Variable messageVar, Variable addressVar, Variable nameVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String address = addressVar.toString();
        String name = nameVar.toString();
        try {
            helper.addCc(address, name);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new CronappFrameworkException(e);
        }
    }

    @CronapiMetaData
    public static void addBcc(Variable messageVar, Variable addressVar, Variable nameVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String address = addressVar.toString();
        String name = nameVar.toString();
        try {
            helper.addBcc(address, name);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new CronappFrameworkException(e);
        }
    }

    @CronapiMetaData
    public static void setSubject(Variable messageVar, Variable subjectVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String subject = subjectVar.toString();
        try {
            helper.setSubject(subject);
        }
        catch (MessagingException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    @CronapiMetaData
    public static void setFrom(Variable messageVar, Variable addressVar, Variable nameVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        String address = addressVar.toString();
        String name = nameVar.toString();
        try {
            helper.setFrom(address, name);
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new CronappFrameworkException(e);
        }
    }

    @CronapiMetaData
    public static void send(Variable messageVar) {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        MailerService service = (MailerService)CronappConfiguration.getBean(MailerService.class);
        service.send(helper.getMimeMessage());
    }

    @CronapiMetaData
    public static void schedule(Variable messageVar) throws CronappFrameworkException {
        MimeMessageHelper helper = (MimeMessageHelper)messageVar.getTypedObject(MimeMessageHelper.class);
        MailerService service = (MailerService)CronappConfiguration.getBean(MailerService.class);
        service.schedule(helper.getMimeMessage());
    }
}

