/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.mailer;

import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.fs.FileSystemService;
import cronapp.framework.mailer.MailQueueRepository;
import cronapp.framework.mailer.MailerOptions;
import cronapp.framework.mailer.MailerService;
import cronapp.framework.mailer.model.MailQueue;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import javax.activation.DataSource;
import org.springframework.mail.javamail.JavaMailSender;

public class MailerQueueService
implements MailerService {
    private final FileSystemService fileSystem;
    private final MailerOptions options;
    private final MailQueueRepository repository;
    private final JavaMailSender sender;
    private final CronappSettingsService settings;

    public MailerQueueService(FileSystemService fileSystem, MailerOptions options, MailQueueRepository repository, JavaMailSender sender, CronappSettingsService settings) {
        this.fileSystem = fileSystem;
        this.options = options;
        this.repository = repository;
        this.sender = sender;
        this.settings = settings;
    }

    @Override
    public String schedule(MimeMessage mimeMessage) throws CronappFrameworkException {
        String storagePath = this.options.getStoragePath();
        String storageName = this.options.getStorageName();
        String messagePath = Paths.get(storagePath, UUID.randomUUID().toString() + ".eml").toString();
        DataSource messageResource = this.fileSystem.open(messagePath, storageName);
        try (OutputStream messageStream = messageResource.getOutputStream();){
            mimeMessage.writeTo(messageStream);
        }
        catch (MessagingException | IOException e) {
            throw new CronappFrameworkException(e);
        }
        MailQueue message = MailQueue.newBuilder().setId(UUID.randomUUID().toString()).setApplicationId(this.settings.getApplicationId()).setContent(messagePath).setScheduledAt(Date.from(Instant.now())).setFailedAt(Date.from(Instant.EPOCH)).build();
        this.repository.save(message);
        return message.getId();
    }

    @Override
    public void send(MimeMessage mimeMessage) {
        this.sender.send(mimeMessage);
    }
}

