/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization;

import com.google.common.base.Suppliers;
import cronapp.framework.core.CronappMetadataRepository;
import cronapp.framework.core.model.CronappMetadata;
import cronapp.framework.customization.BindableServiceFactory;
import cronapp.framework.customization.CustomizationSession;
import cronapp.framework.customization.StartSessionArguments;
import cronapp.framework.customization.StartSessionResult;
import cronapp.framework.customization.StopSessionArguments;
import cronapp.framework.tunnel.TunnelSession;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.SocketUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CustomizationService {
    private final Logger logger = Logger.getLogger(CustomizationService.class.getName());
    private final Map<String, CustomizationSession> sessions = new HashMap<String, CustomizationSession>();
    private final Map<String, Server> servers = new HashMap<String, Server>();
    private final Map<String, TunnelSession> tunnels = new HashMap<String, TunnelSession>();
    private final List<BindableServiceFactory> bindableServiceFactories;
    private final Supplier<String> instanceId;
    @Value(value="${cronapp.tunnel.authToken}")
    private String authToken;

    public CustomizationService(List<BindableServiceFactory> bindableServiceFactories, CronappMetadataRepository metadataRepository) {
        this.bindableServiceFactories = bindableServiceFactories;
        this.instanceId = Suppliers.memoize(() -> ((CronappMetadata)metadataRepository.findById((Object)"instance.id").orElseThrow()).getValue());
    }

    @PostMapping(value={"/api/customization/start"})
    @ResponseBody
    public synchronized CompletableFuture<StartSessionResult> startSession(@RequestBody StartSessionArguments arguments) throws IOException {
        int port = SocketUtils.findAvailableTcpPort();
        String sessionId = UUID.randomUUID().toString();
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
        CustomizationSession session = CustomizationSession.newBuilder().setSessionId(sessionId).setInstanceId(this.instanceId.get()).setResourceName(this.appendResourceExtension(arguments)).setResourceType(arguments.getResourceType()).setAddress(address.toString()).build();
        NettyServerBuilder serverBuilder = NettyServerBuilder.forAddress((SocketAddress)address).maxMessageSize(Integer.MAX_VALUE);
        this.bindableServiceFactories.stream().map(factory -> factory.newBindableService(session)).forEach(arg_0 -> ((NettyServerBuilder)serverBuilder).addService(arg_0));
        Server server = serverBuilder.build();
        server.start();
        this.logger.log(Level.INFO, "Customization server started on local port {0} for session {1}", new Object[]{port, sessionId});
        TunnelSession tunnel = new TunnelSession(this.authToken, port);
        this.sessions.put(sessionId, session);
        this.servers.put(sessionId, server);
        this.tunnels.put(sessionId, tunnel);
        return CompletableFuture.completedFuture(StartSessionResult.newBuilder().setSessionId(sessionId).setCustomizationUrl("http://localhost:8080/workspace?customizationAddress=localhost:" + port).build());
    }

    @PostMapping(value={"/api/customization/stop"})
    public synchronized void stopSession(StopSessionArguments arguments) {
        String sessionId = arguments.getSessionId();
        Server server = this.servers.get(sessionId);
        if (server == null) {
            return;
        }
        server.shutdown();
        this.logger.log(Level.INFO, "Customization server stopped for session {1}", sessionId);
        this.servers.remove(sessionId);
        this.sessions.remove(sessionId);
        this.tunnels.remove(sessionId).close();
    }

    private String appendResourceExtension(StartSessionArguments arguments) {
        if (arguments.getResourceType().equals("diagram")) {
            return String.format("diagram/%s.umlcd", arguments.getResourceName());
        }
        if (arguments.getResourceType().equals("report")) {
            return String.format("%s.report", arguments.getResourceName());
        }
        return arguments.getResourceName();
    }
}

