/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.persistence.Column;
import javax.persistence.Id;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class EntityClassToJsonObjectConverter
implements Converter<Class<?>, JsonObject> {
    private static final String JAVA_SOURCE_PACKAGE = "src/main/java/";
    private static final String JAVA_EXTENSION = ".java";

    public JsonObject convert(@NonNull Class<?> source) {
        JsonArray fieldsArray = new JsonArray();
        for (Field field : source.getDeclaredFields()) {
            if (!this.canExtractField(field)) continue;
            fieldsArray.add((JsonElement)this.extractField(field));
        }
        JsonObject jsonUnit = new JsonObject();
        jsonUnit.addProperty("name", source.getSimpleName());
        jsonUnit.addProperty("namespace", source.getName());
        jsonUnit.addProperty("location", this.extractClassLocation(source.getName()));
        jsonUnit.add("fields", (JsonElement)fieldsArray);
        return jsonUnit;
    }

    private JsonObject extractField(@NonNull Field field) {
        JsonObject jsonField = new JsonObject();
        jsonField.addProperty("name", field.getName());
        jsonField.addProperty("type", field.getType().getSimpleName());
        jsonField.addProperty("nullable", Boolean.valueOf(false));
        jsonField.addProperty("key", Boolean.valueOf(field.isAnnotationPresent(Id.class)));
        Column annotation = field.getAnnotation(Column.class);
        if (annotation != null) {
            jsonField.addProperty("nullable", Boolean.valueOf(annotation.nullable()));
        }
        return jsonField;
    }

    private boolean canExtractField(@NonNull Field field) {
        int modifiers = field.getModifiers();
        String fieldName = field.getName();
        return Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers) && !"limit".equals(fieldName) && !"offset".equals(fieldName);
    }

    private String extractClassLocation(@NonNull String className) {
        return JAVA_SOURCE_PACKAGE + className.replace(".", "/") + JAVA_EXTENSION;
    }
}

