/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.dictionary.StiVariablesCollection;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.export.service.StiExportService;
import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.customization.reports.ContentTypeToExportFormatConverter;
import cronapp.framework.customization.reports.RenderedReportDto;
import cronapp.framework.customization.reports.Report;
import cronapp.framework.customization.reports.ReportNotFoundException;
import cronapp.framework.customization.reports.ReportRepository;
import cronapp.framework.customization.reports.ReportToStiReportConverter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service(value="runtimeReportService")
public class ReportService {
    private final ReportRepository repository;
    private final ReportToStiReportConverter reportConverter;
    private final ContentTypeToExportFormatConverter contentTypeConverter;

    @Autowired
    public ReportService(ReportRepository repository, ReportToStiReportConverter reportConverter, ContentTypeToExportFormatConverter contentTypeConverter) {
        this.repository = repository;
        this.reportConverter = reportConverter;
        this.contentTypeConverter = contentTypeConverter;
    }

    List<Report> findAll() {
        return this.repository.findAll();
    }

    Optional<Report> findById(@NonNull UUID id) {
        return this.repository.findById(id);
    }

    Optional<Report> findByName(@NonNull String name) {
        return this.repository.findByName(name);
    }

    Report save(@NonNull Report report) {
        if (report.getId() == null) {
            report.setCreatedAt(LocalDateTime.now());
        } else {
            report.setUpdatedAt(LocalDateTime.now());
        }
        return (Report)this.repository.save(report);
    }

    void deleteById(@NonNull UUID id) {
        this.repository.deleteById(id);
    }

    RenderedReportDto render(@NonNull UUID id, @NonNull String contentType) throws CronappFrameworkException {
        Report report = this.findById(id).orElseThrow(ReportNotFoundException::new);
        if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(contentType) || contentType.contains("application/json")) {
            return new RenderedReportDto(report.getName(), MediaType.APPLICATION_JSON, report.getContent().getBytes());
        }
        StiReport stiReport = this.reportConverter.convert(report);
        ContentTypeToExportFormatConverter.ExportFormatWrapper exportFormatWrapper = this.contentTypeConverter.convert(contentType);
        StiExportFormat exportFormat = exportFormatWrapper.getExportFormat();
        StiExportService exportService = exportFormat.getExportService();
        try {
            stiReport.Render();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            exportService.export(stiReport, (OutputStream)output, exportFormat.getDefaultExportSettings());
            return new RenderedReportDto(report.getName(), MediaType.valueOf((String)exportFormatWrapper.getMediaType()), output.toByteArray());
        }
        catch (StiException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    StiVariablesCollection listVariables(@NonNull UUID id) {
        Report report = this.findById(id).orElseThrow(ReportNotFoundException::new);
        StiReport stiReport = this.reportConverter.convert(report);
        return stiReport.getDictionary().getVariables();
    }
}

