/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.lang.NonNull;

@Entity
@Table(name="CRONAPP_REPORT")
public class Report {
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private UUID id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="CONTENT", nullable=false)
    private String content;
    @CreatedDate
    @Column(name="CREATED_AT", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="UPDATED_AT")
    private LocalDateTime updatedAt;

    public Report() {
    }

    public Report(@NonNull String name, @NonNull String content) {
        this.name = name;
        this.content = content;
    }

    UUID getId() {
        return this.id;
    }

    void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.id, report.id) && Objects.equals(this.name, report.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }
}

