/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.CronappDatabaseConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CronappPropertiesListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final String CONFIG_RESOURCE_LOCATION = "classpath:/config/cronapp";

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Properties properties;
        block13: {
            properties = new Properties();
            properties.put("server.error.includeMessage", "ALWAYS");
            if (event.getEnvironment().getProperty("logging.level.org.reflections") == null) {
                properties.put("logging.level.org.reflections", "WARN");
            }
            if (event.getEnvironment().getProperty("spring.liquibase.enabled") == null) {
                properties.put("spring.liquibase.enabled", (Object)false);
            }
            if (event.getEnvironment().getProperty("cronapp.datasource.url") == null && CronappDatabaseConfiguration.getCronappDataSourceName().isEmpty()) {
                properties.put("cronapp.feature.database", (Object)false);
                properties.put("cronapp.feature.liquibase", (Object)false);
                properties.put("management.health.db", (Object)false);
            } else {
                properties.put("cronapp.feature.database", (Object)true);
            }
            try {
                PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
                if (!resourceResolver.getResource(CONFIG_RESOURCE_LOCATION).exists()) break block13;
                Resource[] configResources = resourceResolver.getResources("classpath:/config/cronapp/*.properties");
                for (int i = 0; i < configResources.length; ++i) {
                    Properties configProperties = new Properties();
                    Resource configResource = configResources[i];
                    try (InputStream configStream = configResource.getInputStream();){
                        configProperties.load(configStream);
                    }
                    event.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("cronapp-" + i, configProperties));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        event.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("cronapp", properties));
    }

    public int getOrder() {
        return -2147483629;
    }
}

