/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import cronapp.framework.core.CronappConfiguration;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.change.DatabaseChange;
import liquibase.change.custom.CustomChange;
import liquibase.change.custom.CustomChangeWrapper;
import liquibase.exception.CustomChangeException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.beanutils.PropertyUtils;

@DatabaseChange(name="customChange", priority=2, description="customChange, with DI support")
public class SpringChangeWrapper
extends CustomChangeWrapper {
    private String className;

    public String getClassName() {
        return this.className;
    }

    public CustomChangeWrapper setClass(String className) throws CustomChangeException {
        if (className == null) {
            return this;
        }
        this.className = className;
        try {
            this.customChange = (CustomChange)CronappConfiguration.autowire(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new CustomChangeException((Throwable)e);
        }
        return this;
    }

    public void customLoadLogic(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        Set descriptors;
        ParsedNode paramsNode = parsedNode.getChild(null, "params");
        if (paramsNode == null) {
            paramsNode = parsedNode;
        }
        for (ParsedNode child : paramsNode.getChildren(null, "param")) {
            Object value = child.getValue();
            if (value == null) {
                value = child.getChildValue(null, "value");
            }
            if (value != null) {
                value = value.toString();
            }
            this.setParam((String)child.getChildValue(null, "name", String.class), (String)value);
        }
        try {
            Class<?> customChangeClass = Class.forName(this.className, false, SpringChangeWrapper.class.getClassLoader());
            descriptors = Arrays.stream(PropertyUtils.getPropertyDescriptors(customChangeClass)).map(FeatureDescriptor::getName).collect(Collectors.toSet());
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        for (ParsedNode node : parsedNode.getChildren()) {
            Object value = node.getValue();
            if (value == null || !descriptors.contains(node.getName())) continue;
            this.setParam(node.getName(), value.toString());
        }
    }
}

