/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.CronappDatabaseConfiguration;
import java.util.Properties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class CronappPropertiesListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Properties properties = new Properties();
        properties.put("server.error.includeMessage", "ALWAYS");
        if (event.getEnvironment().getProperty("logging.level.org.reflections") == null) {
            properties.put("logging.level.org.reflections", "WARN");
        }
        if (event.getEnvironment().getProperty("spring.liquibase.enabled") == null) {
            properties.put("spring.liquibase.enabled", (Object)false);
        }
        if (event.getEnvironment().getProperty("cronapp.datasource.url") == null && CronappDatabaseConfiguration.getCronappDataSourceName().isEmpty()) {
            properties.put("cronapp.feature.database", (Object)false);
            properties.put("cronapp.feature.liquibase", (Object)false);
            properties.put("management.health.db", (Object)false);
        } else {
            properties.put("cronapp.feature.database", (Object)true);
        }
        event.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("cronapp", properties));
    }

    public int getOrder() {
        return -2147483629;
    }
}

