/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.EntityManagerConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.jpa.Archive;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jndi.JndiTemplate;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(value={"cronapp.feature.database"})
@EnableJpaRepositories(basePackageClasses={CronappConfiguration.class}, entityManagerFactoryRef="cronappEntityManagerFactoryBean", transactionManagerRef="cronappTransactionManager")
public class CronappDatabaseConfiguration {
    private static Stream<? extends SEPersistenceUnitInfo> getPersistenceUnits(Archive archive) {
        return PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader()).stream();
    }

    public static Optional<String> getCronappDataSourceName() {
        return PersistenceUnitProcessor.findPersistenceArchives().stream().flatMap(CronappDatabaseConfiguration::getPersistenceUnits).filter(info -> info.getPersistenceUnitName().equals("app")).map(SEPersistenceUnitInfo::getNonJtaDataSource).map(dataSource -> ((DataSourceImpl)dataSource).getName()).findFirst();
    }

    @Bean(name={"cronappDataSource"})
    public DataSource cronappDataSource(@Value(value="${cronapp.datasource.url:#{null}}") Optional<String> dataSourceUrl, @Value(value="${cronapp.datasource.username:#{null}}") Optional<String> dataSourceUsername, @Value(value="${cronapp.datasource.password:#{null}}") Optional<String> dataSourcePassword, @Value(value="${cronapp.datasource.driver:#{null}}") Optional<String> dataSourceDriver) throws NamingException {
        if (dataSourceUrl.isPresent()) {
            BasicDataSource dataSource = new BasicDataSource();
            dataSourceUrl.ifPresent(arg_0 -> ((BasicDataSource)dataSource).setUrl(arg_0));
            dataSourceUsername.ifPresent(arg_0 -> ((BasicDataSource)dataSource).setUsername(arg_0));
            dataSourcePassword.ifPresent(arg_0 -> ((BasicDataSource)dataSource).setPassword(arg_0));
            dataSourceDriver.ifPresent(arg_0 -> ((BasicDataSource)dataSource).setDriverClassName(arg_0));
            return dataSource;
        }
        Optional<String> dataSourceName = CronappDatabaseConfiguration.getCronappDataSourceName();
        if (dataSourceName.isEmpty()) {
            return null;
        }
        return (DataSource)new JndiTemplate().lookup(dataSourceName.get(), DataSource.class);
    }

    @Bean
    public EntityManagerConfiguration coreEntityManagerConfiguration() {
        return EntityManagerConfiguration.builder().packageToScan(this.getClass().getPackage().getName()).build();
    }

    @Bean
    public AbstractEntityManagerFactoryBean cronappEntityManagerFactoryBean(@Qualifier(value="cronappDataSource") DataSource dataSource, List<EntityManagerConfiguration> configurations, JpaVendorAdapter jpaVendorAdapter) {
        HashMap<String, String> jpaProperties = new HashMap<String, String>();
        jpaProperties.put("eclipselink.weaving", "false");
        LocalContainerEntityManagerFactoryBean emf = new LocalContainerEntityManagerFactoryBean();
        emf.setDataSource(dataSource);
        emf.setPackagesToScan((String[])configurations.stream().map(EntityManagerConfiguration::getPackageToScan).toArray(String[]::new));
        emf.setPersistenceUnitName("cronapp.framework.core");
        emf.setJpaVendorAdapter(jpaVendorAdapter);
        emf.setJpaPropertyMap(jpaProperties);
        return emf;
    }

    @Bean
    public JpaVendorAdapter jpaVendorAdapter() {
        return new EclipseLinkJpaVendorAdapter();
    }

    @Bean
    public EntityManagerFactory cronappEntityManagerFactory(@Qualifier(value="cronappEntityManagerFactoryBean") AbstractEntityManagerFactoryBean factoryBean) {
        return factoryBean.getObject();
    }

    @Bean
    public PlatformTransactionManager cronappTransactionManager(@Qualifier(value="cronappEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }
}

