/*
 * Decompiled with CFR 0.152.
 */
package cronapi.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import cronapi.CronapiConfigurator;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Utils;
import cronapi.Var;
import cronapi.database.DataSource;
import java.io.FileInputStream;
import java.util.List;
import java.util.Map;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Text;
import org.jdom2.xpath.XPathFactory;
import org.json.JSONObject;
import org.json.XML;

@CronapiMetaData(category=CronapiMetaData.CategoryType.JSON, categoryTags={"Json"})
public class Operations {
    public static final Configuration GSON_CONFIGURATION = Configuration.builder().mappingProvider((MappingProvider)new GsonMappingProvider()).jsonProvider((JsonProvider)new GsonJsonProvider()).build();

    @CronapiMetaData(type="function", name="{{createObjectJson}}", nameTags={"createObjectJson"}, description="{{functionToCreateObjectJson}}", returnType=CronapiMetaData.ObjectType.JSON)
    public static final Var createObjectJson() throws Exception {
        Var value = new Var(new JsonObject());
        return value;
    }

    @CronapiMetaData(type="function", name="{{deleteObjectFromJson}}", nameTags={"createObjectJson"}, description="{{deleteObjectFromJsonDescription}}", returnType=CronapiMetaData.ObjectType.JSON)
    public static final void deleteObjectFromJson(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{mapOrJsonVar}}") Var object, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathKey}}") Var key) throws Exception {
        object.getObjectAsJson().getAsJsonObject().remove(key.getObjectAsString());
    }

    private static String join(String separator, List input) {
        if (input == null || input.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.size(); ++i) {
            if (input.get(i) instanceof Text) {
                sb.append(((Text)input.get(i)).getText());
            } else if (input.get(i) instanceof Attribute) {
                sb.append(((Attribute)input.get(i)).getValue());
            } else {
                sb.append(input.get(i));
            }
            if (i == input.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    @CronapiMetaData(type="function", name="{{getJsonOrMapField}}", nameTags={"getJsonOrMapField"}, description="{{functionToGetJsonOrMapField}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var getJsonOrMapField(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{mapOrJsonVar}}") Var mapVar, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathKey}}") Var keyVar) throws Exception {
        Var value = Var.VAR_NULL;
        Object obj = mapVar.getObject();
        String key = keyVar.toString();
        if (obj instanceof DataSource) {
            obj = ((DataSource)obj).getObject();
        }
        if (key.startsWith("$")) {
            if (mapVar.getObject() instanceof Document) {
                XPathFactory xFactory = XPathFactory.instance();
                List result = xFactory.compile(keyVar.getObjectAsString().substring(1)).evaluate(mapVar.getObject());
                if (keyVar.getObjectAsString().endsWith("text()") || keyVar.getObjectAsString().matches(".*@\\w+$")) {
                    return Var.valueOf(Operations.join(" ", result));
                }
                return Var.valueOf(result);
            }
            JsonElement jsonToBeSearched = mapVar.getObjectAsJson();
            Object result = JsonPath.using((Configuration)GSON_CONFIGURATION).parse((Object)jsonToBeSearched).read(key, new Predicate[0]);
            return Var.valueOf(result);
        }
        String[] path = key.toString().split("\\.");
        for (int i = 0; i < path.length; ++i) {
            String k = path[i];
            if (obj == null) continue;
            if (i == path.length - 1) {
                value = Var.valueOf(Utils.mapGetObjectPathExtractElement(obj, k, false));
                continue;
            }
            obj = Utils.mapGetObjectPathExtractElement(obj, k, false);
        }
        return value;
    }

    @CronapiMetaData(type="function", name="{{setJsonOrMapField}}", nameTags={"setJsonOrMapField"}, description="{{functionToSetJsonOrMapField}}", returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setJsonOrMapField(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{mapOrJsonVar}}") Var mapVar, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathKey}}") Var keyVar, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{valueToBetSet}}") Var value) throws Exception {
        Object obj = mapVar.getObject();
        Object key = keyVar.getObject();
        if (obj instanceof DataSource) {
            obj = ((DataSource)obj).getObject();
        }
        String[] path = key.toString().split("\\.");
        for (int i = 0; i < path.length; ++i) {
            String k = path[i];
            if (obj == null) continue;
            if (i == path.length - 1) {
                Utils.mapSetObject(obj, k, value);
                continue;
            }
            obj = Utils.mapGetObjectPathExtractElement(obj, k, true);
        }
    }

    @CronapiMetaData(type="function", name="{{toJson}}", nameTags={"toJson"}, description="{{functionToJson}}", returnType=CronapiMetaData.ObjectType.JSON)
    public static final Var toJson(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{valueToBeRead}}") Var valueToBeRead) throws Exception {
        return Var.valueOf(valueToBeRead.getObject(JsonElement.class));
    }

    @CronapiMetaData(type="function", name="{{JSONtoList}}", nameTags={"toList", "Para Lista"}, description="{{functionToList}}", returnType=CronapiMetaData.ObjectType.LIST)
    public static final Var toList(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{valueToBeRead}}") Var valueToBeRead) throws Exception {
        return Operations.toMap(valueToBeRead);
    }

    @CronapiMetaData(type="function", name="{{toMap}}", nameTags={"toMap", "Para Mapa"}, description="{{functionToMap}}", returnType=CronapiMetaData.ObjectType.MAP)
    public static final Var toMap(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{valueToBeRead}}") Var valueToBeRead) throws Exception {
        Object obj = null;
        String content = "";
        Gson c = new Gson();
        if (valueToBeRead.getObject() instanceof String) {
            content = valueToBeRead.getObjectAsString();
        } else if (valueToBeRead.getObject() instanceof FileInputStream) {
            content = cronapi.io.Operations.fileReadAll(valueToBeRead).getObjectAsString();
        }
        obj = content.startsWith("[") ? c.fromJson(content, List.class) : c.fromJson(content, Map.class);
        return Var.valueOf(obj);
    }

    @CronapiMetaData(type="function", name="{{JSONToXML}}", nameTags={"xml", "JSON"}, description="{{JSONToXMLDescription}}", params={"{{XMLOpenFromStringParam0}}"}, paramsType={CronapiMetaData.ObjectType.OBJECT}, returnType=CronapiMetaData.ObjectType.XML)
    public static final Var toXml(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{JSONTOXMLValueToBeRead}}") Var json) throws Exception {
        JSONObject jsonFileObject = new JSONObject(json.getObjectAsString());
        String xml = "<?xml version=\"1.0\" encoding=\"" + CronapiConfigurator.ENCODING + "\"?>\n<root>".concat(XML.toString((Object)jsonFileObject)).concat("</root>");
        return cronapi.xml.Operations.xmlFromStrng(Var.valueOf(xml));
    }
}

